/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ResourcePoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private Object userHandle;
    private ResourcePoolManager poolMgr = Switch.getSwitch().getResourcePoolManager();
    private ManagedConnection localConnection;
    private IASPoolObject poolObject;
    private ManagedConnection managedConnection;
    private IASPoolHelper poolHelper;
    private Subject subject;
    private Transaction transaction;

    public XAResourceImpl(ManagedConnection managedConnection, Object object, IASPoolObject iASPoolObject, IASPoolHelper iASPoolHelper, Subject subject, Transaction transaction) {
        this.managedConnection = managedConnection;
        this.userHandle = object;
        this.poolObject = iASPoolObject;
        this.poolHelper = iASPoolHelper;
        this.subject = subject;
        this.transaction = transaction;
        this.localConnection = managedConnection;
    }

    private void handleResourceException(Exception exception) throws XAException {
        XAException xAException = new XAException(exception.toString());
        xAException.errorCode = -3;
        throw xAException;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            this.managedConnection.getLocalTransaction().commit();
            this.notifyPoolManager();
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            this.startLocalTransaction();
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public void end(Xid xid, int n) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this == xAResource) {
            return true;
        }
        if (xAResource == null) {
            return false;
        }
        if (xAResource instanceof XAResourceImpl) {
            XAResourceImpl xAResourceImpl = (XAResourceImpl)xAResource;
            if (this.subject != null) {
                return this.poolHelper.equals(xAResourceImpl.poolHelper) && this.subject.equals(xAResourceImpl.subject);
            }
            return this.poolHelper.equals(xAResourceImpl.poolHelper) && xAResourceImpl.subject == null;
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int n) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.managedConnection.getLocalTransaction().rollback();
            this.notifyPoolManager();
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    private void startLocalTransaction() throws ResourceException {
        if (this.poolObject.getShareCount() == 0) {
            this.managedConnection.getLocalTransaction().begin();
        }
    }

    private void notifyPoolManager() throws IASPoolManagerException {
        this.poolMgr.doneCommitOrRollback(this.poolObject, this.poolHelper, this.subject, this.transaction);
    }
}

