/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.AbstractSystemJdbcAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import javax.naming.Context;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SystemJdbc20XaAllocator
extends AbstractSystemJdbcAllocator {
    private String jndiName;

    public SystemJdbc20XaAllocator(PoolManager poolManager, String string, ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo) {
        super(poolManager, resourceSpec, clientSecurityInfo);
        this.jndiName = string;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            Context context = Switch.getSwitch().getNamingManager().getInitialContext();
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)context.lookup(this.jndiName);
            XADataSource xADataSource = (XADataSource)jdbcConnectionPool.createDataSource();
            ResourcePrincipal resourcePrincipal = this.info.getPrincipal();
            XAConnection xAConnection = resourcePrincipal.isDefault() ? xADataSource.getXAConnection() : xADataSource.getXAConnection(resourcePrincipal.getName(), resourcePrincipal.getPassword());
            ResourceHandle resourceHandle = new ResourceHandle(xAConnection, this.spec, this, this.info);
            AbstractSystemJdbcAllocator.ConnectionListenerImpl connectionListenerImpl = new AbstractSystemJdbcAllocator.ConnectionListenerImpl(resourceHandle);
            xAConnection.addConnectionEventListener(connectionListenerImpl);
            this.getListenerTable().put(resourceHandle, connectionListenerImpl);
            return resourceHandle;
        }
        catch (Exception exception) {
            if (exception instanceof PoolingException) {
                throw (PoolingException)exception;
            }
            throw new PoolingException(exception);
        }
    }
}

