/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ResourcePoolManager;
import com.sun.enterprise.resource.IASConfigPool;
import com.sun.enterprise.resource.IASGenericPoolObjects;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.IASPoolManagerConstants;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import com.sun.enterprise.resource.IASPoolWrapper;
import com.sun.enterprise.resource.PortabilityUtils;
import com.sun.enterprise.resource.ResourceHandle;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class ResourcePoolManagerImpl
implements ResourcePoolManager {
    private HashMap poolsHashTable = null;
    private long monitorInterval = 1000L;
    private int minUnusedMaxLife = -1;
    private HashSet transactionSet = null;
    private TimerTask timerTask = null;
    private Timer timer = PortabilityUtils.GetTimer();
    static Logger _logger = PortabilityUtils.GetPoolManagerLogger();

    public ResourcePoolManagerImpl() {
        this.poolsHashTable = new HashMap(11);
        this.transactionSet = new HashSet(11);
        _logger.log(Level.FINE, "In end of IASPoolManager constructor");
    }

    public IASPoolObject getPooledConnection(IASPoolHelper iASPoolHelper, Object object, Subject subject, Transaction transaction, boolean bl) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASPoolManager.beginHandlePoolManager(...)");
        IASPoolObject iASPoolObject = null;
        IASGenericPoolObjects iASGenericPoolObjects = null;
        _logger.log(Level.FINE, "Before getGenericPool");
        iASGenericPoolObjects = this.getGenericPool(iASPoolHelper, subject);
        _logger.log(Level.FINE, "After getGenericPool");
        iASPoolObject = iASGenericPoolObjects.getPoolObject(object, subject, transaction, bl);
        _logger.log(Level.FINE, "In end of IASPoolManager.beginHandlePoolManager(...)");
        return iASPoolObject;
    }

    private String getPrincipalFromSubject(final Subject subject) {
        _logger.log(Level.FINE, "In start of ResourcePoolManager.getPrincipalFromSubject(...)");
        PasswordCredential passwordCredential = null;
        passwordCredential = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<Object> set = subject.getPrivateCredentials();
                if (set != null) {
                    Iterator<Object> iterator = set.iterator();
                    PasswordCredential passwordCredential = null;
                    if (iterator.hasNext()) {
                        passwordCredential = (PasswordCredential)iterator.next();
                        return passwordCredential;
                    }
                    return passwordCredential;
                }
                return null;
            }
        });
        if (passwordCredential == null) {
            return null;
        }
        String string = passwordCredential.getUserName();
        _logger.log(Level.FINE, "principalName: " + string);
        _logger.log(Level.FINE, "In end of ResourcePoolManager.getPrincipalFromSubject(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IASPoolWrapper createNewPoolWrapper(IASPoolHelper iASPoolHelper) {
        _logger.log(Level.FINE, "In start of IASPoolManager.createNewPoolWrapper(...)");
        IASConfigPool iASConfigPool = iASPoolHelper.getConfigPool();
        if (iASConfigPool == null) {
            iASConfigPool = new IASConfigPool();
        }
        int n = iASConfigPool.getUnusedMaxLife();
        boolean bl = false;
        IASPoolWrapper iASPoolWrapper = null;
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (this.minUnusedMaxLife == -1) {
                long l = n * 10;
                l /= 100L;
                this.monitorInterval = l = Math.max(1000L, l);
                this.minUnusedMaxLife = n;
                bl = true;
                _logger.log(Level.FINE, "Inside if(minUnusedMaxLife == -1).");
                _logger.log(Level.FINE, "monitorInterval: " + this.monitorInterval);
                _logger.log(Level.FINE, "minUnusedMaxLife: " + this.minUnusedMaxLife);
            } else if (this.minUnusedMaxLife > n) {
                long l = n * 10;
                l /= 100L;
                this.monitorInterval = l = Math.max(1000L, l);
                this.minUnusedMaxLife = n;
                this.timerTask.cancel();
                bl = true;
                _logger.log(Level.FINE, "Inside if(minUnusedMaxLife > unusedMaxLife).");
                _logger.log(Level.FINE, "monitorInterval: " + this.monitorInterval);
                _logger.log(Level.FINE, "minUnusedMaxLife: " + this.minUnusedMaxLife);
            }
            iASPoolWrapper = new IASPoolWrapper(iASPoolHelper, iASConfigPool);
            this.poolsHashTable.put(iASPoolHelper, iASPoolWrapper);
            if (bl) {
                this.startMonitorThread();
            }
        }
        _logger.log(Level.FINE, "In end of IASPoolManager.createNewPoolWrapper(...)");
        return iASPoolWrapper;
    }

    private void startMonitorThread() {
        _logger.log(Level.FINE, "In start of IASPoolManager.startMonitorThread()");
        this.timerTask = new Resizer();
        try {
            this.timer.scheduleAtFixedRate(this.timerTask, this.monitorInterval, this.monitorInterval);
        }
        catch (RuntimeException runtimeException) {
            _logger.log(Level.FINE, ">>>>>>>>>>>>>>RuntimeException: " + runtimeException.getMessage());
            _logger.log(Level.FINE, ">>>>>>>>>>>>>>RuntimeException: " + runtimeException.toString());
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, ">>>>>>>>>>>>>>Exception: " + exception.getMessage());
            _logger.log(Level.FINE, ">>>>>>>>>>>>>>Exception: " + exception.toString());
        }
        _logger.log(Level.FINE, "In end of IASPoolManager.startMonitorThread()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IASGenericPoolObjects getGenericPool(IASPoolHelper iASPoolHelper, Subject subject) {
        _logger.log(Level.FINE, "In start of ResourcePoolManager.getGenericPool(...)");
        IASGenericPoolObjects iASGenericPoolObjects = null;
        IASPoolWrapper iASPoolWrapper = null;
        String string = null;
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            iASPoolWrapper = this.poolsHashTable.containsKey(iASPoolHelper) ? (IASPoolWrapper)this.poolsHashTable.get(iASPoolHelper) : this.createNewPoolWrapper(iASPoolHelper);
        }
        if (subject != null) {
            _logger.log(Level.FINE, "subject != null");
            string = this.getPrincipalFromSubject(subject);
            _logger.log(Level.FINE, "Before poolWrapper.getPrincipalPool");
            iASGenericPoolObjects = iASPoolWrapper.getPrincipalPool(string);
            _logger.log(Level.FINE, "After poolWrapper.getPrincipalPool");
        } else {
            iASGenericPoolObjects = iASPoolWrapper.getDefaultPool();
        }
        _logger.log(Level.FINE, "In end of ResourcePoolManager.getGenericPool(...)");
        return iASGenericPoolObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceEnlisted(Transaction transaction, ResourceHandle resourceHandle) throws IllegalStateException, RollbackException, SystemException {
        _logger.log(Level.FINE, "In start of ResourcePoolManager.resourceEnlisted(...)");
        IASGenericPoolObjects iASGenericPoolObjects = null;
        HashSet hashSet = this.transactionSet;
        synchronized (hashSet) {
            if (!this.transactionSet.contains(transaction)) {
                this.transactionSet.add(transaction);
                SynchronizationListener synchronizationListener = new SynchronizationListener(transaction);
                transaction.registerSynchronization((Synchronization)synchronizationListener);
            }
        }
        iASGenericPoolObjects = this.getGenericPool(resourceHandle.getPoolHelper(), resourceHandle.getSubject());
        if (iASGenericPoolObjects != null) {
            iASGenericPoolObjects.resourceEnlisted(transaction, resourceHandle);
        }
        _logger.log(Level.FINE, "In end of ResourcePoolManager.resourceEnlisted(...)");
    }

    public void doneCommitOrRollback(IASPoolObject iASPoolObject, IASPoolHelper iASPoolHelper, Subject subject, Transaction transaction) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of ResourcePoolManager.doneCommitOrRollback(...)");
        IASGenericPoolObjects iASGenericPoolObjects = null;
        iASGenericPoolObjects = this.getGenericPool(iASPoolHelper, subject);
        if (iASGenericPoolObjects != null) {
            iASGenericPoolObjects.doneCommitOrRollback(iASPoolObject, transaction);
        }
        _logger.log(Level.FINE, "In end of ResourcePoolManager.doneCommitOrRollback(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionCompleted(Transaction transaction) throws IllegalStateException, IASPoolManagerException {
        _logger.log(Level.FINE, "In start of ResourcePoolManager.transactionCompleted(...)");
        IASGenericPoolObjects iASGenericPoolObjects = null;
        HashMap hashMap = null;
        HashMap hashMap2 = this.poolsHashTable;
        synchronized (hashMap2) {
            if (!this.poolsHashTable.isEmpty()) {
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    iASGenericPoolObjects = iASPoolWrapper.getDefaultPool();
                    if (iASGenericPoolObjects != null) {
                        iASGenericPoolObjects.transactionCompleted(transaction);
                    }
                    if ((hashMap = iASPoolWrapper.getPrincipalPoolTable()).isEmpty()) continue;
                    Collection collection2 = hashMap.values();
                    iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        iASGenericPoolObjects = (IASGenericPoolObjects)iterator.next();
                        if (iASGenericPoolObjects == null) continue;
                        iASGenericPoolObjects.transactionCompleted(transaction);
                    }
                }
            }
        }
        _logger.log(Level.FINE, "In end of ResourcePoolManager.transactionCompleted(...)");
    }

    public static String getVersion() {
        return "Pool Manager version 1.0 from 24-June-2001";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePools(IASPoolHelper iASPoolHelper) {
        _logger.log(Level.FINE, "In start of ResourcePoolManager.removePools(...)");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            this.poolsHashTable.remove(iASPoolHelper);
        }
        _logger.log(Level.FINE, "In end of ResourcePoolManager.removePools(...)");
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumberOfPools() {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getTotalNumberOfPools(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            int n = 0;
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    n += iASPoolWrapper.getNumOfPools();
                }
            }
            _logger.log(Level.FINE, "TotalNumberOfPools: " + n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IASConfigPool getConfigPoolTable(String string) {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getConfigPoolTable(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    if (!iASPoolWrapper.getJndiName().equals(string)) continue;
                    _logger.log(Level.FINE, "Find jndiName " + string);
                    return iASPoolWrapper.getPoolConfig();
                }
            }
            _logger.log(Level.FINE, "pool's configuration table is null.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAgeObjectArray(String string, String string2) {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getAgeObjectArray(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    if (!iASPoolWrapper.getJndiName().equals(string)) continue;
                    _logger.log(Level.FINE, "Find jndiName " + string);
                    IASGenericPoolObjects iASGenericPoolObjects = iASPoolWrapper.findPool(string2);
                    if (iASGenericPoolObjects != null) {
                        _logger.log(Level.FINE, "Find pool " + string2);
                        _logger.log(Level.FINE, "Return array of objects's age for pool " + string2);
                        return iASGenericPoolObjects.getAgeObjectArray();
                    }
                    return null;
                }
            }
            _logger.log(Level.FINE, "Array of objects's age for pool " + string2 + " is null.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumOfObjectsCreated(String string, String string2) {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getTotalNumOfObjectsCreated(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    if (!iASPoolWrapper.getJndiName().equals(string)) continue;
                    _logger.log(Level.FINE, "Find jndiName " + string);
                    IASGenericPoolObjects iASGenericPoolObjects = iASPoolWrapper.findPool(string2);
                    if (iASGenericPoolObjects != null) {
                        _logger.log(Level.FINE, "Find pool " + string2);
                        _logger.log(Level.FINE, "Return total number of objects that were created for pool " + string2);
                        return iASGenericPoolObjects.getTotalNumOfObjectsCreated();
                    }
                    return 0;
                }
            }
            _logger.log(Level.FINE, "Total number of objects that were created for pool " + string2 + " is 0.");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumOfObjectsNotInUse(String string, String string2) {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getTotalNumOfObjectsNotInUse(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    if (!iASPoolWrapper.getJndiName().equals(string)) continue;
                    _logger.log(Level.FINE, "Find jndiName " + string);
                    IASGenericPoolObjects iASGenericPoolObjects = iASPoolWrapper.findPool(string2);
                    if (iASGenericPoolObjects != null) {
                        _logger.log(Level.FINE, "Find pool " + string2);
                        _logger.log(Level.FINE, "Return total number of objects that are present for pool " + string2);
                        return iASGenericPoolObjects.getTotalNumOfObjectsNotInUse();
                    }
                    return 0;
                }
            }
            _logger.log(Level.FINE, "Total number of objects that are present for pool " + string2 + " is 0.");
            return 0;
        }
    }

    public int getTotalNumOfObjectsInUse(String string, String string2) {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getTotalNumOfObjectsInUse(). ");
        int n = this.getTotalNumOfObjectsCreated(string, string2);
        _logger.log(Level.FINE, "totalNumOfObjectsCreated: " + n);
        int n2 = this.getTotalNumOfObjectsNotInUse(string, string2);
        _logger.log(Level.FINE, "totalNumOfObjectsNotInUse: " + n2);
        int n3 = n - n2;
        _logger.log(Level.FINE, "totalNumOfObjectsInUse: " + n3);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumOfObjectsDestroyed(String string, String string2) {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getTotalNumOfObjectsDestroyed(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    if (!iASPoolWrapper.getJndiName().equals(string)) continue;
                    _logger.log(Level.FINE, "Find jndiName " + string);
                    IASGenericPoolObjects iASGenericPoolObjects = iASPoolWrapper.findPool(string2);
                    if (iASGenericPoolObjects != null) {
                        _logger.log(Level.FINE, "Find pool " + string2);
                        _logger.log(Level.FINE, "Return total number of objects that were destroyed for pool " + string2);
                        return iASGenericPoolObjects.getTotalNumOfObjectsDestroyed();
                    }
                    return 0;
                }
            }
            _logger.log(Level.FINE, "Total number of objects that were destroyed for pool " + string2 + " is 0.");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getJNDINameTable() {
        _logger.log(Level.FINE, "In ResourcePoolManagerImpl.getJNDINameTable(). ");
        HashMap hashMap = this.poolsHashTable;
        synchronized (hashMap) {
            if (!this.poolsHashTable.isEmpty()) {
                _logger.log(Level.FINE, "poolsHashTable not empty.");
                Collection collection = this.poolsHashTable.values();
                Iterator iterator = collection.iterator();
                ArrayList<String> arrayList = null;
                HashMap hashMap2 = new HashMap(11);
                while (iterator.hasNext()) {
                    IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                    arrayList = new ArrayList<String>();
                    arrayList.add(iASPoolWrapper.nameDefaultPool);
                    Set set = iASPoolWrapper.getListOfPoolsNames();
                    if (set != null) {
                        _logger.log(Level.FINE, "List of principal pools not empty.");
                        Iterator iterator2 = set.iterator();
                        while (iterator2.hasNext()) {
                            arrayList.add((String)iterator2.next());
                        }
                    }
                    hashMap2.put(iASPoolWrapper.getJndiName(), arrayList);
                }
                _logger.log(Level.FINE, "List of JNDI names not empty.");
                return hashMap2;
            }
            _logger.log(Level.FINE, "List of JNDI names is null.");
            return null;
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashMap hashMap = ResourcePoolManagerImpl.this.poolsHashTable;
            synchronized (hashMap) {
                if (!ResourcePoolManagerImpl.this.poolsHashTable.isEmpty()) {
                    Collection collection = ResourcePoolManagerImpl.this.poolsHashTable.values();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        IASPoolWrapper iASPoolWrapper = (IASPoolWrapper)iterator.next();
                        iASPoolWrapper.checkWrapperPoolSize();
                    }
                }
            }
        }
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction transaction;

        SynchronizationListener(Transaction transaction) {
            this.transaction = transaction;
        }

        public void afterCompletion(int n) {
            try {
                ResourcePoolManagerImpl.this.transactionCompleted(this.transaction);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[]{illegalStateException.getMessage()};
                _logger.log(Level.SEVERE, "poolmgr.complete_transaction_error", MessageFormat.format(IASPoolManagerConstants.COMPLETE_TRANSACTION_ERROR, objectArray));
            }
            catch (IASPoolManagerException iASPoolManagerException) {
                Object[] objectArray = new Object[]{iASPoolManagerException.getMessage()};
                _logger.log(Level.SEVERE, "poolmgr.complete_transaction_error", MessageFormat.format(IASPoolManagerConstants.COMPLETE_TRANSACTION_ERROR, objectArray));
            }
        }

        public void beforeCompletion() {
        }
    }
}

