/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.IASResourcePoolMonitorImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

public class PoolManagerImpl
implements PoolManager {
    private static final boolean debug = false;
    private static final long DEFAULT_SLEEPTIME = 10L;
    private Hashtable poolTable = new Hashtable();
    private Hashtable monitorObjectTable = new Hashtable();
    private HashSet pendingTxns = new HashSet();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PoolManagerImpl.class);
    private Hashtable xid2Connections = new Hashtable();
    static Logger _logger = null;

    private boolean isTransactionActive(Transaction transaction) {
        return transaction != null;
    }

    public Object getResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo) throws PoolingException {
        Object object;
        Transaction transaction = null;
        boolean bl = resourceAllocator.isTransactional();
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        if (bl) {
            transaction = componentInvocation.getTransaction();
        }
        if (resourceAllocator.shareableWithinComponent()) {
            object = Switch.getSwitch().getTransactionManager();
            Object object2 = componentInvocation.getInstance();
            if (object2 != null) {
                List list = object.getResourceList(object2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                    if (resourceHandle.getResourceSpec() == null || resourceHandle.getClientSecurityInfo() == null || !resourceHandle.getResourceSpec().equals(resourceSpec) || !resourceHandle.getClientSecurityInfo().equals(clientSecurityInfo)) continue;
                    return resourceHandle.getResourceAllocator().getSharedConnection(resourceHandle);
                }
            }
        }
        object = this.getResourceFromPool(resourceSpec, resourceAllocator, clientSecurityInfo, transaction);
        this.registerResource((ResourceHandle)object);
        return ((ResourceHandle)object).getUserConnection();
    }

    public void registerResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
            if (resourceHandle.isTransactional()) {
                InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
                ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
                if (componentInvocation == null) {
                    throw new InvocationException();
                }
                Transaction transaction = componentInvocation.getTransaction();
                if (this.isTransactionActive(transaction)) {
                    j2EETransactionManager.enlistResource(transaction, resourceHandle);
                }
            }
            j2EETransactionManager.registerComponentResource(resourceHandle);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "poolmgr.component_register_exception", exception);
            throw new PoolingException(exception.toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResourceFromPool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo, Transaction transaction) throws PoolingException {
        ResourcePool resourcePool = null;
        Object object = this.poolTable;
        synchronized (object) {
            resourcePool = (ResourcePool)this.poolTable.get(resourceSpec);
            if (resourcePool == null) {
                resourcePool = new IASNonSharedResourcePool(resourceSpec, resourceAllocator);
                this.poolTable.put(resourceSpec, resourcePool);
                String string = resourceSpec.getJDBCConnectionPoolResourceName();
                IASResourcePoolMonitorImpl iASResourcePoolMonitorImpl = (IASResourcePoolMonitorImpl)this.monitorObjectTable.get(string);
                if (iASResourcePoolMonitorImpl == null) {
                    iASResourcePoolMonitorImpl = new IASResourcePoolMonitorImpl(string);
                    this.monitorObjectTable.put(string, iASResourcePoolMonitorImpl);
                }
                iASResourcePoolMonitorImpl.addPool((IASNonSharedResourcePool)resourcePool);
            }
        }
        object = resourcePool.getResource(resourceSpec, resourceAllocator, transaction);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceEnlisted(Transaction transaction, ResourceHandle resourceHandle) throws IllegalStateException {
        Object object;
        Serializable serializable = this.pendingTxns;
        synchronized (serializable) {
            if (!this.pendingTxns.contains(transaction)) {
                this.pendingTxns.add(transaction);
                object = new SynchronizationListener(transaction);
                try {
                    transaction.registerSynchronization((Synchronization)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        serializable = resourceHandle.getResourceSpec();
        object = (ResourcePool)this.poolTable.get(serializable);
        if (object != null) {
            object.resourceEnlisted(transaction, resourceHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionCompleted(Transaction transaction, int n) throws IllegalStateException {
        Cloneable cloneable = this.pendingTxns;
        synchronized (cloneable) {
            this.pendingTxns.remove(transaction);
        }
        cloneable = (Hashtable)this.poolTable.clone();
        Enumeration enumeration = ((Hashtable)cloneable).elements();
        while (enumeration.hasMoreElements()) {
            ResourcePool resourcePool = (ResourcePool)enumeration.nextElement();
            resourcePool.transactionCompleted(transaction, n);
        }
    }

    public void resourceClosed(ResourceHandle resourceHandle) {
        this.unregisterResource(resourceHandle, 0x4000000);
        this.putbackResourceToPool(resourceHandle, false);
    }

    public void resourceErrorOccurred(ResourceHandle resourceHandle) {
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        try {
            if (resourceHandle.isTransactional()) {
                ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
                if (componentInvocation == null) {
                    throw new InvocationException();
                }
                Transaction transaction = componentInvocation.getTransaction();
                if (this.isTransactionActive(transaction)) {
                    transaction.setRollbackOnly();
                }
            }
        }
        catch (SystemException systemException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.unregisterResource(resourceHandle, 0x20000000);
        this.putbackResourceToPool(resourceHandle, true);
    }

    public void unregisterResource(ResourceHandle resourceHandle, int n) {
        J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
        try {
            if (resourceHandle.isTransactional()) {
                InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
                ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
                if (componentInvocation == null) {
                    throw new InvocationException();
                }
                Transaction transaction = componentInvocation.getTransaction();
                if (this.isTransactionActive(transaction)) {
                    j2EETransactionManager.delistResource(transaction, resourceHandle, n);
                }
            }
        }
        catch (SystemException systemException) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", systemException);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvocationException invocationException) {
            // empty catch block
        }
        j2EETransactionManager.unregisterComponentResource(resourceHandle);
    }

    public void putbackResourceToPool(ResourceHandle resourceHandle, boolean bl) {
        Object object;
        try {
            object = resourceHandle.getResourceAllocator();
            object.cleanup(resourceHandle);
        }
        catch (PoolingException poolingException) {
            _logger.log(Level.WARNING, "poolmgr.resource_return_error", poolingException);
            bl = true;
        }
        object = (ResourcePool)this.poolTable.get(resourceHandle.getResourceSpec());
        if (object != null) {
            if (bl) {
                object.resourceErrorOccurred(resourceHandle);
            } else {
                object.resourceClosed(resourceHandle);
            }
        }
    }

    public ResourceHandle getSharedResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo, Xid xid) throws PoolingException {
        if (xid == null) {
            throw new PoolingException("xid cannot be null");
        }
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(resourceSpec);
        vector.addElement(clientSecurityInfo);
        vector.addElement(xid);
        ResourceHandle resourceHandle = (ResourceHandle)this.xid2Connections.get(vector);
        if (resourceHandle == null) {
            resourceHandle = this.getResourceFromPool(resourceSpec, resourceAllocator, clientSecurityInfo, null);
            this.xid2Connections.put(vector, resourceHandle);
        }
        return resourceHandle;
    }

    public void freeSharedResource(ResourceHandle resourceHandle, Xid xid) throws PoolingException {
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(resourceHandle.getResourceSpec());
        vector.addElement(resourceHandle.getClientSecurityInfo());
        vector.addElement(xid);
        this.xid2Connections.remove(vector);
        this.putbackResourceToPool(resourceHandle, false);
    }

    public boolean sharedResourceExists(ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo, Xid xid) {
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(resourceSpec);
        vector.addElement(clientSecurityInfo);
        vector.addElement(xid);
        return this.xid2Connections.get(vector) != null;
    }

    public void emptyResourcePool(ResourceSpec resourceSpec) {
        ResourcePool resourcePool = (ResourcePool)this.poolTable.get(resourceSpec);
        if (resourcePool != null) {
            resourcePool.emptyPool();
        }
    }

    public ResourceReferenceDescriptor getResourceReference(String string) {
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            return null;
        }
        ComponentInvocation componentInvocation = null;
        componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            return null;
        }
        int n = componentInvocation.getInvocationType();
        Set set = null;
        Object object = componentInvocation.getContainerContext();
        JndiNameEnvironment jndiNameEnvironment = (JndiNameEnvironment)Switch.getSwitch().getDescriptorFor(object);
        if (jndiNameEnvironment == null) {
            return null;
        }
        set = jndiNameEnvironment.getResourceReferenceDescriptors();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ResourceReferenceDescriptor resourceReferenceDescriptor = (ResourceReferenceDescriptor)iterator.next();
            String string2 = resourceReferenceDescriptor.getJndiName();
            if (!string.equals(string2)) continue;
            return resourceReferenceDescriptor;
        }
        return null;
    }

    private static void assertit(boolean bl) {
        if (!bl) {
            Exception exception = new Exception();
            _logger.log(Level.WARNING, "poolmgr.assert_exception", exception);
        }
    }

    public void resizeAllPools(boolean bl) {
        Hashtable hashtable = (Hashtable)this.poolTable.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((ResourcePool)enumeration.nextElement()).resizePool(bl);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "poolmgr.pool_resize_error", exception);
            }
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            PoolManagerImpl.this.resizeAllPools(false);
        }
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction transaction) {
            this.tran = transaction;
        }

        public void afterCompletion(int n) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void beforeCompletion() {
        }
    }
}

