/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Transaction;

public class NonSharedResourcePool
implements ResourcePool {
    private static final boolean debug = false;
    private Hashtable resourceStates = new Hashtable();
    private Set free = new HashSet();
    private long idletime;
    private String name;
    private Hashtable transTable = new Hashtable();
    static Logger _logger = null;

    public NonSharedResourcePool(long l, String string) {
        this.idletime = l * 1000L;
        this.name = string;
    }

    public synchronized void addResource(ResourceSpec resourceSpec, ResourceHandle resourceHandle) {
        ResourceState resourceState = new ResourceState();
        this.resourceStates.put(resourceHandle, resourceState);
        resourceState.setEnlisted(false);
        resourceState.setBusy(true);
    }

    public synchronized ResourceHandle getResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, Transaction transaction) throws PoolingException {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        if (transaction != null && (object3 = (Set)this.transTable.get(transaction)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (ResourceHandle)object2.next();
                ResourceState resourceState = this.getResourceState((ResourceHandle)object);
                if (!resourceAllocator.matchConnection((ResourceHandle)object) || !resourceState.isFree()) continue;
                object4 = object;
                break;
            }
        }
        if (object4 == null) {
            object3 = this.free.iterator();
            while (object3.hasNext()) {
                object2 = (ResourceHandle)object3.next();
                object = this.getResourceState((ResourceHandle)object2);
                if (!resourceAllocator.matchConnection((ResourceHandle)object2) || ((ResourceState)object).isEnlisted()) continue;
                object4 = object2;
                break;
            }
        }
        if (object4 != null) {
            object3 = this.getResourceState((ResourceHandle)object4);
            ((ResourceState)object3).setBusy(true);
            this.free.remove(object4);
        }
        return object4;
    }

    public synchronized void resourceClosed(ResourceHandle resourceHandle) throws IllegalStateException {
        ResourceState resourceState = this.getResourceState(resourceHandle);
        if (resourceState == null || !resourceState.isBusy()) {
            throw new IllegalStateException();
        }
        resourceState.setBusy(false);
        resourceState.touchTimestamp();
        this.free.add(resourceHandle);
    }

    public synchronized void resourceErrorOccurred(ResourceHandle resourceHandle) throws IllegalStateException {
        ResourceState resourceState = this.getResourceState(resourceHandle);
        if (resourceState == null || !resourceState.isBusy()) {
            throw new IllegalStateException();
        }
        try {
            resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "poolmgr.destroy_resource_failed", exception);
        }
        this.resourceStates.remove(resourceHandle);
    }

    public synchronized void resourceEnlisted(Transaction transaction, ResourceHandle resourceHandle) throws IllegalStateException {
        HashSet<ResourceHandle> hashSet = (HashSet<ResourceHandle>)this.transTable.get(transaction);
        if (hashSet == null) {
            hashSet = new HashSet<ResourceHandle>();
            this.transTable.put(transaction, hashSet);
        }
        hashSet.add(resourceHandle);
        ResourceState resourceState = this.getResourceState(resourceHandle);
        resourceState.setEnlisted(true);
    }

    public synchronized void transactionCompleted(Transaction transaction, int n) throws IllegalStateException {
        HashSet hashSet = (HashSet)this.transTable.get(transaction);
        if (hashSet == null) {
            return;
        }
        this.transTable.remove(transaction);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
            ResourceState resourceState = this.getResourceState(resourceHandle);
            resourceState.setEnlisted(false);
        }
    }

    public synchronized void resizePool(boolean bl) {
        int n = 0;
        Iterator iterator = this.free.iterator();
        while (iterator.hasNext()) {
            ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
            ResourceState resourceState = this.getResourceState(resourceHandle);
            if (!bl && System.currentTimeMillis() - resourceState.getTimestamp() <= this.idletime || !resourceState.isUnenlisted()) continue;
            try {
                resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "poolmgr.destroy_resource_failed", exception);
            }
            this.resourceStates.remove(resourceHandle);
            iterator.remove();
            ++n;
        }
    }

    private ResourceState getResourceState(ResourceHandle resourceHandle) {
        return (ResourceState)this.resourceStates.get(resourceHandle);
    }

    public synchronized void emptyPool() {
        Enumeration enumeration = this.resourceStates.keys();
        while (enumeration.hasMoreElements()) {
            ResourceHandle resourceHandle = (ResourceHandle)enumeration.nextElement();
            try {
                resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "poolmgr.destroy_resource_failed", exception);
            }
        }
        this.free.clear();
        this.resourceStates.clear();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }

    public static class ResourceState {
        private boolean enlisted;
        private boolean busy;
        private long timestamp;

        public boolean isEnlisted() {
            return this.enlisted;
        }

        public boolean isUnenlisted() {
            return !this.enlisted;
        }

        public boolean isFree() {
            return !this.busy;
        }

        public void setEnlisted(boolean bl) {
            this.enlisted = bl;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public void setBusy(boolean bl) {
            this.busy = bl;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void touchTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        public ResourceState() {
            this.touchTimestamp();
        }
    }
}

