/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class NoTxConnectorAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ConnectionRequestInfo reqInfo;
    private Subject subject;
    private ManagedConnectionFactory mcf;
    private ConnectorDescriptor desc;
    private ClientSecurityInfo info;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public NoTxConnectorAllocator(PoolManager poolManager, ManagedConnectionFactory managedConnectionFactory, ResourceSpec resourceSpec, Subject subject, ConnectionRequestInfo connectionRequestInfo, ClientSecurityInfo clientSecurityInfo, ConnectorDescriptor connectorDescriptor) {
        this.poolMgr = poolManager;
        this.mcf = managedConnectionFactory;
        this.spec = resourceSpec;
        this.subject = subject;
        this.reqInfo = connectionRequestInfo;
        this.info = clientSecurityInfo;
        this.desc = connectorDescriptor;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection managedConnection = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resourceHandle = new ResourceHandle(managedConnection, this.spec, this, this.info);
            ConnectionListenerImpl connectionListenerImpl = new ConnectionListenerImpl(resourceHandle);
            managedConnection.addConnectionEventListener((ConnectionEventListener)connectionListenerImpl);
            return resourceHandle;
        }
        catch (ResourceException resourceException) {
            _logger.log(Level.SEVERE, "poolmgr.create_resource_error", resourceException);
            if (resourceException.getLinkedException() != null) {
                _logger.log(Level.SEVERE, "poolmgr.create_resource_error", resourceException.getLinkedException());
            }
            Log.err.flush();
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            Object object = managedConnection.getConnection(this.subject, this.reqInfo);
            resourceHandle.fillInResourceObjects(object, null);
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.destroy();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(resourceHandle.getResource());
        try {
            ManagedConnection managedConnection = this.mcf.matchManagedConnections(hashSet, this.subject, this.reqInfo);
            return managedConnection != null;
        }
        catch (ResourceException resourceException) {
            return false;
        }
    }

    public boolean supportsReauthentication() {
        return this.desc.supportsReauthentication();
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException(resourceException.toString(), (Exception)((Object)resourceException));
        }
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resourceHandle) {
            this.resource = resourceHandle;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, false);
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            managedConnection.removeConnectionEventListener((ConnectionEventListener)this);
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            try {
                managedConnection.destroy();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }

        public void localTransactionStarted(ConnectionEvent connectionEvent) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionCommitted(ConnectionEvent connectionEvent) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionRolledback(ConnectionEvent connectionEvent) {
            throw new IllegalStateException("local transaction not supported");
        }
    }
}

