/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class Jdbc20XaAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private Context ic;
    private ResourceSpec spec;
    private boolean shareable;
    private ClientSecurityInfo info;
    private String jndiName;
    private Hashtable listenerTable = new Hashtable();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Jdbc20XaAllocator.class);

    public Jdbc20XaAllocator(PoolManager poolManager, String string, ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo, boolean bl) {
        this.poolMgr = poolManager;
        this.spec = resourceSpec;
        this.jndiName = string;
        this.shareable = bl;
        this.info = clientSecurityInfo;
        this.ic = Switch.getSwitch().getNamingManager().getInitialContext();
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)this.ic.lookup(this.jndiName);
            XADataSource xADataSource = (XADataSource)jdbcConnectionPool.createDataSource();
            ResourcePrincipal resourcePrincipal = this.info.getPrincipal();
            XAConnection xAConnection = resourcePrincipal.isDefault() ? xADataSource.getXAConnection() : xADataSource.getXAConnection(resourcePrincipal.getName(), resourcePrincipal.getPassword());
            ResourceHandle resourceHandle = new ResourceHandle(xAConnection, this.spec, this, this.info);
            ConnectionListenerImpl connectionListenerImpl = new ConnectionListenerImpl(resourceHandle);
            xAConnection.addConnectionEventListener(connectionListenerImpl);
            this.getListenerTable().put(resourceHandle, connectionListenerImpl);
            return resourceHandle;
        }
        catch (Exception exception) {
            if (exception instanceof PoolingException) {
                throw (PoolingException)exception;
            }
            throw new PoolingException(exception);
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        try {
            XAConnection xAConnection = (XAConnection)resourceHandle.getResource();
            Connection connection = xAConnection.getConnection();
            XAResource xAResource = xAConnection.getXAResource();
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(resourceHandle, connection);
            resourceHandle.fillInResourceObjects(connectionWrapper, xAResource);
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            Connection connection = (Connection)resourceHandle.getUserConnection();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            this.closeUserConnection(resourceHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            XAConnection xAConnection = (XAConnection)resourceHandle.getResource();
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.getListenerTable().remove(resourceHandle);
            if (connectionEventListener != null) {
                xAConnection.removeConnectionEventListener(connectionEventListener);
            }
            xAConnection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    private Hashtable getListenerTable() {
        return this.listenerTable;
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return resourceHandle.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return this.shareable;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        resourceHandle.incrementCount();
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(resourceHandle);
        return connectionWrapper;
    }

    class ConnectionWrapper
    implements Connection {
        private Connection dbCon;
        private ResourceHandle handle;
        private boolean closed;

        ConnectionWrapper(ResourceHandle resourceHandle, Connection connection) {
            this.dbCon = connection;
            this.handle = resourceHandle;
        }

        ConnectionWrapper(ResourceHandle resourceHandle) {
            this.handle = resourceHandle;
            this.dbCon = ((ConnectionWrapper)resourceHandle.getUserConnection()).dbCon;
        }

        public Statement createStatement() throws SQLException {
            this.errorIfClosed();
            Statement statement = this.dbCon.createStatement();
            return statement;
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            this.errorIfClosed();
            PreparedStatement preparedStatement = this.dbCon.prepareStatement(string);
            return preparedStatement;
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareCall(string);
        }

        public String nativeSQL(String string) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.nativeSQL(string);
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setAutoCommit(bl);
        }

        public boolean getAutoCommit() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getAutoCommit();
        }

        public void setHoldability(int n) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setHoldability(n);
        }

        public int getHoldability() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getHoldability();
        }

        public void commit() throws SQLException {
            this.errorIfClosed();
            this.dbCon.commit();
        }

        public void rollback() throws SQLException {
            this.errorIfClosed();
            this.dbCon.rollback();
        }

        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.handle.getShareCount() == 0) {
                this.dbCon.close();
                Jdbc20XaAllocator.this.poolMgr.resourceClosed(this.handle);
            } else {
                this.handle.decrementCount();
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getMetaData();
        }

        public void setReadOnly(boolean bl) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setReadOnly(bl);
        }

        public boolean isReadOnly() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.isReadOnly();
        }

        public void setCatalog(String string) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setCatalog(string);
        }

        public String getCatalog() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getCatalog();
        }

        public void setTransactionIsolation(int n) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setTransactionIsolation(n);
        }

        public int getTransactionIsolation() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getTransactionIsolation();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this.errorIfClosed();
            this.dbCon.clearWarnings();
        }

        public void setTypeMap(Map map) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setTypeMap(map);
        }

        public Map getTypeMap() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getTypeMap();
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareStatement(string, n, n2);
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.createStatement(n, n2);
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareCall(string, n, n2);
        }

        private void errorIfClosed() throws SQLException {
            if (this.closed) {
                throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
            }
        }

        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.createStatement(n, n2, n3);
        }

        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareCall(string, n, n2, n3);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.setSavepoint();
        }

        public Savepoint setSavepoint(String string) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.setSavepoint(string);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.errorIfClosed();
            this.dbCon.rollback(savepoint);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.errorIfClosed();
            this.dbCon.releaseSavepoint(savepoint);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareStatement(string, n, n2, n3);
        }

        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareStatement(string, n);
        }

        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareStatement(string, nArray);
        }

        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.prepareStatement(string, stringArray);
        }
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resourceHandle) {
            this.resource = resourceHandle;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            XAConnection xAConnection = (XAConnection)connectionEvent.getSource();
            xAConnection.removeConnectionEventListener(this);
            Jdbc20XaAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                xAConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

