/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.IASConfigPool;
import com.sun.enterprise.resource.IASGenericPoolObjects;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.PortabilityUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASPoolWrapper {
    private IASGenericPoolObjects defaultPoolObj = null;
    private HashMap principalPoolTable = null;
    private IASPoolHelper poolHelper = null;
    private IASConfigPool configPool = null;
    static Logger _logger = PortabilityUtils.GetPoolManagerLogger();
    static final String DEFAULT_POOL = "defaultPool";
    static int countDefaultPool = 0;
    String nameDefaultPool = null;

    public IASPoolWrapper(IASPoolHelper iASPoolHelper, IASConfigPool iASConfigPool) {
        this.configPool = iASConfigPool;
        this.poolHelper = iASPoolHelper;
        this.defaultPoolObj = new IASGenericPoolObjects(iASPoolHelper, iASConfigPool);
        this.principalPoolTable = new HashMap(11);
        this.nameDefaultPool = DEFAULT_POOL + ++countDefaultPool;
        _logger.log(Level.FINE, "nameDefaultPool: " + this.nameDefaultPool);
        _logger.log(Level.FINE, "In end of IASPoolWrapper constructor.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IASGenericPoolObjects getPrincipalPool(Object object) {
        _logger.log(Level.FINE, "In start of IASPoolWrapper.getPrincipalPool(...)");
        IASGenericPoolObjects iASGenericPoolObjects = null;
        HashMap hashMap = this.principalPoolTable;
        synchronized (hashMap) {
            iASGenericPoolObjects = this.principalPoolTable.containsKey(object) ? (IASGenericPoolObjects)this.principalPoolTable.get(object) : this.createNewPool(object);
        }
        _logger.log(Level.FINE, "In end of IASPoolWrapper.getPrincipalPool(...)");
        return iASGenericPoolObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IASGenericPoolObjects createNewPool(Object object) {
        _logger.log(Level.FINE, "In start of IASPoolWrapper.createNewPool(...)");
        if (this.configPool == null) {
            this.configPool = new IASConfigPool();
        }
        IASGenericPoolObjects iASGenericPoolObjects = new IASGenericPoolObjects(this.poolHelper, this.configPool);
        _logger.log(Level.FINE, "After creating pool associated to principal: " + object);
        HashMap hashMap = this.principalPoolTable;
        synchronized (hashMap) {
            this.principalPoolTable.put(object, iASGenericPoolObjects);
        }
        _logger.log(Level.FINE, "In end of IASPoolWrapper.createNewPool(...)");
        return iASGenericPoolObjects;
    }

    public IASGenericPoolObjects getDefaultPool() {
        _logger.log(Level.FINE, "In start / end of IASPoolWrapper.getDefaultPool(...)");
        return this.defaultPoolObj;
    }

    public HashMap getPrincipalPoolTable() {
        _logger.log(Level.FINE, "In start / end of IASPoolWrapper.getPrincipalPoolTable(...)");
        return this.principalPoolTable;
    }

    public void checkWrapperPoolSize() {
        _logger.log(Level.FINE, "In start of IASPoolWrapper.checkWrapperPoolSize(...)");
        this.defaultPoolObj.checkPoolSize();
        if (!this.principalPoolTable.isEmpty()) {
            Collection collection = this.principalPoolTable.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IASGenericPoolObjects iASGenericPoolObjects = (IASGenericPoolObjects)iterator.next();
                iASGenericPoolObjects.checkPoolSize();
            }
        }
        _logger.log(Level.FINE, "In end of IASPoolWrapper.checkWrapperPoolSize(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumOfPools() {
        HashMap hashMap = this.principalPoolTable;
        synchronized (hashMap) {
            return this.principalPoolTable.size() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getListOfPoolsNames() {
        HashMap hashMap = this.principalPoolTable;
        synchronized (hashMap) {
            return this.principalPoolTable.keySet();
        }
    }

    IASConfigPool getPoolConfig() {
        return this.configPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IASGenericPoolObjects findPool(String string) {
        if (string.equals(this.nameDefaultPool)) {
            return this.defaultPoolObj;
        }
        HashMap hashMap = this.principalPoolTable;
        synchronized (hashMap) {
            Set set = this.principalPoolTable.keySet();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    if (!string.equals(iterator.next())) continue;
                    return (IASGenericPoolObjects)this.principalPoolTable.get(string);
                }
            }
            return null;
        }
    }

    String getJndiName() {
        return this.poolHelper.toString();
    }
}

