/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.IASConnectionEventListenerImpl;
import com.sun.enterprise.resource.IASGenericPoolObjects;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import com.sun.enterprise.resource.XAResourceImpl;
import java.util.EventListener;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class IASPoolObjectImp
implements IASPoolObject {
    private ManagedConnection managedConnection = null;
    private IASConnectionEventListenerImpl connectionEventListener = null;
    private int shareCount = 0;
    private int transactionLevel = 0;
    private static final String DEFAULT = "Anonymous";
    private boolean isClosed = false;

    public IASPoolObjectImp(ManagedConnection managedConnection, IASConnectionEventListenerImpl iASConnectionEventListenerImpl) {
        this.managedConnection = managedConnection;
        this.connectionEventListener = iASConnectionEventListenerImpl;
    }

    public void addEventListener(IASGenericPoolObjects iASGenericPoolObjects) throws IASPoolManagerException {
        this.connectionEventListener = new IASConnectionEventListenerImpl(iASGenericPoolObjects);
        this.managedConnection.addConnectionEventListener((ConnectionEventListener)this.connectionEventListener);
    }

    public void destroy() throws IASPoolManagerException {
        try {
            this.managedConnection.removeConnectionEventListener((ConnectionEventListener)this.connectionEventListener);
            this.managedConnection.destroy();
        }
        catch (ResourceException resourceException) {
            String string = null;
            Exception exception = resourceException.getLinkedException();
            string = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
            throw new IASPoolManagerException(string, resourceException.getErrorCode());
        }
    }

    public Object getUnderlyingObject(Subject subject, Object object) throws IASPoolManagerException {
        Object object2 = null;
        try {
            object2 = this.managedConnection.getConnection(subject, (ConnectionRequestInfo)object);
        }
        catch (ResourceException resourceException) {
            String string = null;
            Exception exception = resourceException.getLinkedException();
            string = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
            throw new IASPoolManagerException(string, resourceException.getErrorCode());
        }
        return object2;
    }

    public String getUserName() throws IASPoolManagerException {
        String string = null;
        try {
            ManagedConnectionMetaData managedConnectionMetaData = this.managedConnection.getMetaData();
            string = managedConnectionMetaData.getUserName();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NotSupportedException notSupportedException) {
        }
        catch (ResourceException resourceException) {
            String string2 = null;
            Exception exception = resourceException.getLinkedException();
            string2 = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
            throw new IASPoolManagerException(string2, resourceException.getErrorCode());
        }
        if (string == null) {
            string = DEFAULT;
        }
        return string;
    }

    public XAResource getXAResource(int n, Object object, IASPoolHelper iASPoolHelper, Subject subject, Transaction transaction) throws IASPoolManagerException {
        XAResource xAResource = null;
        if (n == 2) {
            try {
                xAResource = this.managedConnection.getXAResource();
            }
            catch (ResourceException resourceException) {
                String string = null;
                Exception exception = resourceException.getLinkedException();
                string = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
                throw new IASPoolManagerException(string, resourceException.getErrorCode());
            }
        } else {
            xAResource = new XAResourceImpl(this.managedConnection, object, this, iASPoolHelper, subject, transaction);
        }
        return xAResource;
    }

    public Object getPoolObject() {
        return this.managedConnection;
    }

    public void setEventListener(EventListener eventListener) {
        this.connectionEventListener = (IASConnectionEventListenerImpl)((Object)eventListener);
    }

    public EventListener getEventListener() {
        return this.connectionEventListener;
    }

    public void incrementCount() {
        ++this.shareCount;
    }

    public void decrementCount() throws IASPoolManagerException {
        if (this.shareCount == 0) {
            throw new IASPoolManagerException("shareCount cannot be negative");
        }
        --this.shareCount;
    }

    public int getShareCount() {
        return this.shareCount;
    }

    public void setTransactionLevel(int n) {
        this.transactionLevel = n;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public void cleanup() throws IASPoolManagerException {
        try {
            this.managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            String string = null;
            Exception exception = resourceException.getLinkedException();
            string = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
            throw new IASPoolManagerException(string, resourceException.getErrorCode());
        }
    }

    public void setIsClosed(boolean bl) {
        this.isClosed = bl;
    }

    public boolean getIsClosed() {
        return this.isClosed;
    }
}

