/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.IASGenericPoolObjects;
import com.sun.enterprise.resource.IASPoolManagerConstants;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import com.sun.enterprise.resource.IASPoolObjectImp;
import com.sun.enterprise.resource.PortabilityUtils;
import com.sun.enterprise.resource.ResourceHandle;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;

public class IASConnectionEventListenerImpl
implements ConnectionEventListener {
    private IASGenericPoolObjects connectionsPool = null;
    static Logger _logger = PortabilityUtils.GetPoolManagerLogger();

    public IASConnectionEventListenerImpl(IASGenericPoolObjects iASGenericPoolObjects) {
        this.connectionsPool = iASGenericPoolObjects;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        Object object;
        Object object2;
        boolean bl;
        ManagedConnection managedConnection;
        block12: {
            managedConnection = (ManagedConnection)connectionEvent.getSource();
            J2EETransactionManager j2EETransactionManager = this.getTransactionManager();
            bl = false;
            try {
                object2 = this.getTransaction();
                if (object2 == null) break block12;
                object = this.connectionsPool.getPoolObjectSuiteToResourceHandle(managedConnection, (Transaction)object2);
                IASPoolObject iASPoolObject = ((ResourceHandle)object).getPoolObject();
                if (iASPoolObject.getShareCount() > 0) {
                    try {
                        iASPoolObject.decrementCount();
                    }
                    catch (IASPoolManagerException iASPoolManagerException) {
                        // empty catch block
                    }
                    bl = true;
                    break block12;
                }
                boolean bl2 = false;
                int n = iASPoolObject.getTransactionLevel();
                boolean bl3 = false;
                iASPoolObject.setIsClosed(true);
                if (n == 1) {
                    bl2 = this.connectionsPool.getCommitOrRollbackStatus(((ResourceHandle)object).getPoolObject(), (Transaction)object2);
                    bl3 = true;
                    if (!bl2) {
                        bl = true;
                    }
                }
                if (!bl3 || bl2) {
                    j2EETransactionManager.delistResource((Transaction)object2, (ResourceHandle)object, 0x4000000);
                    j2EETransactionManager.unregisterComponentResource((ResourceHandle)object);
                    this.connectionsPool.resourceDelisted((Transaction)object2, (ResourceHandle)object);
                    bl = false;
                } else {
                    j2EETransactionManager.delistResource((Transaction)object2, (ResourceHandle)object, 0x4000000);
                    j2EETransactionManager.unregisterComponentResource((ResourceHandle)object);
                }
            }
            catch (Exception exception) {
                object = new Object[]{exception.getMessage()};
                _logger.log(Level.SEVERE, "poolmgr.complete_transaction_error", (Object[])object);
            }
        }
        try {
            if (!bl) {
                managedConnection.cleanup();
                object2 = new IASPoolObjectImp(managedConnection, this);
                this.connectionsPool.returnObjectToPool((IASPoolObject)object2);
            }
        }
        catch (ResourceException resourceException) {
            object = new Object[]{resourceException.getMessage(), resourceException.getErrorCode()};
            _logger.log(Level.SEVERE, MessageFormat.format(IASPoolManagerConstants.EVENT_CLOSED_ERROR, (Object[])object));
        }
    }

    public void localTransactionStarted(ConnectionEvent connectionEvent) {
    }

    public void localTransactionCommitted(ConnectionEvent connectionEvent) {
    }

    public void localTransactionRolledback(ConnectionEvent connectionEvent) {
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        Object[] objectArray;
        Object object;
        ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
        J2EETransactionManager j2EETransactionManager = this.getTransactionManager();
        try {
            object = this.getTransaction();
            if (object != null) {
                objectArray = this.connectionsPool.getPoolObjectSuiteToResourceHandle(managedConnection, (Transaction)object);
                j2EETransactionManager.delistResource((Transaction)object, (ResourceHandle)objectArray, 0x20000000);
                j2EETransactionManager.unregisterComponentResource((ResourceHandle)objectArray);
                this.connectionsPool.resourceDelisted((Transaction)object, (ResourceHandle)objectArray);
            }
        }
        catch (Exception exception) {
            objectArray = new Object[]{exception.getMessage()};
            _logger.log(Level.SEVERE, "poolmgr.complete_transaction_error", objectArray);
        }
        try {
            object = this.connectionsPool.getCorrespondPoolObject(managedConnection);
            this.connectionsPool.destroyPoolObject((IASPoolObject)object);
        }
        catch (IASPoolManagerException iASPoolManagerException) {
            objectArray = new Object[]{iASPoolManagerException.getMessage(), iASPoolManagerException.getErrorCode()};
            _logger.log(Level.SEVERE, MessageFormat.format(IASPoolManagerConstants.EVENT_OBJECT_ERROR, objectArray));
        }
    }

    private Transaction getTransaction() throws ResourceException {
        Transaction transaction = null;
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new ResourceException(IASPoolManagerConstants.FAIL_TO_GET_CURRENT_INVOCATION);
        }
        transaction = componentInvocation.getTransaction();
        return transaction;
    }

    private J2EETransactionManager getTransactionManager() {
        return Switch.getSwitch().getTransactionManager();
    }
}

