/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ConnectorXAResource
implements XAResource {
    private Object userHandle;
    private ResourceSpec spec;
    private ResourceAllocator alloc;
    private PoolManager poolMgr = Switch.getSwitch().getPoolManager();
    private ManagedConnection localConnection;
    private ClientSecurityInfo info;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public ConnectorXAResource(ManagedConnection managedConnection, Object object, ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo) {
        this.userHandle = object;
        this.spec = resourceSpec;
        this.alloc = resourceAllocator;
        this.info = clientSecurityInfo;
        this.localConnection = managedConnection;
    }

    private void handleResourceException(Exception exception) throws XAException {
        _logger.log(Level.SEVERE, "poolmgr.system_exception", exception);
        XAException xAException = new XAException(exception.toString());
        xAException.errorCode = -3;
        throw xAException;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            ManagedConnection managedConnection = this.getManagedConnection(xid);
            managedConnection.getLocalTransaction().commit();
            this.freeManagedConnection(xid);
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            ManagedConnection managedConnection = this.getManagedConnection(xid);
            managedConnection.associateConnection(this.userHandle);
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            this.localConnection.associateConnection(this.userHandle);
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this == xAResource) {
            return true;
        }
        if (xAResource == null) {
            return false;
        }
        if (xAResource instanceof ConnectorXAResource) {
            ConnectorXAResource connectorXAResource = (ConnectorXAResource)xAResource;
            return this.spec.equals(connectorXAResource.spec) && this.info.equals(connectorXAResource.info);
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int n) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        try {
            ManagedConnection managedConnection = this.getManagedConnection(xid);
            managedConnection.getLocalTransaction().rollback();
            this.freeManagedConnection(xid);
        }
        catch (Exception exception) {
            this.handleResourceException(exception);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    ManagedConnection getManagedConnection(Xid xid) throws PoolingException {
        boolean bl = this.poolMgr.sharedResourceExists(this.spec, this.info, xid);
        ResourceHandle resourceHandle = this.poolMgr.getSharedResource(this.spec, this.alloc, this.info, xid);
        ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
        if (!bl) {
            try {
                managedConnection.getLocalTransaction().begin();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "poolmgr.system_exception", exception);
                throw new PoolingException(exception.toString(), exception);
            }
        }
        return managedConnection;
    }

    void freeManagedConnection(Xid xid) throws PoolingException {
        ResourceHandle resourceHandle = this.poolMgr.getSharedResource(this.spec, this.alloc, this.info, xid);
        this.poolMgr.freeSharedResource(resourceHandle, xid);
    }
}

