/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ConnectorAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private Principal prin;
    private ConnectionRequestInfo reqInfo;
    private Subject subject;
    private ManagedConnectionFactory mcf;
    private ClientSecurityInfo info;
    private ConnectorDescriptor desc;
    private boolean shareable;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public ConnectorAllocator(PoolManager poolManager, ManagedConnectionFactory managedConnectionFactory, ResourceSpec resourceSpec, Subject subject, ConnectionRequestInfo connectionRequestInfo, ClientSecurityInfo clientSecurityInfo, ConnectorDescriptor connectorDescriptor, boolean bl) {
        this.poolMgr = poolManager;
        this.mcf = managedConnectionFactory;
        this.spec = resourceSpec;
        this.subject = subject;
        this.reqInfo = connectionRequestInfo;
        this.info = clientSecurityInfo;
        this.desc = connectorDescriptor;
        this.shareable = bl;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection managedConnection = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resourceHandle = new ResourceHandle(managedConnection, this.spec, this, this.info);
            ConnectionListenerImpl connectionListenerImpl = new ConnectionListenerImpl(resourceHandle);
            managedConnection.addConnectionEventListener((ConnectionEventListener)connectionListenerImpl);
            return resourceHandle;
        }
        catch (ResourceException resourceException) {
            _logger.log(Level.SEVERE, "poolmgr.create_resource_error", resourceException);
            if (resourceException.getLinkedException() != null) {
                _logger.log(Level.SEVERE, "poolmgr.create_resource_error", resourceException.getLinkedException());
            }
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            Object object = managedConnection.getConnection(this.subject, this.reqInfo);
            XAResource xAResource = managedConnection.getXAResource();
            resourceHandle.fillInResourceObjects(object, xAResource);
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            this.closeUserConnection(resourceHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.destroy();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(resourceHandle.getResource());
        try {
            ManagedConnection managedConnection = this.mcf.matchManagedConnections(hashSet, this.subject, this.reqInfo);
            return managedConnection != null;
        }
        catch (ResourceException resourceException) {
            return false;
        }
    }

    public boolean supportsReauthentication() {
        return this.desc.supportsReauthentication();
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return this.shareable;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException(resourceException.toString(), (Exception)((Object)resourceException));
        }
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            Object object = managedConnection.getConnection(this.subject, this.reqInfo);
            resourceHandle.incrementCount();
            return object;
        }
        catch (ResourceException resourceException) {
            throw new PoolingException(resourceException.toString(), (Exception)((Object)resourceException));
        }
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;
        private boolean errorOccurred = false;

        public ConnectionListenerImpl(ResourceHandle resourceHandle) {
            this.resource = resourceHandle;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            if (this.errorOccurred) {
                return;
            }
            if (this.resource.getShareCount() == 0) {
                ConnectorAllocator.this.poolMgr.resourceClosed(this.resource);
            } else {
                this.resource.decrementCount();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            this.errorOccurred = true;
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            managedConnection.removeConnectionEventListener((ConnectionEventListener)this);
            ConnectorAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                managedConnection.destroy();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }

        public void localTransactionStarted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        }
    }
}

