/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorAllocator;
import com.sun.enterprise.resource.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.NoTxConnectorAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class ConnectionManagerImpl
implements ConnectionManager,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectionManagerImpl.class);
    private String jndiName;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public ConnectionManagerImpl(String string) {
        this.jndiName = string;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            String string = localStrings.getLocalString("datasource.wrongclient", "");
            throw new IllegalStateException(string);
        }
        PoolManager poolManager = Switch.getSwitch().getPoolManager();
        boolean bl = true;
        ResourceReferenceDescriptor resourceReferenceDescriptor = poolManager.getResourceReference(this.jndiName);
        if (resourceReferenceDescriptor == null) {
            _logger.log(Level.SEVERE, "poolmgr.no_resource_reference", this.jndiName);
            return this.internalGetConnection(managedConnectionFactory, null, connectionRequestInfo, bl);
        }
        String string = resourceReferenceDescriptor.getSharingScope();
        if (string.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
            bl = false;
        }
        String string2 = resourceReferenceDescriptor.getAuthorization();
        if (string2.equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
            return this.internalGetConnection(managedConnectionFactory, null, connectionRequestInfo, bl);
        }
        ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
        if (resourcePrincipal == null) {
            _logger.log(Level.WARNING, "poolmgr.password_info_warning", this.jndiName);
            resourcePrincipal = new ResourcePrincipal("", "");
        }
        return this.internalGetConnection(managedConnectionFactory, resourcePrincipal, connectionRequestInfo, bl);
    }

    private Object internalGetConnection(ManagedConnectionFactory managedConnectionFactory, final ResourcePrincipal resourcePrincipal, ConnectionRequestInfo connectionRequestInfo, boolean bl) throws ResourceException {
        try {
            Object object;
            PoolManager poolManager = Switch.getSwitch().getPoolManager();
            ResourceSpec resourceSpec = new ResourceSpec(this.jndiName, 1);
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            ConnectorDescriptor connectorDescriptor = resourceInstaller.getDescriptorByJndiName(this.jndiName);
            int n = connectorDescriptor.getTransactionSupport();
            Subject subject = null;
            ClientSecurityInfo clientSecurityInfo = null;
            if (resourcePrincipal != null) {
                object = resourcePrincipal.getPassword();
                final PasswordCredential passwordCredential = new PasswordCredential(resourcePrincipal.getName(), ((String)object).toCharArray());
                passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
                final Subject subject2 = new Subject();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        subject2.getPrincipals().add(resourcePrincipal);
                        subject2.getPrivateCredentials().add(passwordCredential);
                        return null;
                    }
                });
                subject = subject2;
                clientSecurityInfo = new ClientSecurityInfo(resourcePrincipal);
            } else {
                clientSecurityInfo = new ClientSecurityInfo(connectionRequestInfo);
            }
            object = null;
            switch (n) {
                case 0: {
                    object = new NoTxConnectorAllocator(poolManager, managedConnectionFactory, resourceSpec, subject, connectionRequestInfo, clientSecurityInfo, connectorDescriptor);
                    return poolManager.getResource(resourceSpec, (ResourceAllocator)object, clientSecurityInfo);
                }
                case 1: {
                    if (!bl) {
                        throw new ResourceAllocationException("Cannot use resource in unshareable scope: " + this.jndiName);
                    }
                    object = new LocalTxConnectorAllocator(poolManager, managedConnectionFactory, resourceSpec, subject, connectionRequestInfo, clientSecurityInfo, connectorDescriptor);
                    return poolManager.getResource(resourceSpec, (ResourceAllocator)object, clientSecurityInfo);
                }
                case 2: {
                    object = new ConnectorAllocator(poolManager, managedConnectionFactory, resourceSpec, subject, connectionRequestInfo, clientSecurityInfo, connectorDescriptor, bl);
                    return poolManager.getResource(resourceSpec, (ResourceAllocator)object, clientSecurityInfo);
                }
            }
            throw new IllegalStateException("Illegal transaction support level: " + n);
        }
        catch (PoolingException poolingException) {
            _logger.log(Level.SEVERE, "poolmgr.system_exception", poolingException);
            ResourceAllocationException resourceAllocationException = new ResourceAllocationException("Error in creating connection");
            resourceAllocationException.setLinkedException((Exception)poolingException);
            throw resourceAllocationException;
        }
    }
}

