/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public abstract class AbstractSystemJdbcAllocator
implements ResourceAllocator {
    protected PoolManager poolMgr;
    protected ResourceSpec spec;
    protected ClientSecurityInfo info;
    private Hashtable listenerTable = new Hashtable();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public AbstractSystemJdbcAllocator(PoolManager poolManager, ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo) {
        this.poolMgr = poolManager;
        this.spec = resourceSpec;
        this.info = clientSecurityInfo;
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        try {
            XAConnection xAConnection = (XAConnection)resourceHandle.getResource();
            Connection connection = xAConnection.getConnection();
            XAResource xAResource = xAConnection.getXAResource();
            resourceHandle.fillInResourceObjects(connection, xAResource);
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            Connection connection = (Connection)resourceHandle.getUserConnection();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        XAConnection xAConnection = (XAConnection)resourceHandle.getResource();
        ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.getListenerTable().remove(resourceHandle);
        if (connectionEventListener != null) {
            xAConnection.removeConnectionEventListener(connectionEventListener);
        }
        try {
            this.closeUserConnection(resourceHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            xAConnection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    protected Hashtable getListenerTable() {
        return this.listenerTable;
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return resourceHandle.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resourceHandle) {
            this.resource = resourceHandle;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
            try {
                Transaction transaction = j2EETransactionManager.getTransaction();
                if (transaction != null) {
                    j2EETransactionManager.delistResource(transaction, this.resource, 0x4000000);
                }
            }
            catch (SystemException systemException) {
                _logger.log(Level.SEVERE, "poolmgr.system_exception", systemException);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            AbstractSystemJdbcAllocator.this.poolMgr.putbackResourceToPool(this.resource, false);
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            XAConnection xAConnection = (XAConnection)connectionEvent.getSource();
            xAConnection.removeConnectionEventListener(this);
            J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
            try {
                Transaction transaction = j2EETransactionManager.getTransaction();
                if (transaction != null) {
                    j2EETransactionManager.delistResource(transaction, this.resource, 0x20000000);
                    transaction.setRollbackOnly();
                }
            }
            catch (SystemException systemException) {
                _logger.log(Level.SEVERE, "poolmgr.system_exception", systemException);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            AbstractSystemJdbcAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            try {
                xAConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

