/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;

public class ResourceAdminImpl
implements ResourceAdmin {
    private Hashtable resourceAdmins = new Hashtable();
    private boolean triedLookup;
    private InitialContext context;
    private JarInstaller serverHandle;

    public ResourceAdminImpl() {
        this.addAdmin(new AdminJdbcDriver());
        this.addAdmin(new AdminJdbcDatasource());
        this.addAdmin(new AdminJdbcXADatasource());
        this.addAdmin(new AdminJmsDestination());
        this.addAdmin(new AdminJmsFactory());
        this.addAdmin(new AdminConnectorFactory());
        this.triedLookup = false;
        this.serverHandle = null;
        this.context = null;
    }

    public ConnectorResource addConnectionFactory(String string, String string2, String string3, String string4, String string5, Properties properties) throws J2EEResourceException {
        ConnectorResource connectorResource = null;
        try {
            JarInstaller jarInstaller = this.getServerHandle();
            if (jarInstaller == null) {
                throw new J2EEResourceException("server unavailable : can't create connector factory");
            }
            jarInstaller.addConnectionFactory(string, string2, string3, string4, string5, properties);
            J2EEResourceCollection j2EEResourceCollection = this.getResourceCollection();
            connectorResource = (ConnectorResource)j2EEResourceCollection.getResourceByName(6, string3);
        }
        catch (Exception exception) {
            throw new J2EEResourceException(exception);
        }
        return connectorResource;
    }

    public void addResource(J2EEResource j2EEResource) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(j2EEResource.getType());
            admin.addResource(j2EEResource);
        }
        catch (Exception exception) {
            throw new J2EEResourceException(exception);
        }
    }

    public Set getResources(int n) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(n);
            return admin.getResources();
        }
        catch (Exception exception) {
            throw new J2EEResourceException(exception);
        }
    }

    public void removeResource(String string, int n) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(n);
            admin.removeResource(string);
        }
        catch (Exception exception) {
            throw new J2EEResourceException(exception);
        }
    }

    public void removeAllResources(int n) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(n);
            admin.removeAllResources();
        }
        catch (Exception exception) {
            throw new J2EEResourceException(exception);
        }
    }

    private void addAdmin(Admin admin) {
        this.resourceAdmins.put(new Integer(admin.getResourceType()), admin);
    }

    private Admin getAdmin(int n) {
        return (Admin)this.resourceAdmins.get(new Integer(n));
    }

    private J2EEResourceCollection getResourceCollection() throws J2EEResourceException {
        J2EEResourceFactory j2EEResourceFactory = ServerConfiguration.getJ2EEResourceFactory();
        return j2EEResourceFactory.loadDefaultResourceCollection();
    }

    private void storeResourceCollection(J2EEResourceCollection j2EEResourceCollection) throws J2EEResourceException {
        J2EEResourceFactory j2EEResourceFactory = ServerConfiguration.getJ2EEResourceFactory();
        j2EEResourceFactory.storeDefaultResourceCollection(j2EEResourceCollection);
    }

    private JarInstaller getServerHandle() {
        if (!this.triedLookup) {
            this.triedLookup = true;
            try {
                this.context = new InitialContext();
                this.serverHandle = (JarInstaller)this.context.lookup("JarInstaller");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.serverHandle;
    }

    private class AdminConnectorFactory
    extends Admin {
        private AdminConnectorFactory() {
        }

        public int getResourceType() {
            return 6;
        }

        public void addResource(J2EEResource j2EEResource) throws Exception {
            throw new Exception("Not Supported : Use ResourceAdmin.addConnectionFactory");
        }

        public Set getResources() throws Exception {
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            return j2EEResourceCollection.getResourcesByType(this.getResourceType());
        }

        public void removeResource(String string) throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource j2EEResource = j2EEResourceCollection.getResourceByName(this.getResourceType(), string);
            if (jarInstaller != null) {
                jarInstaller.removeConnectionFactory(string);
            }
        }

        public void removeAllResources() throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            Iterator iterator = this.getResources().iterator();
            while (iterator.hasNext()) {
                J2EEResource j2EEResource = (J2EEResource)iterator.next();
                if (jarInstaller == null) continue;
                jarInstaller.removeConnectionFactory(j2EEResource.getName());
            }
        }
    }

    private class AdminJmsFactory
    extends Admin {
        private AdminJmsFactory() {
        }

        public int getResourceType() {
            return 2;
        }

        public void addResource(J2EEResource j2EEResource) throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            if (jarInstaller != null) {
                jarInstaller.createJmsConnectionFactory((JmsCnxFactoryResource)j2EEResource);
            }
            super.addResource(j2EEResource);
        }

        public void removeResource(String string) throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource j2EEResource = j2EEResourceCollection.getResourceByName(this.getResourceType(), string);
            if (j2EEResource != null && jarInstaller != null) {
                jarInstaller.deleteJmsConnectionFactory((JmsCnxFactoryResource)j2EEResource);
            }
            super.removeResource(string);
        }

        public void removeAllResources() throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            Iterator iterator = this.getResources().iterator();
            while (iterator.hasNext()) {
                JmsCnxFactoryResource jmsCnxFactoryResource = (JmsCnxFactoryResource)iterator.next();
                if (jarInstaller == null) continue;
                jarInstaller.deleteJmsConnectionFactory(jmsCnxFactoryResource);
            }
            super.removeAllResources();
        }
    }

    private class AdminJmsDestination
    extends Admin {
        private AdminJmsDestination() {
        }

        public int getResourceType() {
            return 1;
        }

        public void addResource(J2EEResource j2EEResource) throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            if (jarInstaller != null) {
                jarInstaller.createDestination((JmsDestinationResource)j2EEResource);
            }
            super.addResource(j2EEResource);
        }

        public void removeResource(String string) throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource j2EEResource = j2EEResourceCollection.getResourceByName(this.getResourceType(), string);
            if (j2EEResource != null && jarInstaller != null) {
                jarInstaller.deleteDestination((JmsDestinationResource)j2EEResource);
            }
            super.removeResource(string);
        }

        public void removeAllResources() throws Exception {
            JarInstaller jarInstaller = ResourceAdminImpl.this.getServerHandle();
            Iterator iterator = this.getResources().iterator();
            while (iterator.hasNext()) {
                JmsDestinationResource jmsDestinationResource = (JmsDestinationResource)iterator.next();
                if (jarInstaller == null) continue;
                jarInstaller.deleteDestination(jmsDestinationResource);
            }
            super.removeAllResources();
        }
    }

    private class AdminJdbcXADatasource
    extends Admin {
        private AdminJdbcXADatasource() {
        }

        public int getResourceType() {
            return 4;
        }
    }

    private class AdminJdbcDatasource
    extends Admin {
        private AdminJdbcDatasource() {
        }

        public int getResourceType() {
            return 3;
        }
    }

    private class AdminJdbcDriver
    extends Admin {
        private AdminJdbcDriver() {
        }

        public int getResourceType() {
            return 5;
        }
    }

    private abstract class Admin {
        private Admin() {
        }

        public abstract int getResourceType();

        public void addResource(J2EEResource j2EEResource) throws Exception {
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            j2EEResourceCollection.addResource(j2EEResource);
            ResourceAdminImpl.this.storeResourceCollection(j2EEResourceCollection);
        }

        public void removeResource(String string) throws Exception {
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource j2EEResource = j2EEResourceCollection.getResourceByName(this.getResourceType(), string);
            if (j2EEResource != null) {
                j2EEResourceCollection.removeResource(j2EEResource);
                ResourceAdminImpl.this.storeResourceCollection(j2EEResourceCollection);
            }
        }

        public void removeAllResources() throws Exception {
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            j2EEResourceCollection.removeAllResourcesByType(this.getResourceType());
            ResourceAdminImpl.this.storeResourceCollection(j2EEResourceCollection);
        }

        public Set getResources() throws Exception {
            J2EEResourceCollection j2EEResourceCollection = ResourceAdminImpl.this.getResourceCollection();
            return j2EEResourceCollection.getResourcesByType(this.getResourceType());
        }
    }
}

