/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.RepositoryContext;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class Repository {
    private static Logger _logger = null;
    private Context ctx = null;
    private String name = null;

    public String find(String string) {
        try {
            String string2 = (String)this.ctx.lookup(string);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean add(String string, String string2) {
        try {
            this.ctx.rebind(string, (Object)string2);
            return true;
        }
        catch (NamingException namingException) {
            _logger.log(Level.SEVERE, "enterprise.addinrepository_exception", namingException);
            return false;
        }
    }

    public boolean remove(String string) {
        try {
            this.ctx.unbind(string);
            return true;
        }
        catch (NamingException namingException) {
            _logger.log(Level.SEVERE, "enterprise.delinrepository_exception", namingException);
            return false;
        }
    }

    public String[] keys() {
        Object object;
        Vector<String> vector = new Vector<String>(10);
        NamingEnumeration<Binding> namingEnumeration = null;
        try {
            namingEnumeration = this.ctx.listBindings("");
        }
        catch (NamingException namingException) {
            _logger.log(Level.SEVERE, "enterprise.naming_exception", namingException);
        }
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            object = (Binding)namingEnumeration.nextElement();
            vector.add(((NameClassPair)object).getName());
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String getName() {
        return RepositoryContext.getRepositoryName(this.name);
    }

    public Repository(String string) {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.enterprise.repository.RepositoryInitContextFactory");
        properties.put("com.sun.enterprise.repository.name", string);
        this.name = string;
        this.init(properties);
    }

    public Repository(String string, String string2) {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.enterprise.repository.RepositoryInitContextFactory");
        properties.put("com.sun.enterprise.repository.name", string);
        properties.put("com.sun.enterprise.repository.dir", string2);
        this.name = string;
        this.init(properties);
    }

    private void init(Properties properties) {
        try {
            this.ctx = new InitialContext(properties);
        }
        catch (NamingException namingException) {
            _logger.log(Level.SEVERE, "enterprise.naming_exception", namingException);
            this.ctx = null;
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
    }
}

