/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.repository.GenericConverter;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceCollectionImpl;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.RawResourceInfo;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.util.FileUtil;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class J2EEResourceFactoryImpl
implements J2EEResourceFactory {
    private static Logger _logger = null;
    private static final String FIELD_SEPARATOR = ".";
    private static final String PROP_INDICATOR = "prop";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String RESOURCE_PROP_RELATIVE_PATH;
    private static final int EQUAL = 0;
    private static final int SORT_BEFORE = -1;
    private static final int SORT_AFTER = 1;
    private static final boolean debug = false;
    private Properties outputProperties_ = new Properties();

    public J2EEResourceCollection loadDefaultResourceCollection() throws J2EEResourceException {
        String string = FileUtil.getAbsolutePath(RESOURCE_PROP_RELATIVE_PATH);
        return this.loadResourceCollection(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public J2EEResourceCollection loadResourceCollection(String string) throws J2EEResourceException {
        J2EEResourceCollectionImpl j2EEResourceCollectionImpl = new J2EEResourceCollectionImpl();
        InputStream inputStream = null;
        try {
            try {
                boolean bl;
                Properties properties = new Properties();
                File file = new File(string);
                if (!file.exists() && !(bl = file.createNewFile())) {
                    throw new IOException("Could not create " + file);
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                inputStream = new BufferedInputStream(fileInputStream);
                properties.load(inputStream);
                List list = this.propsToRawResourceInfo(properties);
                GenericConverter genericConverter = new GenericConverter();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    RawResourceInfo rawResourceInfo = (RawResourceInfo)iterator.next();
                    try {
                        J2EEResource j2EEResource = genericConverter.rawInfoToResource(rawResourceInfo);
                        j2EEResourceCollectionImpl.addResource(j2EEResource);
                    }
                    catch (J2EEResourceException j2EEResourceException) {
                        _logger.log(Level.SEVERE, "enterprise.resource_exception", j2EEResourceException);
                    }
                }
                Object var13_15 = null;
                if (inputStream == null) return j2EEResourceCollectionImpl;
            }
            catch (Exception exception) {
                throw new J2EEResourceException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return j2EEResourceCollectionImpl;
    }

    public void storeDefaultResourceCollection(J2EEResourceCollection j2EEResourceCollection) throws J2EEResourceException {
        String string = FileUtil.getAbsolutePath(RESOURCE_PROP_RELATIVE_PATH);
        this.storeResourceCollection(j2EEResourceCollection, string);
    }

    /*
     * Loose catch block
     */
    public void storeResourceCollection(J2EEResourceCollection j2EEResourceCollection, String string) throws J2EEResourceException {
        block22: {
            IOException iOException2222;
            OutputStream outputStream;
            InputStream inputStream;
            OutputStream outputStream2;
            block20: {
                Object object;
                Object object2;
                outputStream2 = null;
                inputStream = null;
                outputStream = null;
                File file = File.createTempFile("resource", "");
                file.deleteOnExit();
                outputStream2 = new FileOutputStream(file);
                Vector<RawResourceInfo> vector = new Vector<RawResourceInfo>();
                Set set = j2EEResourceCollection.getAllResources();
                GenericConverter genericConverter = new GenericConverter();
                Object object3 = set.iterator();
                while (object3.hasNext()) {
                    object2 = (J2EEResource)object3.next();
                    object = genericConverter.resourceToRawInfo((J2EEResource)object2);
                    vector.add((RawResourceInfo)object);
                }
                this.storeRawInfoToPropsFile(vector, outputStream2);
                outputStream2.close();
                outputStream2 = null;
                inputStream = new FileInputStream(file);
                object3 = new BufferedReader(new InputStreamReader(inputStream));
                outputStream = new FileOutputStream(string);
                object2 = new BufferedWriter(new OutputStreamWriter(outputStream));
                while ((object = ((BufferedReader)object3).readLine()) != null) {
                    if (((String)object).startsWith("#")) continue;
                    ((Writer)object2).write((String)object);
                    ((BufferedWriter)object2).newLine();
                }
                ((BufferedWriter)object2).close();
                Object var14_14 = null;
                if (outputStream2 == null) break block20;
                try {
                    outputStream2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block22;
            {
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "enterprise.resource_exception", exception);
                    throw new J2EEResourceException(exception);
                }
            }
            catch (Throwable throwable) {
                IOException iOException32222;
                Object var14_15 = null;
                if (outputStream2 != null) {
                    try {
                        outputStream2.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public J2EEResource createResource(int n, String string) {
        J2EEResourceBase j2EEResourceBase = null;
        switch (n) {
            case 1: {
                j2EEResourceBase = new JmsDestinationResource(string);
                break;
            }
            case 2: {
                j2EEResourceBase = new JmsCnxFactoryResource(string);
                break;
            }
            case 3: {
                j2EEResourceBase = new JdbcResource(string);
                break;
            }
            case 4: {
                j2EEResourceBase = new JdbcXAResource(string);
                break;
            }
            case 5: {
                j2EEResourceBase = new JdbcDriver(string);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return j2EEResourceBase;
    }

    public ResourceProperty createProperty(String string) {
        return new ResourcePropertyImpl(string);
    }

    private List propsToRawResourceInfo(Properties properties) throws Exception {
        Vector<RawResourceInfo> vector = new Vector<RawResourceInfo>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            int n;
            String string2 = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, FIELD_SEPARATOR);
            String string3 = stringTokenizer.nextToken();
            RawResourceInfo rawResourceInfo = new RawResourceInfo(string3, n = Integer.parseInt(string = stringTokenizer.nextToken()));
            int n2 = vector.indexOf(rawResourceInfo);
            if (n2 == -1) {
                vector.add(rawResourceInfo);
            } else {
                rawResourceInfo = (RawResourceInfo)vector.elementAt(n2);
            }
            String string4 = stringTokenizer.nextToken();
            String string5 = (String)properties.get(string2);
            if (string4.equals(PROP_INDICATOR) && stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                rawResourceInfo.getProperties().put(string4, string5);
                continue;
            }
            rawResourceInfo.getAttributes().put(string4, string5);
        }
        return vector;
    }

    private void storeRawInfoToPropsFile(List list, OutputStream outputStream) throws IOException {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, new RawInfoSorter());
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            RawResourceInfo rawResourceInfo = (RawResourceInfo)objectArray[i];
            String string = rawResourceInfo.getResourceType();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) {
                n = new Integer(0);
            }
            String string2 = string + FIELD_SEPARATOR + n + FIELD_SEPARATOR;
            hashtable.put(string, new Integer(n + 1));
            this.writeNameValueCollection(outputStream, string2, rawResourceInfo.getAttributes());
            this.writeNameValueCollection(outputStream, string2 + PROP_INDICATOR + FIELD_SEPARATOR, rawResourceInfo.getProperties());
        }
    }

    private void writeNameValueCollection(OutputStream outputStream, String string, Hashtable hashtable) throws IOException {
        Set set = hashtable.entrySet();
        Object[] objectArray = set.toArray();
        Arrays.sort(objectArray, new NameValueSorter());
        for (int i = 0; i < objectArray.length; ++i) {
            Map.Entry entry = (Map.Entry)objectArray[i];
            this.writeNameValuePair(outputStream, string, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private void writeNameValuePair(OutputStream outputStream, String string, String string2, String string3) throws IOException {
        this.outputProperties_.clear();
        this.outputProperties_.put(string + string2, string3);
        this.outputProperties_.store(outputStream, null);
    }

    public static void main(String[] stringArray) {
        try {
            J2EEResource j2EEResource;
            String string = stringArray[0];
            J2EEResourceFactory j2EEResourceFactory = ServerConfiguration.getJ2EEResourceFactory();
            J2EEResourceCollection j2EEResourceCollection = j2EEResourceFactory.loadResourceCollection(string);
            JmsDestinationResource jmsDestinationResource = (JmsDestinationResource)j2EEResourceFactory.createResource(1, "jms/BlahQueue");
            jmsDestinationResource.setIsQueue(true);
            j2EEResourceCollection.addResource(jmsDestinationResource);
            J2EEResource j2EEResource2 = j2EEResourceCollection.getResourceByName(1, "FooQueue");
            if (j2EEResource2 != null) {
                j2EEResourceCollection.removeResource(j2EEResource2);
            }
            if ((j2EEResource = j2EEResourceCollection.getResourceByName(1, "FooTopic")) != null) {
                ((JmsDestinationResource)j2EEResource).setIsQueue(true);
            }
            j2EEResourceFactory.storeResourceCollection(j2EEResourceCollection, string);
            J2EEResource j2EEResource3 = j2EEResourceCollection.getResourceByName(4, "jdbc/Merant");
            _logger.log(Level.FINE, j2EEResource3.toString());
            J2EEResource j2EEResource4 = j2EEResourceCollection.getResourceByName(5, "a.b.c.d");
            _logger.log(Level.FINE, j2EEResource4.toString());
            _logger.log(Level.FINE, "Now trying server update");
            InitialContext initialContext = new InitialContext();
            Object object = initialContext.lookup("JarInstaller");
            Object object2 = PortableRemoteObject.narrow((Object)object, (Class)JarInstaller.class);
            JarInstaller jarInstaller = (JarInstaller)object2;
            jarInstaller.createDestination((JmsDestinationResource)j2EEResource2);
            jarInstaller.deleteDestination((JmsDestinationResource)j2EEResource2);
            jarInstaller.createDestination((JmsDestinationResource)j2EEResource);
            jarInstaller.deleteDestination((JmsDestinationResource)j2EEResource);
            JmsCnxFactoryResource jmsCnxFactoryResource = (JmsCnxFactoryResource)j2EEResourceCollection.getResourceByName(2, "jms/TopicConnectionFactory");
            jarInstaller.deleteJmsConnectionFactory(jmsCnxFactoryResource);
            jarInstaller.createJmsConnectionFactory(jmsCnxFactoryResource);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.resource_exception", exception);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        RESOURCE_PROP_RELATIVE_PATH = "config" + File.separator + "resource.properties";
    }

    private static class NameValueSorter
    implements Comparator {
        private NameValueSorter() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            Map.Entry entry = (Map.Entry)object;
            Map.Entry entry2 = (Map.Entry)object2;
            if (!((Object)entry).equals(entry2)) {
                String string = (String)entry.getKey();
                String string2 = (String)entry2.getKey();
                n = string.equals(J2EEResourceFactoryImpl.NAME_ATTRIBUTE) ? -1 : (string2.equals(J2EEResourceFactoryImpl.NAME_ATTRIBUTE) ? 1 : string.compareTo(string2));
            }
            return n;
        }
    }

    private static class RawInfoSorter
    implements Comparator {
        private RawInfoSorter() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            RawResourceInfo rawResourceInfo = (RawResourceInfo)object;
            RawResourceInfo rawResourceInfo2 = (RawResourceInfo)object2;
            if (!rawResourceInfo.equals(rawResourceInfo2)) {
                String string;
                String string2 = rawResourceInfo.getResourceType();
                if (string2.equals(string = rawResourceInfo2.getResourceType())) {
                    String string3 = (String)rawResourceInfo.getAttributes().get(J2EEResourceFactoryImpl.NAME_ATTRIBUTE);
                    String string4 = (String)rawResourceInfo2.getAttributes().get(J2EEResourceFactoryImpl.NAME_ATTRIBUTE);
                    n = string3.compareTo(string4);
                } else {
                    n = string2.compareTo(string);
                }
            }
            return n;
        }
    }
}

