/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.JmsResource;
import com.iplanet.ias.config.serverbeans.PersistenceManagerFactoryResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.enterprise.repository.CustomResource;
import com.sun.enterprise.repository.ExternalJndiResource;
import com.sun.enterprise.repository.IASJdbcResource;
import com.sun.enterprise.repository.IASJdbcXAResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceCollectionImpl;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.MailResource;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASJ2EEResourceFactoryImpl
implements J2EEResourceFactory {
    private static Logger _logger = null;
    static final String JMS_QUEUE = "javax.jms.Queue";
    static final String JMS_TOPIC = "javax.jms.Topic";
    static final String JMS_QUEUE_CONNECTION_FACTORY = "javax.jms.QueueConnectionFactory";
    static final String JMS_TOPIC_CONNECTION_FACTORY = "javax.jms.TopicConnectionFactory";
    public static final String CUSTOM_RES_TYPE = "custom-resource";
    public static final String EXT_JNDI_RES_TYPE = "external-jndi-resource";
    public static final String JDBC_RES_TYPE = "jdbc-resource";
    public static final String MAIL_RES_TYPE = "mail-resource";
    public static final String JMS_RES_TYPE = "jms-resource";
    public static final String PMF_RES_TYPE = "persistence-manager-factory-resource";
    public static final String JDBC_CONN_POOL_RES_TYPE = "jdbc-connection-pool";
    private ConfigContext ctx = null;
    private Resources rBean = null;

    public J2EEResourceCollection loadDefaultResourceCollection() throws J2EEResourceException {
        return this.loadResourceCollection(null);
    }

    public J2EEResourceCollection loadResourceCollection(String string) throws J2EEResourceException {
        J2EEResourceCollectionImpl j2EEResourceCollectionImpl = new J2EEResourceCollectionImpl();
        ServerContext serverContext = ApplicationServer.getServerContext();
        if (serverContext == null) {
            _logger.log(Level.FINE, "Not Running in server. Returning empty resources...");
            return j2EEResourceCollectionImpl;
        }
        try {
            this.ctx = serverContext.getConfigContext();
            this.rBean = ServerBeansFactory.getServerBean(this.ctx).getResources();
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "enterprise.empty_resource", configException);
            _logger.log(Level.FINE, "Error initializing context. Returning empty resources...");
            return j2EEResourceCollectionImpl;
        }
        try {
            _logger.log(Level.FINE, "Loading Jdbc Connection Pool==========");
            this.loadJdbcConnectionPool(j2EEResourceCollectionImpl);
            _logger.log(Level.FINE, "Loading Jdbc Resource==========");
            this.loadJdbcResource(j2EEResourceCollectionImpl);
            _logger.log(Level.FINE, "Loading Jms Resource==========");
            this.loadJmsResource(j2EEResourceCollectionImpl);
            _logger.log(Level.FINE, "Loading PMF Resource==========");
            this.loadPMFResource(j2EEResourceCollectionImpl);
            _logger.log(Level.FINE, "Loading Custom Resource==========");
            this.loadCustomResource(j2EEResourceCollectionImpl);
            _logger.log(Level.FINE, "Loading External Jndi Resource==========");
            this.loadExternalJndiResource(j2EEResourceCollectionImpl);
            _logger.log(Level.FINE, "Loading Mail Resource==========");
            this.loadMailResource(j2EEResourceCollectionImpl);
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "enterprise.config_exception", configException);
            _logger.log(Level.FINE, "Error Loading resources: " + configException.getMessage());
            throw new J2EEResourceException(configException);
        }
        return j2EEResourceCollectionImpl;
    }

    public void storeDefaultResourceCollection(J2EEResourceCollection j2EEResourceCollection) throws J2EEResourceException {
        this.storeResourceCollection(j2EEResourceCollection, null);
    }

    public void storeResourceCollection(J2EEResourceCollection j2EEResourceCollection, String string) throws J2EEResourceException {
    }

    public J2EEResource createResource(int n, String string) {
        J2EEResourceBase j2EEResourceBase = null;
        switch (n) {
            case 1: {
                j2EEResourceBase = new JmsDestinationResource(string);
                break;
            }
            case 2: {
                j2EEResourceBase = new JmsCnxFactoryResource(string);
                break;
            }
            case 3: {
                j2EEResourceBase = new JdbcResource(string);
                break;
            }
            case 4: {
                j2EEResourceBase = new JdbcXAResource(string);
                break;
            }
            case 5: {
                j2EEResourceBase = new JdbcDriver(string);
                break;
            }
            case 8: {
                j2EEResourceBase = new JdbcConnectionPool(string);
                break;
            }
            case 9: {
                j2EEResourceBase = new PMFResource(string);
                break;
            }
            case 11: {
                j2EEResourceBase = new CustomResource(string);
                break;
            }
            case 10: {
                j2EEResourceBase = new ExternalJndiResource(string);
                break;
            }
            case 12: {
                j2EEResourceBase = new MailResource(string);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return j2EEResourceBase;
    }

    public ResourceProperty createProperty(String string) {
        return new ResourcePropertyImpl(string);
    }

    private void loadJdbcResource(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        com.iplanet.ias.config.serverbeans.JdbcResource[] jdbcResourceArray = this.rBean.getJdbcResource();
        if (jdbcResourceArray == null) {
            return;
        }
        for (int i = 0; i < jdbcResourceArray.length; ++i) {
            com.iplanet.ias.config.serverbeans.JdbcResource jdbcResource = jdbcResourceArray[i];
            if (!jdbcResource.isEnabled()) {
                this.logMessageIfNotEnabled(jdbcResource.getJndiName(), JDBC_RES_TYPE);
                continue;
            }
            String string = jdbcResource.getPoolName();
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)j2EEResourceCollection.getResourceByName(8, string);
            if (jdbcConnectionPool == null) {
                _logger.log(Level.WARNING, "enterprise.connection_pool_does_not_exist", string);
                _logger.log(Level.WARNING, "enterprise.error_loading_jdbc_resource", jdbcResource.getJndiName());
                _logger.info("Error loading Jdbc Resource:" + jdbcResource.getJndiName() + ". skipping...");
                continue;
            }
            boolean bl = jdbcConnectionPool.isXA();
            J2EEResourceBase j2EEResourceBase = null;
            if (bl) {
                j2EEResourceBase = new IASJdbcXAResource(jdbcResource.getJndiName());
                ((IASJdbcXAResource)j2EEResourceBase).setJdbcConnectionPool(jdbcConnectionPool);
            } else {
                j2EEResourceBase = new IASJdbcResource(jdbcResource.getJndiName());
                ((IASJdbcResource)j2EEResourceBase).setJdbcConnectionPool(jdbcConnectionPool);
            }
            j2EEResourceBase.setEnabled(jdbcResource.isEnabled());
            j2EEResourceCollection.addResource(j2EEResourceBase);
        }
    }

    private void loadJmsResource(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        JmsResource[] jmsResourceArray = this.rBean.getJmsResource();
        if (jmsResourceArray == null) {
            return;
        }
        for (int i = 0; i < jmsResourceArray.length; ++i) {
            JmsResource jmsResource = jmsResourceArray[i];
            if (!jmsResource.isEnabled()) {
                this.logMessageIfNotEnabled(jmsResource.getJndiName(), JMS_RES_TYPE);
                continue;
            }
            J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toJMSJ2EEResource(jmsResource);
            if (j2EEResource == null) {
                _logger.log(Level.SEVERE, "Error loading resource associated with " + jmsResource.getJndiName());
                continue;
            }
            j2EEResourceCollection.addResource(j2EEResource);
        }
    }

    public static J2EEResource toJMSJ2EEResource(JmsResource jmsResource) throws ConfigException {
        String string = jmsResource.getResType();
        if (string == null) {
            throw new ConfigException("Bad JMS Resource (null type)");
        }
        J2EEResourceBase j2EEResourceBase = null;
        if (string.equals(JMS_QUEUE) || string.equals(JMS_TOPIC)) {
            j2EEResourceBase = new JmsDestinationResource(jmsResource.getJndiName());
            ((JmsDestinationResource)j2EEResourceBase).setIsQueue(string.equals(JMS_QUEUE));
            ElementProperty[] elementPropertyArray = jmsResource.getElementProperty();
            if (elementPropertyArray != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    ElementProperty elementProperty = elementPropertyArray[i];
                    ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                    j2EEResourceBase.addProperty(resourcePropertyImpl);
                }
            }
        } else if (string.equals(JMS_QUEUE_CONNECTION_FACTORY) || string.equals(JMS_TOPIC_CONNECTION_FACTORY)) {
            j2EEResourceBase = new JmsCnxFactoryResource(jmsResource.getJndiName());
            ((JmsCnxFactoryResource)j2EEResourceBase).setIsQueue(string.equals(JMS_QUEUE_CONNECTION_FACTORY));
            ElementProperty[] elementPropertyArray = jmsResource.getElementProperty();
            if (elementPropertyArray != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    ElementProperty elementProperty = elementPropertyArray[i];
                    ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                    j2EEResourceBase.addProperty(resourcePropertyImpl);
                }
            }
        } else {
            _logger.log(Level.SEVERE, "Unknown Resource of type " + string);
            _logger.log(Level.FINE, "Error Loading resource " + string);
            return null;
        }
        j2EEResourceBase.setEnabled(jmsResource.isEnabled());
        return j2EEResourceBase;
    }

    private void loadJdbcConnectionPool(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        com.iplanet.ias.config.serverbeans.JdbcConnectionPool[] jdbcConnectionPoolArray = this.rBean.getJdbcConnectionPool();
        if (jdbcConnectionPoolArray == null) {
            return;
        }
        for (int i = 0; i < jdbcConnectionPoolArray.length; ++i) {
            com.iplanet.ias.config.serverbeans.JdbcConnectionPool jdbcConnectionPool = jdbcConnectionPoolArray[i];
            JdbcConnectionPool jdbcConnectionPool2 = IASJ2EEResourceFactoryImpl.loadJdbcConnectionPool(jdbcConnectionPool);
            j2EEResourceCollection.addResource(jdbcConnectionPool2);
        }
    }

    public static JdbcConnectionPool loadJdbcConnectionPool(com.iplanet.ias.config.serverbeans.JdbcConnectionPool jdbcConnectionPool) throws ConfigException {
        JdbcConnectionPool jdbcConnectionPool2 = new JdbcConnectionPool(jdbcConnectionPool.getName());
        jdbcConnectionPool2.setDatasourceClassname(jdbcConnectionPool.getDatasourceClassname());
        jdbcConnectionPool2.setMaxPoolSize(jdbcConnectionPool.getMaxPoolSize());
        jdbcConnectionPool2.setSteadyPoolSize(jdbcConnectionPool.getSteadyPoolSize());
        jdbcConnectionPool2.setMaxWaitTimeInMillis(jdbcConnectionPool.getMaxWaitTimeInMillis());
        jdbcConnectionPool2.setPoolResizeQuantity(jdbcConnectionPool.getPoolResizeQuantity());
        jdbcConnectionPool2.setIdleTimeoutInSeconds(jdbcConnectionPool.getIdleTimeoutInSeconds());
        jdbcConnectionPool2.setIsConnectionValidationRequired(jdbcConnectionPool.isIsConnectionValidationRequired());
        jdbcConnectionPool2.setConnectionValidationMethod(jdbcConnectionPool.getConnectionValidationMethod());
        jdbcConnectionPool2.setValidationTableName(jdbcConnectionPool.getValidationTableName());
        jdbcConnectionPool2.setFailAllConnections(jdbcConnectionPool.isFailAllConnections());
        jdbcConnectionPool2.setResType(jdbcConnectionPool.getResType());
        jdbcConnectionPool2.setTransactionIsolationLevel(jdbcConnectionPool.getTransactionIsolationLevel());
        jdbcConnectionPool2.setIsIsolationLevelGuaranteed(jdbcConnectionPool.isIsIsolationLevelGuaranteed());
        ElementProperty[] elementPropertyArray = jdbcConnectionPool.getElementProperty();
        if (elementPropertyArray != null) {
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                ElementProperty elementProperty = elementPropertyArray[i];
                ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                jdbcConnectionPool2.addProperty(resourcePropertyImpl);
            }
        }
        return jdbcConnectionPool2;
    }

    private void loadCustomResource(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        com.iplanet.ias.config.serverbeans.CustomResource[] customResourceArray = this.rBean.getCustomResource();
        if (customResourceArray == null) {
            return;
        }
        for (int i = 0; i < customResourceArray.length; ++i) {
            com.iplanet.ias.config.serverbeans.CustomResource customResource = customResourceArray[i];
            if (!customResource.isEnabled()) {
                this.logMessageIfNotEnabled(customResource.getJndiName(), CUSTOM_RES_TYPE);
                continue;
            }
            J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toCustomJ2EEResource(customResource);
            j2EEResourceCollection.addResource(j2EEResource);
        }
    }

    public static J2EEResource toCustomJ2EEResource(com.iplanet.ias.config.serverbeans.CustomResource customResource) throws ConfigException {
        CustomResource customResource2 = new CustomResource(customResource.getJndiName());
        customResource2.setEnabled(customResource.isEnabled());
        customResource2.setResType(customResource.getResType());
        customResource2.setFactoryClass(customResource.getFactoryClass());
        ElementProperty[] elementPropertyArray = customResource.getElementProperty();
        if (elementPropertyArray != null) {
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                ElementProperty elementProperty = elementPropertyArray[i];
                ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                customResource2.addProperty(resourcePropertyImpl);
            }
        }
        return customResource2;
    }

    public static J2EEResource toExternalJndiJ2EEResource(com.iplanet.ias.config.serverbeans.ExternalJndiResource externalJndiResource) throws ConfigException {
        ExternalJndiResource externalJndiResource2 = new ExternalJndiResource(externalJndiResource.getJndiName());
        externalJndiResource2.setEnabled(externalJndiResource.isEnabled());
        externalJndiResource2.setJndiLookupName(externalJndiResource.getJndiLookupName());
        externalJndiResource2.setResType(externalJndiResource.getResType());
        externalJndiResource2.setFactoryClass(externalJndiResource.getFactoryClass());
        ElementProperty[] elementPropertyArray = externalJndiResource.getElementProperty();
        if (elementPropertyArray != null) {
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                ElementProperty elementProperty = elementPropertyArray[i];
                ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                externalJndiResource2.addProperty(resourcePropertyImpl);
            }
        }
        return externalJndiResource2;
    }

    private void loadExternalJndiResource(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        com.iplanet.ias.config.serverbeans.ExternalJndiResource[] externalJndiResourceArray = this.rBean.getExternalJndiResource();
        if (externalJndiResourceArray == null) {
            return;
        }
        for (int i = 0; i < externalJndiResourceArray.length; ++i) {
            com.iplanet.ias.config.serverbeans.ExternalJndiResource externalJndiResource = externalJndiResourceArray[i];
            if (!externalJndiResource.isEnabled()) {
                this.logMessageIfNotEnabled(externalJndiResource.getJndiName(), EXT_JNDI_RES_TYPE);
                continue;
            }
            J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toExternalJndiJ2EEResource(externalJndiResource);
            j2EEResourceCollection.addResource(j2EEResource);
        }
    }

    private void loadPMFResource(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        PersistenceManagerFactoryResource[] persistenceManagerFactoryResourceArray = this.rBean.getPersistenceManagerFactoryResource();
        if (persistenceManagerFactoryResourceArray == null) {
            return;
        }
        for (int i = 0; i < persistenceManagerFactoryResourceArray.length; ++i) {
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = persistenceManagerFactoryResourceArray[i];
            if (!persistenceManagerFactoryResource.isEnabled()) {
                this.logMessageIfNotEnabled(persistenceManagerFactoryResource.getJndiName(), PMF_RES_TYPE);
                continue;
            }
            j2EEResourceCollection.addResource(IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(persistenceManagerFactoryResource));
        }
    }

    public static J2EEResource toPMFJ2EEResource(PersistenceManagerFactoryResource persistenceManagerFactoryResource) throws ConfigException {
        PMFResource pMFResource = new PMFResource(persistenceManagerFactoryResource.getJndiName());
        pMFResource.setEnabled(persistenceManagerFactoryResource.isEnabled());
        pMFResource.setFactoryClass(persistenceManagerFactoryResource.getFactoryClass());
        pMFResource.setJdbcResourceJndiName(persistenceManagerFactoryResource.getJdbcResourceJndiName());
        ElementProperty[] elementPropertyArray = persistenceManagerFactoryResource.getElementProperty();
        if (elementPropertyArray != null) {
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                ElementProperty elementProperty = elementPropertyArray[i];
                ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                pMFResource.addProperty(resourcePropertyImpl);
            }
        }
        return pMFResource;
    }

    public static J2EEResource toMailJ2EEResource(com.iplanet.ias.config.serverbeans.MailResource mailResource) throws ConfigException {
        MailResource mailResource2 = new MailResource(mailResource.getJndiName());
        mailResource2.setEnabled(mailResource.isEnabled());
        mailResource2.setStoreProtocol(mailResource.getStoreProtocol());
        mailResource2.setStoreProtocolClass(mailResource.getStoreProtocolClass());
        mailResource2.setTransportProtocol(mailResource.getTransportProtocol());
        mailResource2.setTransportProtocolClass(mailResource.getTransportProtocolClass());
        mailResource2.setMailHost(mailResource.getHost());
        mailResource2.setUsername(mailResource.getUser());
        mailResource2.setMailFrom(mailResource.getFrom());
        mailResource2.setDebug(mailResource.isDebug());
        ElementProperty[] elementPropertyArray = mailResource.getElementProperty();
        if (elementPropertyArray != null) {
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                ElementProperty elementProperty = elementPropertyArray[i];
                ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                mailResource2.addProperty(resourcePropertyImpl);
            }
        }
        return mailResource2;
    }

    private void loadMailResource(J2EEResourceCollection j2EEResourceCollection) throws ConfigException {
        com.iplanet.ias.config.serverbeans.MailResource[] mailResourceArray = this.rBean.getMailResource();
        if (mailResourceArray == null) {
            return;
        }
        for (int i = 0; i < mailResourceArray.length; ++i) {
            com.iplanet.ias.config.serverbeans.MailResource mailResource = mailResourceArray[i];
            if (!mailResource.isEnabled()) {
                this.logMessageIfNotEnabled(mailResource.getJndiName(), MAIL_RES_TYPE);
                continue;
            }
            J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(mailResource);
            j2EEResourceCollection.addResource(j2EEResource);
        }
    }

    private void logMessageIfNotEnabled(String string, String string2) {
        _logger.log(Level.INFO, "enterprise.resource_disabled", new Object[]{string, string2});
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
    }
}

