/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.iplanet.ias.connectors.util.xml.ConnectorDeploymentObject;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceConverter;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.RawResourceInfo;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericConverter
implements J2EEResourceConverter {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private static final String RESOURCE_NAME_ATTR = "name";
    private static Hashtable resourceImplClasses;
    private static Hashtable attributeMethods;
    private int counter = 0;

    public J2EEResource rawInfoToResource(RawResourceInfo rawResourceInfo) throws J2EEResourceException {
        J2EEResource j2EEResource = null;
        try {
            String string;
            Object object;
            Object object2;
            Class clazz = (Class)resourceImplClasses.get(rawResourceInfo.getResourceType());
            if (clazz == null) {
                String string2 = localStrings.getLocalString("GenericConverter.unknown.resource.type", "Unknown resource type {0}", new Object[]{rawResourceInfo.getResourceType()});
                throw new J2EEResourceException(string2);
            }
            Class[] classArray = new Class[]{String.class};
            Constructor constructor = clazz.getConstructor(classArray);
            String string3 = (String)rawResourceInfo.getAttributes().get(RESOURCE_NAME_ATTR);
            if (string3 == null) {
                String string4 = localStrings.getLocalString("GenericConverter.name.attribute.required", "Resource type {0} with index {1} is missing a 'name' attribute", new Object[]{rawResourceInfo.getResourceType(), new Integer(rawResourceInfo.getIndex())});
                throw new J2EEResourceException(string4);
            }
            Object[] objectArray = new Object[]{string3};
            j2EEResource = (J2EEResource)constructor.newInstance(objectArray);
            Set set = rawResourceInfo.getAttributes().entrySet();
            Object object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = (String)object2.getKey();
                string = (String)object2.getValue();
                try {
                    if (((String)object).equals(RESOURCE_NAME_ATTR)) continue;
                    Utility.invokeSetMethod(j2EEResource, (String)object, string);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    String string5 = localStrings.getLocalString("GenericConverter.invalid.attribute", "Attribute {0} of resource type {1} with index {2} is invalid", new Object[]{object, rawResourceInfo.getResourceType(), new Integer(rawResourceInfo.getIndex())});
                    throw new J2EEResourceException(string5);
                }
            }
            object3 = rawResourceInfo.getProperties().entrySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                string = (String)object.getKey();
                ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(string);
                resourcePropertyImpl.setValue(object.getValue());
                j2EEResource.addProperty(resourcePropertyImpl);
            }
        }
        catch (J2EEResourceException j2EEResourceException) {
            throw j2EEResourceException;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.rawinfotoresource_exception", exception);
            throw new J2EEResourceException(exception);
        }
        return j2EEResource;
    }

    public RawResourceInfo resourceToRawInfo(J2EEResource j2EEResource) throws J2EEResourceException {
        RawResourceInfo rawResourceInfo = null;
        try {
            Object object;
            Object object2;
            Object[] objectArray = new Class[]{};
            Class<?> clazz = j2EEResource.getClass();
            String string = this.getResourceType(clazz.getName());
            rawResourceInfo = new RawResourceInfo(string, this.counter);
            ++this.counter;
            List list = GenericConverter.getAttributeMethods(clazz);
            Object object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Method)object3.next();
                object = ((Method)object2).invoke((Object)j2EEResource, objectArray);
                if (object == null) {
                    object = "";
                }
                String string2 = ((Method)object2).getName().substring(3);
                string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                rawResourceInfo.getAttributes().put(string2, object);
            }
            object3 = j2EEResource.getProperties();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (ResourceProperty)object2.next();
                rawResourceInfo.getProperties().put(object.getName(), object.getValue());
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.resourcetorawinfo_exception", exception);
            throw new J2EEResourceException(exception);
        }
        return rawResourceInfo;
    }

    private String getResourceType(String string) {
        Set set = resourceImplClasses.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class clazz = (Class)entry.getValue();
            if (!clazz.getName().equals(string)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException();
    }

    private static List getAttributeMethods(Class clazz) throws Exception {
        Class[] classArray = new Class[]{};
        Method[] methodArray = new Method[]{clazz.getMethod("getType", classArray), clazz.getMethod("getProperties", classArray), clazz.getMethod("getProperty", String.class), Object.class.getMethod("getClass", classArray)};
        Vector<Method> vector = (Vector<Method>)attributeMethods.get(clazz.getName());
        if (vector == null) {
            vector = new Vector<Method>();
            Method[] methodArray2 = clazz.getMethods();
            for (int i = 0; i < methodArray2.length; ++i) {
                Method method = methodArray2[i];
                if (!GenericConverter.isStorableAttrMethod(method, methodArray)) continue;
                vector.add(method);
            }
            attributeMethods.put(clazz.getName(), vector);
        }
        return vector;
    }

    private static boolean isStorableAttrMethod(Method method, Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            if (!method.equals(methodArray[i])) continue;
            return false;
        }
        return method.getName().startsWith("get");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        localStrings = new LocalStringManagerImpl(GenericConverter.class);
        resourceImplClasses = new Hashtable();
        attributeMethods = new Hashtable();
        resourceImplClasses.put("jmsCnxFactory", JmsCnxFactoryResource.class);
        resourceImplClasses.put("jmsDestination", JmsDestinationResource.class);
        resourceImplClasses.put("jdbcDataSource", JdbcResource.class);
        resourceImplClasses.put("jdbcXADataSource", JdbcXAResource.class);
        resourceImplClasses.put("jdbcDriver", JdbcDriver.class);
        resourceImplClasses.put("connectorCnxFactory", InstancePropertiesObject.class);
        resourceImplClasses.put("resourceAdapter", ConnectorDeploymentObject.class);
    }
}

