/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.naming.SerialNameParser;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class TransientContext
implements Context,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    public static final boolean debug = false;
    Hashtable myEnv;
    private Hashtable bindings = new Hashtable();
    static NameParser myParser = new SerialNameParser();

    public Context createSubcontext(String string) throws NamingException {
        return this.drillDownAndCreateSubcontext(string);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        this.drillDownAndDestroySubcontext(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context drillDownAndCreateSubcontext(String string) throws NamingException {
        TransientContext transientContext;
        CompositeName compositeName = new CompositeName(string);
        if (compositeName.size() < 1) {
            throw new InvalidNameException("Cannot create empty subcontext");
        }
        if (compositeName.size() == 1) {
            if (this.bindings.containsKey(string)) {
                throw new NameAlreadyBoundException("Subcontext " + string + "already present");
            }
            TransientContext transientContext2 = null;
            transientContext2 = new TransientContext();
            this.bindings.put(string, transientContext2);
            return transientContext2;
        }
        String string2 = compositeName.getSuffix(1).toString();
        try {
            transientContext = this.resolveContext(compositeName.get(0));
        }
        catch (NameNotFoundException nameNotFoundException) {
            transientContext = new TransientContext();
        }
        Context context = transientContext.createSubcontext(string2);
        this.bindings.put(compositeName.get(0), transientContext);
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drillDownAndDestroySubcontext(String string) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        if (compositeName.size() < 1) {
            throw new InvalidNameException("Cannot destoy empty subcontext");
        }
        if (compositeName.size() == 1) {
            if (!this.bindings.containsKey(string)) throw new NameNotFoundException("Subcontext: " + string + " not found");
            this.bindings.remove(string);
            return;
        } else {
            String string2 = compositeName.getSuffix(1).toString();
            TransientContext transientContext = this.resolveContext(compositeName.get(0));
            transientContext.destroySubcontext(string2);
        }
    }

    public Object lookup(String string) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        if (compositeName.size() < 1) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (compositeName.size() == 1) {
            return this.doLookup(((Object)compositeName).toString());
        }
        String string2 = compositeName.getSuffix(1).toString();
        TransientContext transientContext = this.resolveContext(compositeName.get(0));
        return transientContext.lookup(string2);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    private Object doLookup(String string) throws NamingException {
        Object v = this.bindings.get(string);
        if (v == null) {
            throw new NameNotFoundException(string + " not found");
        }
        return v;
    }

    public void bind(String string, Object object) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        if (compositeName.size() < 1) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (compositeName.size() == 1) {
            this.doBindOrRebind(((Object)compositeName).toString(), object, false);
        } else {
            Context context;
            String string2 = compositeName.getSuffix(1).toString();
            try {
                context = this.resolveContext(compositeName.get(0));
            }
            catch (NameNotFoundException nameNotFoundException) {
                context = this.createSubcontext(compositeName.get(0));
            }
            context.bind(string2, object);
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    private TransientContext resolveContext(String string) throws NamingException {
        Object v = this.bindings.get(string);
        if (v == null) {
            throw new NameNotFoundException();
        }
        if (!(v instanceof TransientContext)) {
            throw new NameAlreadyBoundException(string);
        }
        TransientContext transientContext = (TransientContext)v;
        return transientContext;
    }

    private void doBindOrRebind(String string, Object object, boolean bl) throws NamingException {
        if (string.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (!bl && this.bindings.get(string) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(string, object);
    }

    public void rebind(String string, Object object) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        if (compositeName.size() < 1) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (compositeName.size() == 1) {
            this.doBindOrRebind(((Object)compositeName).toString(), object, true);
        } else {
            String string2 = compositeName.getSuffix(1).toString();
            Context context = null;
            try {
                context = this.resolveContext(compositeName.get(0));
                context.rebind(string2, object);
            }
            catch (NameNotFoundException nameNotFoundException) {
                context = this.createSubcontext(compositeName.get(0));
                context.rebind(string2, object);
            }
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    private void doUnbind(String string) throws NamingException {
        if (string.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        if (this.bindings.get(string) == null) {
            throw new NameNotFoundException("Cannot find name to unbind");
        }
        this.bindings.remove(string);
    }

    public void unbind(String string) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        if (compositeName.size() < 1) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        if (compositeName.size() == 1) {
            this.doUnbind(((Object)compositeName).toString());
        } else {
            String string2 = compositeName.getSuffix(1).toString();
            TransientContext transientContext = this.resolveContext(compositeName.get(0));
            transientContext.unbind(string2);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        if (string.equals("") || string2.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.bindings.get(string2) != null) {
            throw new NameAlreadyBoundException(string2 + " is already bound");
        }
        Object v = this.bindings.remove(string);
        if (v == null) {
            throw new NameNotFoundException(string + " not bound");
        }
        this.bindings.put(string2, v);
    }

    public Hashtable list() {
        return this.bindings;
    }

    public Hashtable listContext(String string) throws NamingException {
        if (string.equals("")) {
            return this.bindings;
        }
        Object object = this.lookup(string);
        if (object instanceof TransientContext) {
            return ((TransientContext)object).listContext("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.equals("")) {
            return new RepNames(this.bindings);
        }
        Object object = this.lookup(string);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.equals("")) {
            return new RepBindings(this.bindings);
        }
        Object object = this.lookup(string);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String string, String string2) throws NamingException {
        return null;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace() not implemented");
    }

    private static void print(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "[" + k + ":" + k.getClass().getName() + ", " + v + ":" + v.getClass().getName() + "]");
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable hashtable) {
            this.bindings = hashtable;
            this.names = hashtable.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = (String)this.names.nextElement();
                return new Binding(string, this.bindings.get(string));
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable hashtable) {
            this.bindings = hashtable;
            this.names = hashtable.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String string = (String)this.names.nextElement();
                String string2 = this.bindings.get(string).getClass().getName();
                return new NameClassPair(string, string2);
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

