/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.iplanet.ias.jms.IASJmsUtil;
import com.sun.appserv.naming.S1ASCtxFactory;
import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.jms.ConnectionFactoryWrapper;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.naming.BindingsEnum;
import com.sun.enterprise.naming.J2EEEnvWrapper;
import com.sun.enterprise.naming.NamePairsEnum;
import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.naming.java.javaURLContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import com.sun.jndi.cosnaming.CNCtxFactory;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.mail.Session;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.omg.CORBA.Object;

public final class NamingManagerImpl
implements NamingManager {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    public static final String SERIALOBJECT_FACTORY = "com.sun.enterprise.naming.factory.SerialObjectFactory";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String MAIL_COMPONENT_FACTORY = "com.sun.enterprise.naming.factory.MailSessionObjectFactory";
    public static final String JMS_CONNECTION_FACTORY_FACTORY = "com.sun.enterprise.naming.factory.JmsConnectionFactoryFactory";
    public static final String LOCAL_HOME_FACTORY = "com.sun.enterprise.naming.factory.LocalHomeFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String CONTEXT_SEPARATOR = "/";
    private static final String ID_SEPARATOR = "_";
    private static final int UNKNOWN_COMPONENT = 0;
    private static final int EJB_COMPONENT = 1;
    private static final int WEB_COMPONENT = 2;
    private static final int APP_CLIENT_COMPONENT = 3;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NamingManagerImpl.class);
    private SerialContextProvider serialContext;
    private Context initialContext;
    private Context cosContext;
    private InvocationManager im = null;
    private Switch theSwitch = null;
    private NameParser nameParser = new SerialNameParser();
    private Hashtable namespaces;
    public static final String EIS_STRING = "/eis/";
    private boolean isSerialCtx;
    private Properties cosNamingEnv = new Properties();

    public NamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public NamingManagerImpl(InitialContext initialContext) throws NamingException {
        this((Context)initialContext);
    }

    public NamingManagerImpl(Context context) throws NamingException {
        this.initialContext = context;
        this.namespaces = new Hashtable();
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
        this.cosNamingEnv.put("java.naming.corba.orb", ORBManager.getORB());
        if (this.theSwitch.getContainerType() == 2) {
            try {
                this.cosContext = new CNCtxFactory().getInitialContext((Hashtable)this.cosNamingEnv);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cosContext == null) {
            this.isSerialCtx = true;
            if (context != null) {
                this.cosContext = context;
            } else {
                this.initialContext = this.cosContext = new S1ASCtxFactory().getInitialContext(new Properties());
            }
        }
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public void publishObject(String string, java.lang.Object object, boolean bl) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        this.publishObject(compositeName, object, bl);
    }

    public void publishObject(Name name, java.lang.Object object, boolean bl) throws NamingException {
        java.lang.Object object2 = object;
        if (this.isCOSNamingObj(object)) {
            this.createSubContexts(name, this.cosContext);
            if (bl) {
                this.cosContext.rebind(name, object);
            } else {
                this.cosContext.bind(name, object);
            }
            object2 = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        }
        if (bl) {
            this.initialContext.rebind(name, object2);
        } else {
            this.initialContext.bind(name, object2);
        }
    }

    public void unpublishObject(String string) throws NamingException {
        java.lang.Object object = this.initialContextLookup(string);
        if (this.isCOSNamingObj(object)) {
            this.cosContext.unbind(string);
        }
        this.initialContext.unbind(string);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context context) throws NamingException {
        int n = name.size() - 1;
        Context context2 = context;
        for (int i = 0; i < n; ++i) {
            Context context3;
            String string = name.get(i);
            try {
                java.lang.Object object = context2.lookup(string);
                if (object == null) {
                    context2 = context3 = context2.createSubcontext(string);
                    continue;
                }
                if (object instanceof Context) {
                    context2 = (Context)object;
                    continue;
                }
                throw new NameAlreadyBoundException(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
                context2 = context3 = context2.createSubcontext(string);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String bindObjects(JndiNameEnvironment jndiNameEnvironment) throws NamingException {
        java.lang.Object object;
        java.lang.Object object2;
        String string;
        EnvironmentProperty environmentProperty;
        String string2 = this.getMangledIdName(jndiNameEnvironment);
        HashMap<java.lang.Object, java.lang.Object> hashMap = new HashMap<java.lang.Object, java.lang.Object>();
        this.namespaces.put(string2, hashMap);
        hashMap.put("java:", new javaURLContext("java:", null, this));
        hashMap.put("java:comp", new javaURLContext("java:comp", null, this));
        hashMap.put("java:comp/env", new javaURLContext("java:comp/env", null, this));
        Iterator iterator = jndiNameEnvironment.getEnvironmentProperties().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (EnvironmentProperty)iterator.next();
            string = this.descriptorToLogicalJndiName(environmentProperty);
            object2 = environmentProperty.getValueObject();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{string}));
            }
            if (hashMap.put(string, object2) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{environmentProperty.getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, string);
        }
        iterator = jndiNameEnvironment.getJmsDestinationReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (JmsDestinationReferenceDescriptor)iterator.next();
            string = this.descriptorToLogicalJndiName(environmentProperty);
            object2 = ((JmsDestinationReferenceDescriptor)environmentProperty).getJndiName();
            object = null;
            try {
                object = this.initialContextLookup((String)object2);
            }
            catch (NamingException namingException) {
                _logger.log(Level.SEVERE, "enterprise_naming.notfound_jmsdestination", object2);
                _logger.log(Level.SEVERE, namingException.getClass().getName(), namingException);
                throw new InvalidNameException(localStrings.getLocalString("naming.notfound_jmsdestination", "JMS destination object not found: " + (String)object2, new java.lang.Object[]{object2}));
            }
            if (object instanceof Queue ? !((JmsDestinationReferenceDescriptor)environmentProperty).getRefType().equals("javax.jms.Queue") : object instanceof Topic && !((JmsDestinationReferenceDescriptor)environmentProperty).getRefType().equals("javax.jms.Topic")) {
                throw new InvalidNameException(localStrings.getLocalString("naming.destinationRefTypeMismatch", "", new java.lang.Object[]{environmentProperty.getName(), ((JmsDestinationReferenceDescriptor)environmentProperty).getRefType()}));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{string}));
            }
            if (hashMap.put(string, object) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{environmentProperty.getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, string);
        }
        iterator = jndiNameEnvironment.getEjbReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (EjbReferenceDescriptor)iterator.next();
            string = this.descriptorToLogicalJndiName(environmentProperty);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{string}));
            }
            object2 = ((EjbReferenceDescriptor)environmentProperty).getValue();
            object = null;
            object = ((EjbReferenceDescriptor)environmentProperty).isLocal() ? new J2EEEnvWrapper(object2, 4) : new J2EEEnvWrapper(object2, 3);
            if (hashMap.put(string, object) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{environmentProperty.getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, string);
        }
        iterator = jndiNameEnvironment.getResourceReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            java.lang.Object object3;
            java.lang.Object object4;
            environmentProperty = (ResourceReferenceDescriptor)iterator.next();
            ((ResourceReferenceDescriptor)environmentProperty).checkType();
            string = environmentProperty.getName();
            object2 = this.descriptorToLogicalJndiName(environmentProperty);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{object2}));
            }
            if ((object = environmentProperty.getValue()) == null || ((String)object).equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + string);
            }
            java.lang.Object object5 = null;
            if (((ResourceReferenceDescriptor)environmentProperty).isMailResource()) {
                object5 = new J2EEEnvWrapper(object, 2);
            } else if (((ResourceReferenceDescriptor)environmentProperty).isURLResource()) {
                object4 = ((ResourceReferenceDescriptor)environmentProperty).getJndiName();
                try {
                    object5 = new URL((String)object4);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new InvalidNameException(localStrings.getLocalString("naming.malformedURL", "Malformed URL:'{0}'", new java.lang.Object[]{object4}));
                }
                object5 = new J2EEEnvWrapper(object5, 1);
            } else if (((ResourceReferenceDescriptor)environmentProperty).isJMSConnectionFactory()) {
                Serializable serializable;
                java.lang.Object object6;
                int n = this.getComponentType(jndiNameEnvironment);
                object3 = null;
                switch (n) {
                    case 1: {
                        object3 = JmsWrapperFactory.getFactoryForEjb();
                        break;
                    }
                    case 2: {
                        object3 = JmsWrapperFactory.getFactoryForWeb();
                        break;
                    }
                    case 3: {
                        object3 = JmsWrapperFactory.getFactoryForAppClient();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid component type = " + n);
                    }
                }
                ConnectionFactory connectionFactory = null;
                try {
                    object6 = this.initialContextLookup((String)object);
                    if (object6 instanceof ConnectionFactoryWrapperStandalone) {
                        serializable = (ConnectionFactoryWrapperStandalone)object6;
                        connectionFactory = ((ConnectionFactoryWrapperStandalone)serializable).getDelegate();
                    } else {
                        if (!(object6 instanceof ConnectionFactory)) throw new NamingException(localStrings.getLocalString("naming.unexpected_objtype", "Unexpected object type " + object6.getClass().getName() + " for " + (String)object, new java.lang.Object[]{object6.getClass().getName(), object}));
                        connectionFactory = (ConnectionFactory)object6;
                        this.initialContext.rebind(IASJmsUtil.getXAConnectionFactoryName((String)object), IASJmsUtil.wrapJMSConnectionFactoryObject(object6));
                    }
                }
                catch (NameNotFoundException nameNotFoundException) {
                    _logger.log(Level.SEVERE, "enterprise_naming.notfound_jmsconnfactory", object);
                    _logger.log(Level.SEVERE, nameNotFoundException.getClass().getName(), nameNotFoundException);
                    throw new InvalidNameException(localStrings.getLocalString("naming.notfound_jmsconnfactory", "JMS connection factory resource not found: " + (String)object, new java.lang.Object[]{object}));
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, exception.getClass().getName(), exception);
                    serializable = new NamingException(exception.getMessage());
                    ((NamingException)serializable).setRootCause(exception);
                    throw serializable;
                }
                object6 = IASJmsUtil.getXAConnectionFactoryName((String)object);
                if (connectionFactory instanceof QueueConnectionFactory) {
                    if (!((ResourceReferenceDescriptor)environmentProperty).getType().equals("javax.jms.QueueConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{string, ((ResourceReferenceDescriptor)environmentProperty).getType()}));
                    object5 = ((JmsWrapperFactory)object3).createQueueConnectionFactoryWrapper((String)object6, (ResourceReferenceDescriptor)environmentProperty);
                } else {
                    if (!((ResourceReferenceDescriptor)environmentProperty).getType().equals("javax.jms.TopicConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{string, ((ResourceReferenceDescriptor)environmentProperty).getType()}));
                    object5 = ((JmsWrapperFactory)object3).createTopicConnectionFactoryWrapper((String)object6, (ResourceReferenceDescriptor)environmentProperty);
                }
                if (object5 instanceof ConnectionFactoryWrapper) {
                    ((ConnectionFactoryWrapper)object5).setProvider(this.initialContext);
                    object5 = new J2EEEnvWrapper(object5, 6);
                } else {
                    object5 = new J2EEEnvWrapper(object5, 1);
                }
            } else if (this.isConnector((String)object2)) {
                object5 = new J2EEEnvWrapper(object, 7);
            } else if (((ResourceReferenceDescriptor)environmentProperty).isJDBCResource()) {
                try {
                    object4 = this.initialContextLookup((String)object);
                    object5 = new J2EEEnvWrapper(object4, 8);
                }
                catch (NamingException namingException) {
                    object3 = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{object2, object});
                    _logger.log(Level.FINE, (String)object3);
                }
                if (object5 == null) {
                    object5 = new J2EEEnvWrapper(object, 5);
                }
            } else {
                try {
                    object4 = this.initialContextLookup((String)object);
                    object5 = new J2EEEnvWrapper(object4, 1);
                }
                catch (NamingException namingException) {
                    object3 = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{object2, object});
                    _logger.log(Level.FINE, (String)object3);
                }
                if (object5 == null) {
                    object5 = new J2EEEnvWrapper(object, 5);
                }
            }
            if (hashMap.put(object2, object5) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{environmentProperty.getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, (String)object2);
        }
        return string2;
    }

    private void bindIntermediateContexts(HashMap hashMap, String string) throws NamingException {
        string = string.substring("java:comp/".length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, CONTEXT_SEPARATOR, false);
        String string2 = "java:comp";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (hashMap.get(string2 = string2 + CONTEXT_SEPARATOR + string3) != null) continue;
            hashMap.put(string2, new javaURLContext(string2, null, this));
        }
    }

    public void unbindObjects(JndiNameEnvironment jndiNameEnvironment) throws NamingException {
        String string = this.getMangledIdName(jndiNameEnvironment);
        this.namespaces.remove(string);
    }

    public java.lang.Object lookup(String string) throws NamingException {
        String string2 = this.getComponentId();
        HashMap hashMap = (HashMap)this.namespaces.get(string2);
        java.lang.Object object = hashMap.get(string);
        if (object == null && this.isSerialCtx) {
            object = this.cosContextLookup(string);
        } else if (object instanceof J2EEEnvWrapper) {
            J2EEEnvWrapper j2EEEnvWrapper = (J2EEEnvWrapper)object;
            switch (j2EEEnvWrapper.type) {
                case 1: {
                    object = this.copyMutableObject(j2EEEnvWrapper.object);
                    break;
                }
                case 8: {
                    object = j2EEEnvWrapper.object;
                    break;
                }
                case 2: {
                    String string3 = (String)j2EEEnvWrapper.object;
                    MailConfiguration mailConfiguration = (MailConfiguration)this.initialContextLookup(string3);
                    object = Session.getInstance((Properties)mailConfiguration.getMailProperties(), null);
                    break;
                }
                case 3: {
                    object = this.cosContextLookup((String)j2EEEnvWrapper.object);
                    hashMap.put(string, object);
                    break;
                }
                case 4: {
                    object = this.theSwitch.getLocalHome((String)j2EEEnvWrapper.object);
                    if (object == null) {
                        throw new NamingException("EJBLocalHome lookup failed");
                    }
                    hashMap.put(string, object);
                    break;
                }
                case 5: {
                    object = this.initialContextLookup((String)j2EEEnvWrapper.object);
                    j2EEEnvWrapper = new J2EEEnvWrapper(object, 1);
                    hashMap.put(string, j2EEEnvWrapper);
                    break;
                }
                case 6: {
                    object = j2EEEnvWrapper.object;
                    break;
                }
                case 7: {
                    object = this.initialContextLookup((String)j2EEEnvWrapper.object);
                }
            }
        }
        if (object == null) {
            throw new NameNotFoundException("No object bound to name " + string);
        }
        return object;
    }

    private java.lang.Object copyMutableObject(java.lang.Object object) {
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.close();
                byteArrayOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream, classLoader);
                return objectInputStreamWithLoader.readObject();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise_naming.excep_in_copymutableobj", exception);
                throw new RuntimeException("Cant copy Serializable object:" + exception);
            }
        }
        return object;
    }

    public NamingEnumeration list(String string) throws NamingException {
        ArrayList arrayList = this.listNames(string);
        return new NamePairsEnum(this, arrayList.iterator());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        ArrayList arrayList = this.listNames(string);
        return new BindingsEnum(this, arrayList.iterator());
    }

    private java.lang.Object initialContextLookup(String string) throws NamingException {
        return this.initialContext.lookup(string);
    }

    private java.lang.Object cosContextLookup(String string) throws NamingException {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        String string2 = null;
        if (n > 0 && (n2 == -1 || n < n2)) {
            string2 = string.substring(0, n);
        }
        if (string2 != null) {
            Properties properties = new Properties();
            properties.put("java.naming.corba.orb", ORBManager.getORB());
            Context context = javax.naming.spi.NamingManager.getURLContext(string2, properties);
            if (context != null) {
                return context.lookup(string);
            }
        }
        if (this.isSerialCtx) {
            return this.cosContext.lookup(SerialContext.makeJavaName().add(string));
        }
        return this.cosContext.lookup(string);
    }

    private ArrayList listNames(String string) throws NamingException {
        String string2 = this.getComponentId();
        HashMap hashMap = (HashMap)this.namespaces.get(string2);
        java.lang.Object v = hashMap.get(string);
        if (v == null) {
            throw new NameNotFoundException("No object bound to name " + string);
        }
        if (!(v instanceof javaURLContext)) {
            throw new NotContextException(string + " cannot be listed");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = hashMap.keySet().iterator();
        if (!string.endsWith(CONTEXT_SEPARATOR)) {
            string = string + CONTEXT_SEPARATOR;
        }
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string) || string3.indexOf(47, string.length()) != -1) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String getComponentId() throws NamingException {
        String string = null;
        ComponentInvocation componentInvocation = this.im.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new NamingException("invocation exception ");
        }
        try {
            java.lang.Object object = componentInvocation.getContainerContext();
            if (object == null) {
                throw new NamingException("No container context");
            }
            if (object instanceof Container) {
                return ((Container)object).getComponentId();
            }
            JndiNameEnvironment jndiNameEnvironment = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(object);
            string = this.getMangledIdName(jndiNameEnvironment);
        }
        catch (InvocationException invocationException) {
            throw new NamingException("invocation exception " + invocationException);
        }
        return string;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private int getComponentType(JndiNameEnvironment jndiNameEnvironment) {
        int n = 0;
        if (jndiNameEnvironment instanceof EjbDescriptor) {
            n = 1;
        } else if (jndiNameEnvironment instanceof WebBundleDescriptor) {
            n = 2;
        } else if (jndiNameEnvironment instanceof ApplicationClientDescriptor) {
            n = 3;
        } else {
            throw new IllegalArgumentException("Unknown component type");
        }
        return n;
    }

    private String getMangledIdName(JndiNameEnvironment jndiNameEnvironment) {
        String string = null;
        int n = this.getComponentType(jndiNameEnvironment);
        switch (n) {
            case 1: {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)jndiNameEnvironment;
                String string2 = ejbDescriptor.getJndiName().replace('/', '.');
                EjbBundleDescriptor ejbBundleDescriptor = ejbDescriptor.getEjbBundleDescriptor();
                Archivist archivist = ejbBundleDescriptor.getArchivist();
                string = ejbDescriptor.getApplication().getName() + ID_SEPARATOR + archivist.getArchiveUri() + ID_SEPARATOR + ejbDescriptor.getName() + ID_SEPARATOR + string2;
                break;
            }
            case 2: {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)jndiNameEnvironment;
                string = webBundleDescriptor.getApplication().getName() + ID_SEPARATOR + webBundleDescriptor.getContextRoot();
                break;
            }
            case 3: {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)jndiNameEnvironment;
                string = "client_" + applicationClientDescriptor.getName() + ID_SEPARATOR + applicationClientDescriptor.getMainClassName();
            }
        }
        return string;
    }

    private boolean isCOSNamingObj(java.lang.Object object) {
        return object instanceof Remote || object instanceof Object;
    }

    private String getApplicationName(JndiNameEnvironment jndiNameEnvironment) {
        String string = "";
        int n = this.getComponentType(jndiNameEnvironment);
        String string2 = "";
        switch (n) {
            case 1: {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)jndiNameEnvironment;
                EjbBundleDescriptor ejbBundleDescriptor = ejbDescriptor.getEjbBundleDescriptor();
                string = "ejb [" + ejbDescriptor.getApplication().getRegistrationName();
                string2 = ejbDescriptor.getName();
                if (string2 == null || string2.equals("")) {
                    string = string + "]";
                    break;
                }
                string = string + ":" + ejbDescriptor.getName() + "]";
                break;
            }
            case 2: {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)jndiNameEnvironment;
                string = "web module [" + webBundleDescriptor.getApplication().getRegistrationName();
                string2 = webBundleDescriptor.getContextRoot();
                if (string2 == null || string2.equals("")) {
                    string = string + "]";
                    break;
                }
                string = string + ":" + webBundleDescriptor.getContextRoot() + "]";
                break;
            }
            case 3: {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)jndiNameEnvironment;
                string = "client [" + applicationClientDescriptor.getName() + ":" + applicationClientDescriptor.getMainClassName() + "]";
            }
        }
        return string;
    }

    private boolean isConnector(String string) {
        return string.indexOf(EIS_STRING) != -1;
    }
}

