/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.ConnectionWrapper;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.jms.SimpleAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicSession;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class ConnectionWrapperBase
implements ConnectionWrapper {
    private static final boolean debug = false;
    private boolean closed_ = false;
    private JMSXAConnection delegateXA_;
    private JmsWrapperFactory wrapperFactory_;
    private SimpleAllocator allocator_;
    private Vector sessionWrappers_;
    private boolean pointToPoint_;
    static Logger _logger = null;

    public ConnectionWrapperBase(JMSXAConnection jMSXAConnection, JmsWrapperFactory jmsWrapperFactory) {
        this.pointToPoint_ = jMSXAConnection instanceof JMSXAQueueConnection;
        this.delegateXA_ = jMSXAConnection;
        this.wrapperFactory_ = jmsWrapperFactory;
        this.sessionWrappers_ = new Vector();
        this.allocator_ = new SimpleAllocator(this.pointToPoint_);
    }

    public String getClientID() throws JMSException {
        return this.getDelegate().getClientID();
    }

    public void setClientID(String string) throws JMSException {
        this.getDelegate().setClientID(string);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getDelegate().getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getDelegate().getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getDelegate().setExceptionListener(exceptionListener);
    }

    public void start() throws JMSException {
        this.getDelegate().start();
    }

    public void stop() throws JMSException {
        this.getDelegate().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Object object = this;
        synchronized (object) {
            if (this.closed_) {
                return;
            }
            this.closed_ = true;
        }
        object = (Vector)this.sessionWrappers_.clone();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            SessionWrapper sessionWrapper = (SessionWrapper)enumeration.nextElement();
            try {
                sessionWrapper.close();
            }
            catch (JMSException jMSException) {
                _logger.log(Level.SEVERE, "jms.session_not_closed", jMSException);
            }
        }
        this.getDelegateXA().close();
    }

    public void sessionClosed(SessionWrapper sessionWrapper) {
        this.sessionWrappers_.remove(sessionWrapper);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.getQueueDelegate().createConnectionConsumer(queue, string, serverSessionPool, n);
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        JMSXAQueueSession jMSXAQueueSession = this.getQueueDelegateXA().createXAQueueSession(bl, n);
        SessionWrapper sessionWrapper = (SessionWrapper)this.wrapperFactory_.createQueueSessionWrapper(jMSXAQueueSession, this);
        this.sessionWrappers_.add(sessionWrapper);
        return sessionWrapper;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.getTopicDelegate().createConnectionConsumer(topic, string, serverSessionPool, n);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.getTopicDelegate().createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        JMSXATopicSession jMSXATopicSession = this.getTopicDelegateXA().createXATopicSession(bl, n);
        SessionWrapper sessionWrapper = (SessionWrapper)this.wrapperFactory_.createTopicSessionWrapper(jMSXATopicSession, this);
        this.sessionWrappers_.add(sessionWrapper);
        return sessionWrapper;
    }

    protected ResourceHandle createResourceHandle(SessionWrapper sessionWrapper) throws JMSException {
        ResourceHandle resourceHandle;
        try {
            resourceHandle = this.allocator_.createResource(sessionWrapper);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jms.resource_handle_create_failed", exception);
            JMSException jMSException = new JMSException(exception.getMessage());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
        return resourceHandle;
    }

    protected void registerResourceHandle(SessionWrapper sessionWrapper, ResourceHandle resourceHandle) throws JMSException {
        try {
            Switch switch_ = Switch.getSwitch();
            PoolManager poolManager = switch_.getPoolManager();
            poolManager.registerResource(resourceHandle);
            sessionWrapper.setResourceHandle(resourceHandle);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jms.resource_handle_register_failed", exception);
            JMSException jMSException = new JMSException(exception.getMessage());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    protected void setupResourceHandle(SessionWrapper sessionWrapper) throws JMSException {
        ResourceHandle resourceHandle = this.createResourceHandle(sessionWrapper);
        this.registerResourceHandle(sessionWrapper, resourceHandle);
    }

    public Connection getDelegate() {
        JMSXAConnection jMSXAConnection = this.getDelegateXA();
        return this.pointToPoint_ ? this.getQueueDelegate() : this.getTopicDelegate();
    }

    public QueueConnection getQueueDelegate() {
        return this.getQueueDelegateXA().getQueueConnection();
    }

    public TopicConnection getTopicDelegate() {
        return this.getTopicDelegateXA().getTopicConnection();
    }

    public JMSXAQueueConnection getQueueDelegateXA() {
        return (JMSXAQueueConnection)this.getDelegateXA();
    }

    public JMSXATopicConnection getTopicDelegateXA() {
        return (JMSXATopicConnection)this.getDelegateXA();
    }

    public JMSXAConnection getDelegateXA() {
        return this.delegateXA_;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    }
}

