/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicConnectionFactory;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ConnectionFactoryWrapper
implements QueueConnectionFactory,
TopicConnectionFactory,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectionFactoryWrapper.class);
    private static final boolean debug = false;
    private JmsWrapperFactory wrapperFactory_;
    private String connectionFactoryJndiName_;
    private boolean resourceRefHasApplicationAuth_;
    private boolean resourceRefHasContainerAuth_;
    private boolean useContainerAuth_;
    static Logger _logger = null;
    private String userName_;
    private String password_;
    private transient JMSXAConnectionFactory delegateXA_;
    private Context context = null;

    public void setProvider(Context context) {
        this.context = context;
    }

    public ConnectionFactoryWrapper(String string, ResourceReferenceDescriptor resourceReferenceDescriptor, JmsWrapperFactory jmsWrapperFactory) {
        this.connectionFactoryJndiName_ = string;
        this.wrapperFactory_ = jmsWrapperFactory;
        this.resourceRefHasContainerAuth_ = false;
        this.resourceRefHasApplicationAuth_ = false;
        this.useContainerAuth_ = false;
        this.userName_ = null;
        this.password_ = null;
        if (resourceReferenceDescriptor != null) {
            if (resourceReferenceDescriptor.isContainerAuthorization()) {
                this.resourceRefHasContainerAuth_ = true;
                ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
                if (resourcePrincipal != null) {
                    this.userName_ = resourcePrincipal.getName();
                    this.password_ = resourcePrincipal.getPassword();
                    if (this.userName_ != null && !this.userName_.equals("") && this.password_ != null) {
                        this.useContainerAuth_ = true;
                    } else {
                        _logger.log(Level.WARNING, "jms.no_resource_principal", this.connectionFactoryJndiName_);
                    }
                } else {
                    _logger.log(Level.WARNING, "jms.no_resource_principal", this.connectionFactoryJndiName_);
                }
            } else {
                this.resourceRefHasApplicationAuth_ = true;
            }
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        JMSXAQueueConnection jMSXAQueueConnection = null;
        if (this.useContainerAuth_) {
            jMSXAQueueConnection = this.getQueueDelegateXA().createXAQueueConnection(this.userName_, this.password_);
        } else {
            if (this.resourceRefHasApplicationAuth_) {
                _logger.log(Level.WARNING, "jms.not_container_auth_queue");
            }
            jMSXAQueueConnection = this.getQueueDelegateXA().createXAQueueConnection();
        }
        return this.wrapperFactory_.createQueueConnectionWrapper(jMSXAQueueConnection);
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        if (this.resourceRefHasContainerAuth_) {
            String string3 = localStrings.getLocalString("jms.connection.container.auth.error", "JMS Connection with container authentication cannot programmatically set username and password");
            _logger.log(Level.WARNING, "jms.connection_container_auth_error");
            throw new JMSException(string3);
        }
        JMSXAQueueConnection jMSXAQueueConnection = this.getQueueDelegateXA().createXAQueueConnection(string, string2);
        return this.wrapperFactory_.createQueueConnectionWrapper(jMSXAQueueConnection);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        JMSXATopicConnection jMSXATopicConnection = null;
        if (this.useContainerAuth_) {
            jMSXATopicConnection = this.getTopicDelegateXA().createXATopicConnection(this.userName_, this.password_);
        } else {
            if (this.resourceRefHasApplicationAuth_) {
                _logger.log(Level.WARNING, "jms.not_container_auth_topic");
            }
            jMSXATopicConnection = this.getTopicDelegateXA().createXATopicConnection();
        }
        return this.wrapperFactory_.createTopicConnectionWrapper(jMSXATopicConnection);
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        if (this.resourceRefHasContainerAuth_) {
            String string3 = localStrings.getLocalString("jms.connection.container.auth.error", "JMS Connection with container authentication cannot programmatically set username and password");
            _logger.log(Level.WARNING, "jms.connection_container_auth_error");
            throw new JMSException(string3);
        }
        JMSXATopicConnection jMSXATopicConnection = this.getTopicDelegateXA().createXATopicConnection(string, string2);
        return this.wrapperFactory_.createTopicConnectionWrapper(jMSXATopicConnection);
    }

    private JMSXAQueueConnectionFactory getQueueDelegateXA() throws JMSException {
        return (JMSXAQueueConnectionFactory)this.getDelegateXA();
    }

    private JMSXATopicConnectionFactory getTopicDelegateXA() throws JMSException {
        return (JMSXATopicConnectionFactory)this.getDelegateXA();
    }

    private JMSXAConnectionFactory getDelegateXA() throws JMSException {
        JMSXAConnectionFactory jMSXAConnectionFactory;
        if (this.delegateXA_ == null) {
            try {
                if (this.context == null) {
                    this.context = new InitialContext();
                }
                this.delegateXA_ = (JMSXAConnectionFactory)this.context.lookup(this.connectionFactoryJndiName_);
            }
            catch (NamingException namingException) {
                _logger.log(Level.SEVERE, "jms.connectionfactory_not_found_msg", this.connectionFactoryJndiName_);
                _logger.log(Level.SEVERE, "jms.connectionfactory_not_found_excp", namingException);
                JMSException jMSException = new JMSException(namingException.getMessage());
                jMSException.setLinkedException((Exception)namingException);
                throw jMSException;
            }
        }
        if ((jMSXAConnectionFactory = this.delegateXA_) == null) {
            String string = localStrings.getLocalString("jms.xadelegate_lookup_null", "JNDI lookup JMS XAConnectionFactory " + this.connectionFactoryJndiName_ + " return null", new Object[]{this.connectionFactoryJndiName_});
            throw new JMSException(string);
        }
        return jMSXAConnectionFactory;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    }
}

