/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.CompleteEstablishContext;
import com.sun.corba.ee.org.omg.CSI.ContextError;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.Counter;
import com.sun.enterprise.iiop.security.Csiv2Manager;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.Logger;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityService;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class SecServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static java.util.logging.Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private InheritableThreadLocal counterForCalls = new InheritableThreadLocal();
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final int INVALID_MECHANISM_MAJOR = 2;
    private static final int INVALID_MECHANISM_MINOR = 1;
    private static final boolean NO_REPLACE = false;
    private String prname;
    private String name;
    private Codec codec;
    private ORB orb;
    SecurityService secsvc = null;

    public SecServerRequestInterceptor(String string, Codec codec) {
        this.name = string;
        this.codec = codec;
        this.prname = string + "::";
    }

    public String name() {
        return this.name;
    }

    private SASContextBody createContextError(int n) {
        _logger.log(Level.FINE, "Creating ContextError message: minor code= " + n);
        byte[] byArray = new byte[]{};
        ContextError contextError = new ContextError(0L, 1, n, byArray);
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.error_msg(contextError);
        return sASContextBody;
    }

    private SASContextBody createContextError(int n, int n2) {
        _logger.log(Level.FINE, "Creating ContextError message: major code = " + n + "minor code= " + n2);
        byte[] byArray = new byte[]{};
        ContextError contextError = new ContextError(0L, n, n2, byArray);
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.error_msg(contextError);
        return sASContextBody;
    }

    private SASContextBody createCompleteEstablishContext(int n) {
        _logger.log(Level.FINE, "Creating CompleteEstablishContext message");
        byte[] byArray = new byte[]{};
        CompleteEstablishContext completeEstablishContext = new CompleteEstablishContext(0L, false, byArray);
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.complete_msg(completeEstablishContext);
        return sASContextBody;
    }

    private ServiceContext createSvcContext(SASContextBody sASContextBody) {
        ServiceContext serviceContext = null;
        Any any = this.orb.create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        byte[] byArray = new byte[]{};
        try {
            byArray = this.codec.encode_value(any);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.encode_exception", exception);
        }
        serviceContext = new ServiceContext();
        serviceContext.context_id = 15;
        serviceContext.context_data = byArray;
        return serviceContext;
    }

    private void createIdCred(SecurityContext securityContext, IdentityToken identityToken) throws Exception {
        switch (identityToken.discriminator()) {
            case 0: {
                _logger.log(Level.FINE, "Identity token type is Absent");
                securityContext.identcls = null;
                break;
            }
            case 1: {
                _logger.log(Level.FINE, "Identity token type is Anonymous");
                _logger.log(Level.FINE, "Adding AnonyCredential to subject's PublicCredentials");
                securityContext.subject.getPublicCredentials().add(new AnonCredential());
                securityContext.identcls = AnonCredential.class;
                break;
            }
            case 8: {
                Any any = this.codec.decode_value(identityToken.dn(), X501DistinguishedNameHelper.type());
                byte[] byArray = X501DistinguishedNameHelper.extract(any);
                _logger.log(Level.FINE, "Create an X500Name object from identity token");
                X500Name x500Name = new X500Name(byArray);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Identity to be asserted is " + x500Name.toString());
                    _logger.log(Level.FINE, "Adding X500Name to subject's PublicCredentials");
                }
                securityContext.subject.getPublicCredentials().add(x500Name);
                securityContext.identcls = X500Name.class;
                break;
            }
            case 4: {
                _logger.log(Level.FINE, "Identity token type is a X509 Certificate Chain");
                Any any = this.codec.decode_value(identityToken.certificate_chain(), X509CertificateChainHelper.type());
                byte[] byArray = X509CertificateChainHelper.extract(any);
                DerInputStream derInputStream = new DerInputStream(byArray);
                DerValue[] derValueArray = derInputStream.getSequence(1);
                X509Certificate[] x509CertificateArray = new X509CertImpl[derValueArray.length];
                _logger.log(Level.FINE, "Contents of X509 Certificate chain:");
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    x509CertificateArray[i] = new X509CertImpl(derValueArray[i]);
                    _logger.log(Level.FINE, "    " + x509CertificateArray[i].getSubjectDN().getName());
                }
                _logger.log(Level.FINE, "Creating a X509CertificateCredential object from certchain");
                X509CertificateCredential x509CertificateCredential = new X509CertificateCredential(x509CertificateArray, ((X509Certificate)x509CertificateArray[0]).getSubjectDN().getName(), "default");
                _logger.log(Level.FINE, "Adding X509CertificateCredential to subject's PublicCredentials");
                securityContext.subject.getPublicCredentials().add(x509CertificateArray);
                securityContext.identcls = X509CertificateCredential.class;
                break;
            }
            case 2: {
                _logger.log(Level.FINE, "Identity token type is GSS Exported Name");
                Any any = this.codec.decode_value(identityToken.principal_name(), GSS_NT_ExportedNameHelper.type());
                byte[] byArray = GSS_NT_ExportedNameHelper.extract(any);
                if (!GSSUtils.verifyMechOID(GSSUtils.GSSUP_MECH_OID, byArray)) {
                    throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
                }
                GSSUPName gSSUPName = new GSSUPName(byArray);
                securityContext.subject.getPublicCredentials().add(gSSUPName);
                securityContext.identcls = GSSUPName.class;
                _logger.log(Level.FINE, "Adding GSSUPName credential to subject");
                break;
            }
            default: {
                _logger.log(Level.SEVERE, "iiop.unknown_identity");
                throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
            }
        }
    }

    private void createAuthCred(SecurityContext securityContext, byte[] byArray) throws Exception {
        _logger.log(Level.FINE, "Constructing a PasswordCredential from client authentication token");
        GSSUPToken gSSUPToken = new GSSUPToken(this.orb, this.codec, byArray);
        final PasswordCredential passwordCredential = gSSUPToken.getPwdcred();
        final SecurityContext securityContext2 = securityContext;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Password credential = " + passwordCredential.toString());
            _logger.log(Level.FINE, "Adding PasswordCredential to subject's PrivateCredentials");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                securityContext2.subject.getPrivateCredentials().add(passwordCredential);
                return null;
            }
        });
        securityContext = securityContext2;
        securityContext.authcls = PasswordCredential.class;
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        SecurityContext securityContext = null;
        ServiceContext serviceContext = null;
        int n = 0;
        boolean bl = false;
        Logger.methodentry(this.prname + "receive_request_service_contexts");
        this.secsvc = Csiv2Manager.getSecurityService();
        this.orb = ORBManager.getORB();
        try {
            serviceContext = serverRequestInfo.get_request_service_context(15);
        }
        catch (BAD_PARAM bAD_PARAM) {
            _logger.log(Level.FINE, "No SAS context element found in service context list");
            int n2 = this.secsvc.setSecurityContext(null, serverRequestInfo.object_id(), serverRequestInfo.operation());
            if (n2 == 1) {
                SASContextBody sASContextBody = this.createContextError(2, 1);
                serviceContext = this.createSvcContext(sASContextBody);
                serverRequestInfo.add_reply_service_context(serviceContext, false);
                throw new NO_PERMISSION();
            }
            return;
        }
        _logger.log(Level.FINE, "Received a non null SAS context element");
        Any any = this.orb.create_any();
        try {
            any = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.decode_exception", exception);
            _logger.log(Level.SEVERE, "iiop.decode_exception");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        _logger.log(Level.FINE, "Successfully decoded CDR encoded SAS context element.");
        SASContextBody sASContextBody = SASContextBodyHelper.extract(any);
        short s = sASContextBody.discriminator();
        _logger.log(Level.FINE, "SAS context element is a/an " + SvcContextUtils.getMsgname(s) + " message");
        if (s == 5) {
            sASContextBody = this.createContextError(4);
            serviceContext = this.createSvcContext(sASContextBody);
            _logger.log(Level.FINE, "Adding ContextError message to service context list");
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            _logger.log(Level.FINE, "SecurityContext set to null");
            throw new NO_PERMISSION();
        }
        if (s != 0) {
            _logger.log(Level.SEVERE, "iiop.not_establishcontext_msg");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_not_ec_msg", "Received message not an EstablishContext message."));
        }
        EstablishContext establishContext = sASContextBody.establish_msg();
        securityContext = new SecurityContext();
        securityContext.subject = new Subject();
        try {
            if (establishContext.client_authentication_token.length != 0) {
                _logger.log(Level.FINE, "Message contains Client Authentication Token");
                this.createAuthCred(securityContext, establishContext.client_authentication_token);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.authentication_exception", exception);
            _logger.log(Level.SEVERE, "iiop.authentication_exception");
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        try {
            if (establishContext.identity_token != null) {
                _logger.log(Level.FINE, "Message contains an Identity Token");
                this.createIdCred(securityContext, establishContext.identity_token);
            }
        }
        catch (SecurityException securityException) {
            _logger.log(Level.SEVERE, "iiop.security_exception", securityException);
            _logger.log(Level.SEVERE, "iiop.security_exception");
            sASContextBody = this.createContextError(2, 1);
            serviceContext = this.createSvcContext(sASContextBody);
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            throw new NO_PERMISSION();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.generic_exception", exception);
            _logger.log(Level.SEVERE, "iiop.generic_exception");
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        _logger.log(Level.FINE, "Invoking setSecurityContext() to set security context");
        n = this.secsvc.setSecurityContext(securityContext, serverRequestInfo.object_id(), serverRequestInfo.operation());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "setSecurityContext() returned status code " + n);
        }
        if (n == 1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "setSecurityContext() returned STATUS_FAILED");
            }
            sASContextBody = this.createContextError(n);
            serviceContext = this.createSvcContext(sASContextBody);
            _logger.log(Level.FINE, "Adding ContextError message to service context list");
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            throw new NO_PERMISSION();
        }
        _logger.log(Level.FINE, "setSecurityContext() returned SUCCESS");
        sASContextBody = this.createCompleteEstablishContext(n);
        serviceContext = this.createSvcContext(sASContextBody);
        _logger.log(Level.FINE, "Adding CompleteEstablisContext message to service context list");
        serverRequestInfo.add_reply_service_context(serviceContext, false);
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        Counter counter = (Counter)this.counterForCalls.get();
        if (counter == null) {
            counter = new Counter();
            this.counterForCalls.set(counter);
        }
        if (counter.count == 0) {
            SecurityService securityService = Csiv2Manager.getSecurityService();
            securityService.unsetSecurityContext();
        }
        counter.increment();
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.unsetSecurityContext();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void destroy() {
    }

    private void unsetSecurityContext() {
        Counter counter = (Counter)this.counterForCalls.get();
        if (counter == null) {
            counter = new Counter(1);
        }
        counter.decrement();
        if (counter.count == 0) {
            SecurityService securityService = Csiv2Manager.getSecurityService();
            securityService.unsetSecurityContext();
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);
    }
}

