/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.AuthorizationElement;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.Csiv2Manager;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityService;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class SecClientRequestInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private String name;
    private String prname;
    private Codec codec;
    private ORB orb;
    private SecurityService secsvc;
    private static final boolean debug = false;
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;

    public SecClientRequestInterceptor(String string, Codec codec) {
        this.name = string;
        this.codec = codec;
        this.prname = string + "::";
    }

    public String name() {
        return this.name;
    }

    private java.lang.Object getCred(Set set, Class clazz) {
        java.lang.Object var3_3 = null;
        String string = clazz.getName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Checking for a single instance of class in subject");
            _logger.log(Level.FINE, "    Classname = " + string);
        }
        if (set.size() != 1) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.multiple_credset", new java.lang.Object[]{new Integer(set.size()), string});
            }
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.inv_credlist_size", "Credential list size is not 1."));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            var3_3 = iterator.next();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Verified single instance of class ( " + string + " )");
        }
        return var3_3;
    }

    private byte[] createAuthToken(java.lang.Object object, Class clazz) throws Exception {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        if (PasswordCredential.class.isAssignableFrom(clazz)) {
            _logger.log(Level.FINE, "Constructing a PasswordCredential client auth token");
            PasswordCredential passwordCredential = (PasswordCredential)object;
            GSSUPToken gSSUPToken = new GSSUPToken(this.orb, this.codec, passwordCredential);
            byArray = gSSUPToken.getGSSToken();
        }
        return byArray;
    }

    private IdentityToken createIdToken(java.lang.Object object, Class clazz) throws Exception {
        IdentityToken identityToken = null;
        DerOutputStream derOutputStream = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[]{};
        Any any = this.orb.create_any();
        identityToken = new IdentityToken();
        if (X500Name.class.isAssignableFrom(clazz)) {
            _logger.log(Level.FINE, "Constructing an X500 DN Identity Token");
            X500Name x500Name = (X500Name)object;
            x500Name.encode(derOutputStream);
            X501DistinguishedNameHelper.insert(any, derOutputStream.toByteArray());
            identityToken.dn(this.codec.encode_value(any));
        } else if (X509CertificateCredential.class.isAssignableFrom(clazz)) {
            _logger.log(Level.FINE, "Constructing an X509 Certificate Chain Identity Token");
            X509CertificateCredential x509CertificateCredential = (X509CertificateCredential)object;
            X509Certificate[] x509CertificateArray = x509CertificateCredential.getX509CertificateChain();
            _logger.log(Level.FINE, "Certchain length = " + x509CertificateArray.length);
            derValueArray = new DerValue[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                derValueArray[i] = new DerValue(x509CertificateArray[i].getEncoded());
            }
            derOutputStream.putSequence(derValueArray);
            X509CertificateChainHelper.insert(any, derOutputStream.toByteArray());
            identityToken.certificate_chain(this.codec.encode_value(any));
        } else if (AnonCredential.class.isAssignableFrom(clazz)) {
            _logger.log(Level.FINE, "Constructing an Anonymous Identity Token");
            identityToken.anonymous(true);
        } else if (GSSUPName.class.isAssignableFrom(clazz)) {
            _logger.log(Level.FINE, "Constructing a GSS Exported name Identity Token");
            GSSUPName gSSUPName = (GSSUPName)object;
            byte[] byArray = gSSUPName.getExportedName();
            GSS_NT_ExportedNameHelper.insert(any, byArray);
            identityToken.principal_name(this.codec.encode_value(any));
        }
        return identityToken;
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        long l = 0L;
        AuthorizationElement[] authorizationElementArray = new AuthorizationElement[]{};
        IdentityToken identityToken = null;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        java.lang.Object object = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "send_request" + "()");
        }
        SecurityContext securityContext = null;
        this.secsvc = Csiv2Manager.getSecurityService();
        this.orb = ORBManager.getORB();
        if (this.secsvc == null) {
            _logger.log(Level.WARNING, "iiop.no_security_service");
            return;
        }
        Object object2 = clientRequestInfo.effective_target();
        try {
            securityContext = this.secsvc.getSecurityContext(object2);
        }
        catch (InvalidMechanismException invalidMechanismException) {
            _logger.log(Level.SEVERE, "iiop.sec_context_exception");
            throw new RuntimeException(invalidMechanismException.getMessage());
        }
        catch (InvalidIdentityTokenException invalidIdentityTokenException) {
            _logger.log(Level.SEVERE, "iiop.runtime_exception");
            throw new RuntimeException(invalidIdentityTokenException.getMessage());
        }
        if (securityContext == null) {
            _logger.log(Level.FINE, "Security context is null (nothing to add to service context)");
            return;
        }
        final SecurityContext securityContext2 = securityContext;
        if (securityContext.authcls != null) {
            object = AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    return SecClientRequestInterceptor.this.getCred(securityContext2.subject.getPrivateCredentials(securityContext2.authcls), securityContext2.authcls);
                }
            });
            try {
                byArray = this.createAuthToken(object, securityContext.authcls);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "iiop.createauthtoken_exception", exception);
                _logger.log(Level.SEVERE, "iiop.createauthtoken_exception");
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_authtok_create", "Error while constructing an authentication token."));
            }
        }
        if (securityContext.identcls != null) {
            object = this.getCred(securityContext.subject.getPublicCredentials(securityContext.identcls), securityContext.identcls);
            try {
                identityToken = this.createIdToken(object, securityContext.identcls);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "iiop.createidtoken_exception", exception);
                _logger.log(Level.SEVERE, "iiop.createidtoken_exception");
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_idtok_create", "Error while constructing an identity token."));
            }
        } else {
            _logger.log(Level.FINE, "Constructing an Absent Identity Token");
            identityToken = new IdentityToken();
            identityToken.absent(true);
        }
        _logger.log(Level.FINE, "Creating an EstablishContext message");
        EstablishContext establishContext = new EstablishContext(l, authorizationElementArray, identityToken, byArray);
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.establish_msg(establishContext);
        Any any = this.orb.create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        try {
            byArray2 = this.codec.encode_value(any);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.encode_exception", exception);
            _logger.log(Level.SEVERE, "iiop.encode_exception");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_encode", "CDR Encoding error for a SAS context element."));
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.context_id = 15;
        serviceContext.context_data = byArray2;
        _logger.log(Level.FINE, "Adding EstablishContext message to service context list");
        boolean bl = false;
        clientRequestInfo.add_request_service_context(serviceContext, bl);
        _logger.log(Level.FINE, "Added EstablishContext message to service context list");
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    private void setreplyStatus(int n, Object object) {
        _logger.log(Level.FINE, "Status to be set : " + n);
        this.secsvc = Csiv2Manager.getSecurityService();
        if (this.secsvc == null) {
            _logger.log(Level.WARNING, "iiop.no_security_service");
            return;
        }
        this.secsvc.receivedReply(n, object);
        _logger.log(Level.FINE, "Invoked receivedReply()");
    }

    private int mapreplyStatus(int n) {
        int n2;
        _logger.log(Level.FINE, "Reply status to be mapped =  " + n);
        switch (n) {
            case 0: 
            case 2: {
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            default: {
                n2 = n;
            }
        }
        _logger.log(Level.FINE, "Mapped reply status = " + n2);
        return n2;
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        ServiceContext serviceContext = null;
        int n = -1;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "receive_reply");
        }
        this.orb = ORBManager.getORB();
        try {
            serviceContext = clientRequestInfo.get_reply_service_context(15);
        }
        catch (BAD_PARAM bAD_PARAM) {
            _logger.log(Level.FINE, "No SAS context element found in service context list");
            this.setreplyStatus(0, clientRequestInfo.effective_target());
            return;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.service_context_exception", exception);
            return;
        }
        Any any = this.orb.create_any();
        try {
            any = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.decode_exception", exception);
            _logger.log(Level.SEVERE, "iiop.decode_exception");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        SASContextBody sASContextBody = SASContextBodyHelper.extract(any);
        short s = sASContextBody.discriminator();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Received " + SvcContextUtils.getMsgname(s) + " message");
        }
        _logger.log(Level.FINE, "Verifying the SAS protocol reply message");
        if (s != 1 && s != 4) {
            _logger.log(Level.SEVERE, "iiop.invalid_reply_message");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_not_cecec_msg", "Reply message not one of CompleteEstablishContext or ContextError."));
        }
        int n2 = this.mapreplyStatus(clientRequestInfo.reply_status());
        this.setreplyStatus(n2, clientRequestInfo.effective_target());
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "receive_exception");
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void destroy() {
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        localStrings = new LocalStringManagerImpl(SecClientRequestInterceptor.class);
    }
}

