/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.connection.Connection;
import com.sun.corba.ee.interceptor.RequestInfoExt;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.logging.LogDomains;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerConnectionInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Comparable {
    private static Logger _logger = null;
    public static final String baseMsg = "ServerConnectionInterceptor";
    public int order;
    private static boolean debug;

    public ServerConnectionInterceptor(int n) {
        this.order = n;
    }

    public String name() {
        return baseMsg;
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) {
        Connection connection = ((RequestInfoExt)((Object)serverRequestInfo)).connection();
        SecurityMechanismSelector securityMechanismSelector = new SecurityMechanismSelector();
        ServerConnectionContext serverConnectionContext = null;
        if (connection != null) {
            Socket socket = connection.getSocket();
            if (debug && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "RECEIVED request on connection: " + connection);
                _logger.log(Level.FINE, "Socket =" + socket);
            }
            serverConnectionContext = new ServerConnectionContext(socket);
        } else {
            serverConnectionContext = new ServerConnectionContext();
        }
        SecurityMechanismSelector.setServerConnectionContext(serverConnectionContext);
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof ServerConnectionInterceptor) {
            n = ((ServerConnectionInterceptor)object).order;
        }
        if (this.order < n) {
            return -1;
        }
        if (this.order == n) {
            return 0;
        }
        return 1;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) {
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.checkTransaction(serverRequestInfo);
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) {
        this.checkTransaction(serverRequestInfo);
    }

    public void send_other(ServerRequestInfo serverRequestInfo) {
        this.checkTransaction(serverRequestInfo);
    }

    private void checkTransaction(ServerRequestInfo serverRequestInfo) {
        J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
        if (j2EETransactionManager != null) {
            j2EETransactionManager.checkTransactionImport();
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        debug = false;
    }
}

