/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.TransactionService;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.transaction.JTSConfigChangeEventListener;
import com.iplanet.ias.transaction.TransactionAdminBean;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.Cache;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnection;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.SingleThreadModel;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class J2EETransactionManagerImpl
implements J2EETransactionManager {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    protected static final boolean debug = false;
    private static final String TX_TIMEOUT = "transaction.timeout";
    private static final String TX_OPT = "transaction.nonXA.optimization";
    protected TransactionManager tm = TransactionManagerImpl.getTransactionManagerImpl();
    protected InvocationManager invMgr;
    protected PoolManager poolmgr = new PoolManagerImpl();
    protected int transactionTimeout;
    protected Hashtable statusMap;
    protected Vector activeTransactions;
    protected boolean monitoringEnabled = false;
    protected static int[] JTAStatus = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    protected static String[] STATUS = new String[]{"Active", "MarkedRollback", "Prepared", "Committed", "RolledBack", "UnKnown", "NoTransaction", "Preparing", "Committing", "RollingBack"};
    protected int m_transCommitted = 0;
    protected int m_transRolledback = 0;
    protected int m_transInFlight = 0;
    private Cache resourceTable;

    public J2EETransactionManagerImpl() {
        Object object;
        String string;
        Switch.getSwitch().setPoolManager(this.poolmgr);
        ResourceInstaller resourceInstaller = new ResourceInstaller();
        Switch.getSwitch().setResourceInstaller(resourceInstaller);
        int n = 16000;
        float f = 0.75f;
        try {
            float f2;
            string = System.getProperty("JTA_RESOURCE_TABLE_MAX_ENTRIES");
            int n2 = Integer.parseInt(string);
            if (n2 > 0) {
                n = n2;
            }
            if ((f2 = Float.parseFloat((String)(object = System.getProperty("JTA_RESOURCE_TABLE_DEFAULT_LOAD_FACTOR")))) > 0.0f) {
                f = f2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = null;
        this.resourceTable = new BaseCache();
        ((BaseCache)this.resourceTable).init(n, f, (Properties)((Object)string));
        this.invMgr = Switch.getSwitch().getInvocationManager();
        ServerContext serverContext = ApplicationServer.getServerContext();
        if (serverContext != null) {
            object = serverContext.getConfigContext();
            TransactionService transactionService = null;
            try {
                transactionService = ServerBeansFactory.getServerBean((ConfigContext)object).getTransactionService();
                this.transactionTimeout = Integer.parseInt(transactionService.getTimeoutInSeconds());
                this.monitoringEnabled = transactionService.isMonitoringEnabled();
            }
            catch (ConfigException configException) {
                throw new RuntimeException("Error reading configuration : " + configException);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.activeTransactions = new Vector();
        this.statusMap = new Hashtable();
        for (int i = 0; i < JTAStatus.length; ++i) {
            this.statusMap.put(new Integer(JTAStatus[i]), STATUS[i]);
        }
        try {
            String string2 = System.getProperty("MONITOR_JTA_RESOURCE_TABLE_STATISTICS");
            if (Boolean.getBoolean(string2)) {
                this.registerStatisticMonitorTask();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static J2EETransactionManager createTransactionManager() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string = serverConfiguration.getProperty(TX_OPT);
        J2EETransactionManagerImpl j2EETransactionManagerImpl = string != null && string.equals("false") ? new J2EETransactionManagerImpl() : new J2EETransactionManagerOpt();
        return j2EETransactionManagerImpl;
    }

    private static void print(String string) {
        _logger.log(Level.FINE, string);
    }

    public boolean isNullTransaction() {
        try {
            return InterceptorImpl.isTxCtxtNull();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void recover(XAResource[] xAResourceArray) {
        int n = xAResourceArray.length;
        Vector<XAResource> vector = new Vector<XAResource>();
        for (int i = 0; i < n; ++i) {
            vector.addElement(xAResourceArray[i]);
        }
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        TransactionManagerImpl.recover(vector.elements());
    }

    public boolean enlistResource(Transaction transaction, ResourceHandle resourceHandle) throws RollbackException, IllegalStateException, SystemException {
        if (resourceHandle.isTransactional()) {
            XAResource xAResource = resourceHandle.getXAResource();
            boolean bl = transaction.enlistResource(xAResource);
            if (bl) {
                if (resourceHandle.getResource() instanceof ManagedConnection) {
                    Switch.getSwitch().getResourcePoolManager().resourceEnlisted(transaction, resourceHandle);
                } else {
                    this.poolmgr.resourceEnlisted(transaction, resourceHandle);
                }
            }
            return bl;
        }
        return true;
    }

    public void enlistComponentResources() throws RemoteException {
        ComponentInvocation componentInvocation = this.invMgr.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        try {
            Transaction transaction = this.getTransaction();
            componentInvocation.setTransaction(transaction);
            this.enlistComponentResources(componentInvocation);
        }
        catch (InvocationException invocationException) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", invocationException);
            throw new RemoteException("", invocationException.getNestedException());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", exception);
            throw new RemoteException("", exception);
        }
    }

    public void delistComponentResources(boolean bl) throws RemoteException {
        ComponentInvocation componentInvocation = this.invMgr.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        try {
            this.delistComponentResources(componentInvocation, bl);
        }
        catch (InvocationException invocationException) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", invocationException);
            throw new RemoteException("", invocationException.getNestedException());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", exception);
            throw new RemoteException("", exception);
        }
    }

    public void registerComponentResource(ResourceHandle resourceHandle) {
        Object object;
        ComponentInvocation componentInvocation = this.invMgr.getCurrentInvocation();
        if (componentInvocation != null) {
            object = componentInvocation.getInstance();
            if (object == null) {
                return;
            }
        } else {
            throw new InvocationException();
        }
        resourceHandle.setComponentInstance(object);
        List list = this.getResourceList(object);
        list.add(resourceHandle);
    }

    public void unregisterComponentResource(ResourceHandle resourceHandle) {
        Object object = resourceHandle.getComponentInstance();
        if (object == null) {
            return;
        }
        resourceHandle.setComponentInstance(null);
        List list = this.getExistingResourceList(object);
        if (list != null) {
            list.remove(resourceHandle);
        }
    }

    private void handleResourceError(ResourceHandle resourceHandle, Exception exception, Transaction transaction, ComponentInvocation componentInvocation) {
        try {
            if (transaction != null && resourceHandle.isTransactional()) {
                transaction.delistResource(resourceHandle.getXAResource(), 0x4000000);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (exception instanceof RollbackException) {
            return;
        }
        if (exception instanceof IllegalStateException) {
            try {
                resourceHandle.getResourceAllocator().closeUserConnection(resourceHandle);
            }
            catch (Exception exception3) {}
        } else {
            try {
                resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
    }

    private void enlistComponentResources(ComponentInvocation componentInvocation) throws InvocationException {
        try {
            Transaction transaction = componentInvocation.getTransaction();
            if (this.isTransactionActive(transaction)) {
                List list = this.getResourceList(componentInvocation.getInstance());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                    try {
                        this.enlistResource(transaction, resourceHandle);
                    }
                    catch (Exception exception) {
                        iterator.remove();
                        this.handleResourceError(resourceHandle, exception, transaction, componentInvocation);
                    }
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", exception);
        }
    }

    private void delistComponentResources(ComponentInvocation componentInvocation, boolean bl) throws InvocationException {
        try {
            Transaction transaction = componentInvocation.getTransaction();
            if (this.isTransactionActive(transaction)) {
                List list = this.getResourceList(componentInvocation.getInstance());
                Iterator iterator = list.iterator();
                int n = 0x4000000;
                if (bl) {
                    n = 0x2000000;
                }
                while (iterator.hasNext()) {
                    ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                    try {
                        this.delistResource(transaction, resourceHandle, n);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (Exception exception) {
                        iterator.remove();
                        this.handleResourceError(resourceHandle, exception, transaction, componentInvocation);
                    }
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", exception);
        }
    }

    private boolean isTransactionActive(Transaction transaction) {
        return transaction != null;
    }

    public void preInvoke(ComponentInvocation componentInvocation) throws InvocationException {
        if (componentInvocation != null && componentInvocation.getTransaction() != null) {
            this.delistComponentResources(componentInvocation, true);
        }
    }

    public void preInvoke() throws InvocationException {
        ComponentInvocation componentInvocation = this.invMgr.getPreviousInvocation();
        if (componentInvocation != null) {
            this.delistComponentResources(componentInvocation, true);
        }
    }

    public void postInvoke(ComponentInvocation componentInvocation, ComponentInvocation componentInvocation2) throws InvocationException {
        if (componentInvocation != null && componentInvocation.getTransaction() != null) {
            this.delistComponentResources(componentInvocation, false);
        }
        if (componentInvocation2 != null && componentInvocation2.getTransaction() != null) {
            this.enlistComponentResources(componentInvocation2);
        }
    }

    public void postInvoke() throws InvocationException {
        ComponentInvocation componentInvocation = this.invMgr.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        ComponentInvocation componentInvocation2 = this.invMgr.getPreviousInvocation();
        this.delistComponentResources(componentInvocation, false);
        if (componentInvocation2 != null) {
            this.enlistComponentResources(componentInvocation2);
        }
    }

    public void componentDestroyed(Object object) {
        List list = (List)this.resourceTable.get(this.getInstanceKey(object));
        if (list != null) {
            this.resourceTable.remove(this.getInstanceKey(object));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                try {
                    resourceHandle.getResourceAllocator().closeUserConnection(resourceHandle);
                }
                catch (PoolingException poolingException) {}
            }
        }
    }

    private Object getInstanceKey(Object vector) {
        Vector<Object> vector2 = null;
        if (vector instanceof Servlet || vector instanceof Filter) {
            if (vector instanceof SingleThreadModel) {
                vector2 = vector;
            } else {
                Vector<Object> vector3 = new Vector<Object>(2);
                vector3.addElement(vector);
                vector3.addElement(Thread.currentThread());
                vector2 = vector3;
            }
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public List getExistingResourceList(Object object) {
        Object object2 = this.getInstanceKey(object);
        return (List)this.resourceTable.get(object2);
    }

    public List getResourceList(Object object) {
        Object object2 = this.getInstanceKey(object);
        ArrayList arrayList = (ArrayList)this.resourceTable.get(object2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.resourceTable.put(object2, arrayList);
        }
        return arrayList;
    }

    public boolean delistResource(Transaction transaction, ResourceHandle resourceHandle, int n) throws IllegalStateException, SystemException {
        if (resourceHandle.isTransactional()) {
            return transaction.delistResource(resourceHandle.getXAResource(), n);
        }
        return true;
    }

    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, SystemException {
        try {
            Transaction transaction = this.getTransaction();
            if (transaction != null) {
                transaction.registerSynchronization(synchronization);
            }
        }
        catch (RollbackException rollbackException) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.rollbackexcep_in_regsynch", rollbackException);
            throw new IllegalStateException();
        }
    }

    public void begin(int n) throws NotSupportedException, SystemException {
        ((TransactionManagerImpl)this.tm).begin(n);
        if (this.monitoringEnabled) {
            Transaction transaction = this.tm.getTransaction();
            this.activeTransactions.addElement(transaction);
            ++this.m_transInFlight;
        }
    }

    public void checkTransactionExport(boolean bl) {
    }

    public void checkTransactionImport() {
    }

    public void begin() throws NotSupportedException, SystemException {
        ((TransactionManagerImpl)this.tm).begin(this.transactionTimeout);
        if (this.monitoringEnabled) {
            Transaction transaction = this.tm.getTransaction();
            this.activeTransactions.addElement(transaction);
            ++this.m_transInFlight;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction transaction = null;
        if (this.monitoringEnabled) {
            transaction = this.tm.getTransaction();
        }
        try {
            this.tm.commit();
            if (this.monitoringEnabled) {
                this.monitorTxCompleted(transaction, true);
            }
        }
        catch (RollbackException rollbackException) {
            if (this.monitoringEnabled) {
                this.monitorTxCompleted(transaction, false);
            }
            throw rollbackException;
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            if (this.monitoringEnabled) {
                this.monitorTxCompleted(transaction, false);
            }
            throw heuristicRollbackException;
        }
        catch (HeuristicMixedException heuristicMixedException) {
            if (this.monitoringEnabled) {
                this.monitorTxCompleted(transaction, true);
            }
            throw heuristicMixedException;
        }
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.tm.resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction transaction = null;
        if (this.monitoringEnabled) {
            transaction = this.tm.getTransaction();
        }
        this.tm.rollback();
        if (this.monitoringEnabled) {
            this.monitorTxCompleted(transaction, false);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int n) throws SystemException {
        if (n < 0) {
            n = 0;
        }
        this.transactionTimeout = n;
    }

    public Transaction suspend() throws SystemException {
        return this.tm.suspend();
    }

    public ArrayList getActiveTransactions() {
        ArrayList<TransactionAdminBean> arrayList = new ArrayList<TransactionAdminBean>();
        Vector vector = (Vector)this.activeTransactions.clone();
        for (int i = 0; i < vector.size(); ++i) {
            try {
                Transaction transaction = (Transaction)vector.elementAt(i);
                String string = "unknown";
                long l = 0L;
                long l2 = 0L;
                String string2 = "unknown";
                if (transaction instanceof TransactionImpl) {
                    string = ((TransactionImpl)transaction).getTransactionId();
                    l = ((TransactionImpl)transaction).getStartTime();
                } else if (transaction instanceof J2EETransaction) {
                    string = ((J2EETransaction)transaction).getTransactionId();
                    l = ((J2EETransaction)transaction).getStartTime();
                }
                l2 = System.currentTimeMillis() - l;
                string2 = (String)this.statusMap.get(new Integer(transaction.getStatus()));
                TransactionAdminBean transactionAdminBean = new TransactionAdminBean(transaction, string, string2, l2);
                arrayList.add(transactionAdminBean);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public void forceRollback(Transaction transaction) throws IllegalStateException, SystemException {
        if (transaction != null) {
            transaction.setRollbackOnly();
        }
    }

    public int getNumberOfTransactionsCommitted() {
        return this.m_transCommitted;
    }

    public int getNumberOfTransactionsRolledBack() {
        return this.m_transRolledback;
    }

    public int getNumberOfActiveTransactions() {
        return this.m_transInFlight;
    }

    public synchronized void freeze() {
        if (AdminUtil.isFrozenAll()) {
            return;
        }
        AdminUtil.freezeAll();
    }

    public synchronized void unfreeze() {
        if (AdminUtil.isFrozenAll()) {
            AdminUtil.unfreezeAll();
        }
    }

    public synchronized boolean isFrozen() {
        return AdminUtil.isFrozenAll();
    }

    protected void monitorTxCompleted(Object object, boolean bl) {
        if (object == null || !this.activeTransactions.remove(object)) {
            return;
        }
        if (bl) {
            ++this.m_transCommitted;
        } else {
            ++this.m_transRolledback;
        }
        --this.m_transInFlight;
    }

    public void setMonitoringEnabled(boolean bl) {
        this.monitoringEnabled = bl;
        this.m_transCommitted = 0;
        this.m_transRolledback = 0;
        this.m_transInFlight = 0;
        this.activeTransactions.removeAllElements();
    }

    private void registerStatisticMonitorTask() {
        StatisticMonitorTask statisticMonitorTask = new StatisticMonitorTask();
        Timer timer = Switch.getSwitch().getTimer();
        int n = 120000;
        try {
            String string = System.getProperty("MONITOR_JTA_RESOURCE_TABLE_SECONDS");
            int n2 = Integer.parseInt(string);
            if (n2 > 0) {
                n = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        timer.scheduleAtFixedRate((TimerTask)statisticMonitorTask, 0L, (long)n);
    }

    static {
        AdminEventListenerRegistry.addConfigChangeEventListener(JTSConfigChangeEventListener.getCategory(), new JTSConfigChangeEventListener());
    }

    class StatisticMonitorTask
    extends TimerTask {
        StatisticMonitorTask() {
        }

        public void run() {
            if (J2EETransactionManagerImpl.this.resourceTable != null) {
                Map map = J2EETransactionManagerImpl.this.resourceTable.getStats();
                Iterator iterator = map.keySet().iterator();
                System.out.println("********** J2EETransactionManagerImpl.resourceTable stats *****");
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    System.out.println(string + ": " + map.get(string).toString());
                }
            }
        }
    }
}

