/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class J2EETransaction
implements Transaction {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    protected static final boolean debug = false;
    private static long txIdCounter = 1L;
    private long txId;
    private J2EEXid xid;
    private J2EETransactionManagerOpt j2eeTM;
    private Transaction jtsTx;
    private ResourceHandle nonXAResource;
    private int localTxStatus;
    private Vector syncs = new Vector();
    private boolean commitStarted = false;
    private long startTime;
    private static final byte[] bqual = new byte[]{0};

    J2EETransaction(J2EETransactionManagerOpt j2EETransactionManagerOpt) {
        this.txId = J2EETransaction.getNewTxId();
        this.xid = new J2EEXid(this.txId);
        this.j2eeTM = j2EETransactionManagerOpt;
        this.localTxStatus = 0;
        this.startTime = System.currentTimeMillis();
    }

    J2EETransaction(J2EETransactionManagerOpt j2EETransactionManagerOpt, Transaction transaction) {
        this(j2EETransactionManagerOpt);
        this.jtsTx = transaction;
    }

    private static synchronized long getNewTxId() {
        long l = txIdCounter++;
        return l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof J2EETransaction) {
            J2EETransaction j2EETransaction = (J2EETransaction)object;
            return this.txId == j2EETransaction.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    ResourceHandle getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(ResourceHandle resourceHandle) {
        this.nonXAResource = resourceHandle;
    }

    boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(Transaction transaction) throws RollbackException, SystemException {
        this.jtsTx = transaction;
        if (!this.commitStarted) {
            for (int i = 0; i < this.syncs.size(); ++i) {
                transaction.registerSynchronization((Synchronization)this.syncs.elementAt(i));
            }
        }
    }

    Transaction getJTSTx() {
        return this.jtsTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block25: {
            this.commitStarted = true;
            if (this.jtsTx != null) {
                try {
                    this.jtsTx.commit();
                }
                finally {
                    this.j2eeTM.clearThreadTx();
                }
            }
            try {
                block24: {
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException("Transaction marked for rollback");
                    }
                    for (int i = 0; i < this.syncs.size(); ++i) {
                        try {
                            Synchronization synchronization = (Synchronization)this.syncs.elementAt(i);
                            synchronization.beforeCompletion();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException("Transaction marked for rollback");
                    }
                    if (this.jtsTx != null) {
                        this.jtsTx.commit();
                        this.localTxStatus = 3;
                        break block24;
                    }
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().commit(this.xid, true);
                    }
                    this.localTxStatus = 3;
                }
                Object var4_8 = null;
                this.j2eeTM.clearThreadTx();
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.j2eeTM.clearThreadTx();
                for (int i = 0; i < this.syncs.size(); ++i) {
                    Exception exception2222;
                    try {
                        exception2222 = (Synchronization)this.syncs.elementAt(i);
                        exception2222.afterCompletion(this.localTxStatus);
                        continue;
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < this.syncs.size(); ++i) {
                Exception exception3222;
                try {
                    exception3222 = (Synchronization)this.syncs.elementAt(i);
                    exception3222.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception exception3222) {
                    // empty catch block
                }
            }
            {
                break block25;
                catch (RollbackException rollbackException) {
                    this.localTxStatus = 4;
                    throw rollbackException;
                }
                catch (SystemException systemException) {
                    this.localTxStatus = 4;
                    throw systemException;
                }
                catch (Exception exception) {
                    this.localTxStatus = 4;
                    throw new SystemException(exception.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws IllegalStateException, SystemException {
        try {
            block13: {
                if (this.jtsTx != null) {
                    this.jtsTx.rollback();
                    break block13;
                }
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
            }
            Object var3_1 = null;
            this.j2eeTM.clearThreadTx();
            if (this.jtsTx != null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.j2eeTM.clearThreadTx();
            if (this.jtsTx != null) throw throwable;
            for (int i = 0; i < this.syncs.size(); ++i) {
                Exception exception2;
                try {
                    exception2 = (Synchronization)this.syncs.elementAt(i);
                    exception2.afterCompletion(4);
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        for (int i = 0; i < this.syncs.size(); ++i) {
            Exception exception3;
            try {
                exception3 = (Synchronization)this.syncs.elementAt(i);
                exception3.afterCompletion(4);
                continue;
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        {
            return;
            catch (Exception exception) {
                this.localTxStatus = 4;
                Object var3_2 = null;
                this.j2eeTM.clearThreadTx();
                if (this.jtsTx != null) return;
                for (int i = 0; i < this.syncs.size(); ++i) {
                    Exception exception42;
                    try {
                        exception42 = (Synchronization)this.syncs.elementAt(i);
                        exception42.afterCompletion(4);
                        continue;
                    }
                    catch (Exception exception42) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xAResource, n);
        }
        throw new IllegalStateException("J2EETransaction.delistResource called for local tx");
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xAResource);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException("Local transaction already has 1 non-XA Resource: cannot add more resources");
        }
        this.j2eeTM.startJTSTx(this);
        return this.jtsTx.enlistResource(xAResource);
    }

    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(synchronization);
        } else {
            this.syncs.add(synchronization);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int n = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return n == 1;
    }

    public String toString() {
        return "J2EETransaction: txId=" + this.txId + " nonXAResource=" + this.nonXAResource + " jtsTx=" + this.jtsTx + " localTxStatus=" + this.localTxStatus + " syncs=" + this.syncs;
    }

    public String getTransactionId() {
        return this.xid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    private class J2EEXid
    implements Xid {
        private static final int formatId = 987654321;
        private byte[] gtrId = new byte[8];
        private String stringForm = null;

        J2EEXid(long l) {
            Utility.longToBytes(l, this.gtrId, 0);
        }

        public int getFormatId() {
            return 987654321;
        }

        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        public byte[] getBranchQualifier() {
            return bqual;
        }

        public String toString() {
            int n;
            int n2;
            if (this.stringForm != null) {
                return this.stringForm;
            }
            char[] cArray = new char[this.gtrId.length * 2 + 3];
            int n3 = 0;
            int n4 = this.gtrId.length;
            for (n2 = 0; n2 < n4; ++n2) {
                n = (this.gtrId[n2] & 0xF0) >> 4;
                int n5 = this.gtrId[n2] & 0xF;
                cArray[n3++] = (char)(n + (n > 9 ? 55 : 48));
                cArray[n3++] = (char)(n5 + (n5 > 9 ? 55 : 48));
            }
            cArray[n3++] = 95;
            n2 = 0;
            n = 0;
            cArray[n3++] = (char)(n2 + (n2 > 9 ? 55 : 48));
            cArray[n3++] = (char)(n + (n > 9 ? 55 : 48));
            this.stringForm = new String(cArray);
            return this.stringForm;
        }
    }
}

