/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.jaxp.SAXParserFactoryImpl;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.SimpleElementFactory;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLUtils {
    private static final boolean debug = false;
    private Document document;
    static String VALIDATING_PARSER = "validating.parser";
    private static boolean validatingParse = false;
    static String WEB_DTD = "web-app_2_3.dtd";
    static String TAGLIB_DTD_11 = "web-jsptaglibrary_1_1.dtd";
    static String TAGLIB_DTD_12 = "web-jsptaglibrary_1_2.dtd";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public XMLUtils(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document was null");
        }
        this.document = document;
        validatingParse = false;
    }

    private XMLUtils() {
        validatingParse = false;
    }

    public static void writeDocument(Document document, OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        ((XmlDocument)document).write((Writer)bufferedWriter, "UTF-8");
    }

    public static void writeDocumentToFile(Document document, File file) throws IOException {
        if (file.getParent() != null) {
            boolean bl = new File(file.getParent()).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        XMLUtils.writeDocument(document, fileOutputStream);
        fileOutputStream.close();
    }

    public static String documentToString(Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        ((XmlDocument)document).write((Writer)stringWriter, "UTF-8");
        return stringWriter.toString();
    }

    public ElementNode getNode(String string) {
        ElementNode elementNode = (ElementNode)this.document.createElement(string);
        return elementNode;
    }

    public ElementNode getNode(String string, String string2, String string3) {
        ElementNode elementNode = this.getNode(string);
        if (string3 != null) {
            elementNode.setAttribute(string2, string3);
        }
        return elementNode;
    }

    public ElementNode getNode(String string, String string2, String string3, String string4, String string5) {
        ElementNode elementNode = this.getNode(string);
        elementNode.setAttribute(string2, string3);
        elementNode.setAttribute(string4, string5);
        return elementNode;
    }

    public ElementNode getPropertiesNode(String string, String string2, Properties properties) {
        ElementNode elementNode = this.getNode(string);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            ElementNode elementNode2 = this.getNode(string2);
            elementNode2.setAttribute("name", string3);
            elementNode2.setAttribute("value", string4);
            elementNode.appendChild((Node)elementNode2);
        }
        return elementNode;
    }

    public ElementNode getTextNode(String string, String string2) {
        ElementNode elementNode = this.getNode(string);
        elementNode.appendChild((Node)this.document.createTextNode(string2));
        return elementNode;
    }

    public static Properties getProperties(ElementNode elementNode, String string, String string2) {
        Properties properties = new Properties();
        TreeWalker treeWalker = new TreeWalker((Node)elementNode);
        Element element = treeWalker.getNextElement(string);
        treeWalker = new TreeWalker((Node)element);
        Element element2 = null;
        while ((element2 = treeWalker.getNextElement(string2)) != null) {
            ElementNode elementNode2 = (ElementNode)element2;
            String string3 = elementNode2.getAttribute("name");
            String string4 = elementNode2.getAttribute("value");
            properties.put(string3, string4);
        }
        return properties;
    }

    public static String getValueOf(Node node, String string, String string2) {
        Object object;
        Node node2 = null;
        if (node instanceof Element && ((Element)node).getTagName().equals(string)) {
            node2 = node;
        } else {
            object = new TreeWalker(node);
            node2 = object.getNextElement(string);
        }
        if (node2 == null) {
            throw new RuntimeException("can't find a node under " + node + " with tag " + string);
        }
        object = (Attr)node2.getAttributes().getNamedItem(string2);
        return object.getNodeValue();
    }

    private static String getTextFor_Lib(ElementNode elementNode, String string) {
        if (elementNode.getTagName().equals(string) && elementNode.getFirstChild() instanceof Text) {
            return ((Text)elementNode.getFirstChild()).getNodeValue();
        }
        TreeWalker treeWalker = new TreeWalker((Node)elementNode);
        ElementNode elementNode2 = (ElementNode)treeWalker.getNextElement(string);
        if (elementNode2 == null) {
            throw new IllegalArgumentException(elementNode + " has no sub nodes with tag " + string);
        }
        Text text = (Text)elementNode2.getFirstChild();
        if (text == null) {
            return "";
        }
        return text.getNodeValue();
    }

    public static String getTextFor(ElementNode elementNode, String string) {
        return XMLUtils.getTextFor_Lib(elementNode, string);
    }

    public static ElementNode getFirstNodeUnder(Node node, String string) {
        TreeWalker treeWalker = new TreeWalker(node);
        Element element = treeWalker.getNextElement(string);
        if (element != null) {
            return (ElementNode)element;
        }
        return null;
    }

    public static boolean hasImmediateElementChildFor(ElementNode elementNode, String string) {
        NodeList nodeList = elementNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ElementNode elementNode2;
            Node node = nodeList.item(i);
            if (!(node instanceof ElementNode) || !(elementNode2 = (ElementNode)node).getTagName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNodesUnder(Node node, String string) {
        return XMLUtils.getFirstNodeUnder(node, string) != null;
    }

    public static Enumeration getNodesUnder(Node node, String string) {
        return XMLUtils.getVectorOfNodesUnder(node, string).elements();
    }

    public static Enumeration getNodesUnder(Node node, String[] stringArray) {
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addAll(XMLUtils.getVectorOfNodesUnder(node, stringArray[i]));
        }
        return vector.elements();
    }

    public static Vector getVectorOfNodesUnder(Node node, String string) {
        Vector<Element> vector = new Vector<Element>();
        Element element = null;
        TreeWalker treeWalker = new TreeWalker(node);
        while ((element = treeWalker.getNextElement(string)) != null) {
            vector.addElement(element);
        }
        return vector;
    }

    public static SAXParserFactory getSAXParserFactory() {
        return new SAXParserFactoryImpl();
    }

    public static Vector getNodesByType(Class clazz, Dictionary dictionary, InputStream inputStream, boolean bl) throws Throwable {
        Vector<XmlDocument> vector = new Vector<XmlDocument>();
        SimpleElementFactory simpleElementFactory = new SimpleElementFactory();
        simpleElementFactory.addMapping(dictionary, XMLUtils.class.getClassLoader());
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
        xmlDocumentBuilder.setIgnoringLexicalInfo(true);
        xmlDocumentBuilder.setElementFactory((ElementFactory)simpleElementFactory);
        SAXParserFactory sAXParserFactory = XMLUtils.getSAXParserFactory();
        sAXParserFactory.setValidating(bl);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        String string = "http://xml.org/sax/properties/lexical-handler";
        xMLReader.setProperty(string, xmlDocumentBuilder);
        XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(bl);
        xMLReader.setEntityResolver(xMLValidationHandler);
        xMLReader.setErrorHandler(xMLValidationHandler);
        xMLReader.setContentHandler((ContentHandler)xmlDocumentBuilder);
        try {
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (UnknownHostException unknownHostException) {
            throw new ParseException("Neither this XML document's public nor system id's could be resolved: " + unknownHostException + " " + unknownHostException.getMessage() + "\n on parsing the doucment corresponding to " + clazz);
        }
        XmlDocument xmlDocument = xmlDocumentBuilder.getDocument();
        TreeWalker treeWalker = new TreeWalker((Node)xmlDocument);
        Object object = xmlDocument;
        while (object != null) {
            if (clazz.isInstance(object)) {
                vector.addElement((XmlDocument)object);
            }
            object = treeWalker.getNext();
        }
        return vector;
    }

    static {
        validatingParse = false;
    }
}

