/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.XMLTree;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.parser.Resolver;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser {
    private XmlDocument doc = null;
    private static final boolean DefaultCheckType = false;
    private static final String DefaultContentType = "text/html;charset=utf-8";
    private static final String DefaultScheme = "file";
    private static final boolean DefaultXMLValidate = true;
    private static final int PCDataType = 3;

    public void clear() {
        this.doc = null;
    }

    public XMLTree process(InputStream inputStream) throws IOException, SAXParseException, SAXException {
        return this.process(inputStream, false, DefaultContentType, DefaultScheme);
    }

    public XMLTree process(InputStream inputStream, boolean bl) throws IOException, SAXParseException, SAXException {
        return this.process(inputStream, bl, DefaultContentType, DefaultScheme);
    }

    public XMLTree process(InputStream inputStream, boolean bl, String string) throws IOException, SAXParseException, SAXException {
        return this.process(inputStream, bl, string, DefaultScheme);
    }

    public XMLTree process(InputStream inputStream, boolean bl, String string, String string2) throws IOException, SAXParseException, SAXException {
        return this.parse(Resolver.createInputSource((String)string, (InputStream)inputStream, (boolean)bl, (String)string2), bl);
    }

    public XMLTree process(URL uRL) throws IOException, SAXParseException, SAXException {
        return this.process(uRL, false);
    }

    public XMLTree process(URL uRL, boolean bl) throws IOException, SAXParseException, SAXException {
        return this.parse(new InputSource(uRL.toString()), bl);
    }

    public XmlDocument getXmlDocument() {
        return this.doc;
    }

    public void write() throws IOException {
        this.write(null);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            outputStream = System.out;
        }
        this.doc.getDocumentElement().normalize();
        this.doc.write(outputStream);
    }

    private XMLTree parse(InputSource inputSource) throws IOException, SAXParseException, SAXException {
        return this.parse(inputSource, true);
    }

    private XMLTree parse(InputSource inputSource, boolean bl) throws IOException, SAXParseException, SAXException {
        Object object;
        Object object2;
        SAXParserFactory sAXParserFactory = XMLUtils.getSAXParserFactory();
        if (bl) {
            sAXParserFactory.setValidating(true);
        } else {
            sAXParserFactory.setValidating(false);
        }
        try {
            object2 = sAXParserFactory.newSAXParser().getXMLReader();
            object = new XMLValidationHandler(false);
            XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
            object2.setEntityResolver((EntityResolver)object);
            xmlDocumentBuilder.setDisableNamespaces(true);
            xmlDocumentBuilder.setIgnoringLexicalInfo(true);
            object2.setContentHandler((ContentHandler)xmlDocumentBuilder);
            object2.parse(inputSource);
            this.doc = xmlDocumentBuilder.getDocument();
        }
        catch (Exception exception) {
            String string = "";
            int n = -1;
            String string2 = "";
            String string3 = "";
            int n2 = -1;
            if (exception instanceof SAXParseException) {
                string = ((SAXParseException)exception).getSystemId();
                n = ((SAXParseException)exception).getLineNumber();
                string2 = ((SAXParseException)exception).getMessage();
                string3 = ((SAXParseException)exception).getPublicId();
                n2 = ((SAXParseException)exception).getColumnNumber();
            }
            String string4 = "Parse Error: " + string + " : " + n + "\n  msg : " + string2;
            throw new SAXParseException(string4, string3, string, n, n2);
        }
        object2 = new XMLTree();
        object = this.doc.getDocumentElement();
        ((XMLTree)object2).setName(object.getTagName());
        this.addAttributes((XMLTree)object2, (Node)object);
        this.addElements((XMLTree)object2, (Node)object);
        return object2;
    }

    private void addAttributes(XMLTree xMLTree, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                xMLTree.addAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
    }

    private void addElements(XMLTree xMLTree, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XMLTree xMLTree2 = new XMLTree();
            Node node2 = nodeList.item(i);
            xMLTree2.setName(node2.getNodeName());
            this.addAttributes(xMLTree2, node2);
            if (node2.getNodeType() != 3) {
                this.addElements(xMLTree2, node2);
                xMLTree.addElement(xMLTree2);
                continue;
            }
            xMLTree.setValue(node2.getNodeValue());
        }
    }
}

