/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.DescriptorEnvironment;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.util.TypeUtil;
import com.sun.logging.LogDomains;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.crimson.tree.ElementNode;
import org.w3c.dom.Node;

public class EjbNode
extends ElementNode {
    private static final boolean debug = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public static String[] getTags() {
        String[] stringArray = new String[]{"session", "entity", "message-driven"};
        return stringArray;
    }

    public void setDescriptor(EjbDescriptor ejbDescriptor) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        EjbEntityDescriptor ejbEntityDescriptor = null;
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils xMLUtils = new XMLUtils(super.getOwnerDocument());
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            this.setTag("entity");
        } else if (ejbDescriptor instanceof EjbSessionDescriptor) {
            this.setTag("session");
        } else {
            this.setTag("message-driven");
        }
        DescriptorNodeUtils.appendDescriptorAttributes(xMLUtils, ejbDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        this.appendChild((Node)xMLUtils.getTextNode("ejb-name", ejbDescriptor.getName()));
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                this.appendChild((Node)xMLUtils.getTextNode("home", ejbDescriptor.getHomeClassName()));
                this.appendChild((Node)xMLUtils.getTextNode("remote", ejbDescriptor.getRemoteClassName()));
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                this.appendChild((Node)xMLUtils.getTextNode("local-home", ejbDescriptor.getLocalHomeClassName()));
                this.appendChild((Node)xMLUtils.getTextNode("local", ejbDescriptor.getLocalClassName()));
            }
        }
        this.appendChild((Node)xMLUtils.getTextNode("ejb-class", ejbDescriptor.getEjbClassName()));
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            ejbEntityDescriptor = (EjbEntityDescriptor)ejbDescriptor;
            this.appendChild((Node)xMLUtils.getTextNode("persistence-type", ejbEntityDescriptor.getPersistenceType()));
            if (!ejbEntityDescriptor.getPrimaryKeyClassName().equals("")) {
                this.appendChild((Node)xMLUtils.getTextNode("prim-key-class", ejbEntityDescriptor.getPrimaryKeyClassName()));
            }
            this.appendChild((Node)xMLUtils.getTextNode("reentrant", ejbEntityDescriptor.isReentrantAsString()));
            if (ejbEntityDescriptor.getPersistenceType().equals("Container")) {
                object4 = (EjbCMPEntityDescriptor)ejbEntityDescriptor;
                this.appendChild((Node)xMLUtils.getTextNode("cmp-version", ((EjbCMPEntityDescriptor)object4).getCMPVersion()));
                if (((EjbCMPEntityDescriptor)object4).isEJB20()) {
                    this.appendChild((Node)xMLUtils.getTextNode("abstract-schema-name", ((EjbCMPEntityDescriptor)object4).getAbstractSchemaName()));
                }
                object3 = ((EjbCMPEntityDescriptor)object4).getPersistenceDescriptor();
                object2 = ((PersistenceDescriptor)object3).getCMPFields().iterator();
                while (object2.hasNext()) {
                    object = (FieldDescriptor)object2.next();
                    string = xMLUtils.getNode("cmp-field");
                    this.appendChild((Node)((Object)string));
                    if (!((Descriptor)object).getDescription().equals("")) {
                        string.appendChild((Node)xMLUtils.getTextNode("description", ((Descriptor)object).getDescription()));
                    }
                    string.appendChild((Node)xMLUtils.getTextNode("field-name", ((Descriptor)object).getName()));
                }
                if (((EjbCMPEntityDescriptor)object4).getPrimaryKeyFieldDesc() != null) {
                    this.appendChild((Node)xMLUtils.getTextNode("primkey-field", ((EjbCMPEntityDescriptor)object4).getPrimaryKeyFieldDesc().getName()));
                }
            }
        }
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            object4 = xMLUtils.getTextNode("session-type", ((EjbSessionDescriptor)ejbDescriptor).getSessionTypeString());
            this.appendChild((Node)object4);
        }
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            this.appendChild((Node)xMLUtils.getTextNode("transaction-type", ejbDescriptor.getTransactionType()));
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            object4 = (EjbMessageBeanDescriptor)ejbDescriptor;
            if (((EjbMessageBeanDescriptor)object4).hasJmsMessageSelector()) {
                this.appendChild((Node)xMLUtils.getTextNode("message-selector", ((EjbMessageBeanDescriptor)object4).getJmsMessageSelector()));
            }
            if (((EjbDescriptor)object4).getTransactionType().equals(EjbDescriptor.BEAN_TRANSACTION_TYPE)) {
                object3 = ((EjbMessageBeanDescriptor)object4).getJmsAcknowledgeMode() == 1 ? "Auto-acknowledge" : "Dups-ok-acknowledge";
                this.appendChild((Node)xMLUtils.getTextNode("acknowledge-mode", (String)object3));
            }
            object3 = xMLUtils.getNode("message-driven-destination");
            this.appendChild((Node)object3);
            object2 = ((EjbMessageBeanDescriptor)object4).hasQueueDest() ? "javax.jms.Queue" : "javax.jms.Topic";
            object3.appendChild((Node)xMLUtils.getTextNode("destination-type", (String)object2));
            if (((EjbMessageBeanDescriptor)object4).hasTopicDest()) {
                object = ((EjbMessageBeanDescriptor)object4).hasDurableSubscription() ? "Durable" : "NonDurable";
                object3.appendChild((Node)xMLUtils.getTextNode("subscription-durability", (String)object));
            }
        }
        DescriptorNodeUtils.appendEnvironmentProperties(xMLUtils, ejbDescriptor, this);
        DescriptorNodeUtils.appendEjbReferences(xMLUtils, ejbDescriptor, this);
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
            object4 = ejbDescriptor.getRoleReferences().iterator();
            while (object4.hasNext()) {
                object3 = (RoleReference)object4.next();
                object2 = xMLUtils.getNode("security-role-ref");
                this.appendChild((Node)object2);
                if (!"".equals(((Descriptor)object3).getDescription())) {
                    object2.appendChild((Node)xMLUtils.getTextNode("description", ((Descriptor)object3).getDescription()));
                }
                object2.appendChild((Node)xMLUtils.getTextNode("role-name", ((Descriptor)object3).getName()));
                if ("".equals(((EnvironmentProperty)object3).getValue())) continue;
                object2.appendChild((Node)xMLUtils.getTextNode("role-link", ((EnvironmentProperty)object3).getValue()));
            }
        }
        if (ejbDescriptor.getUsesCallerIdentity()) {
            object4 = xMLUtils.getNode("security-identity");
            this.appendChild((Node)object4);
            object3 = ejbDescriptor.getSecurityIdentityDescription();
            if (object3 != null && !((String)object3).equals("")) {
                object4.appendChild((Node)xMLUtils.getTextNode("description", (String)object3));
            }
            object4.appendChild((Node)xMLUtils.getTextNode("use-caller-identity", ""));
        } else if (ejbDescriptor.getRunAsIdentity() != null) {
            object4 = xMLUtils.getNode("security-identity");
            this.appendChild((Node)object4);
            object3 = ejbDescriptor.getSecurityIdentityDescription();
            if (object3 != null && !((String)object3).equals("")) {
                object4.appendChild((Node)xMLUtils.getTextNode("description", (String)object3));
            }
            object2 = xMLUtils.getNode("run-as");
            object4.appendChild((Node)object2);
            object = ejbDescriptor.getRunAsIdentity();
            string = ((Descriptor)object).getDescription();
            if (string != null && !string.equals("")) {
                object2.appendChild((Node)xMLUtils.getTextNode("description", ((Descriptor)object).getDescription()));
            }
            object2.appendChild((Node)xMLUtils.getTextNode("role-name", ((RunAsIdentityDescriptor)object).getRoleName()));
        }
        DescriptorNodeUtils.appendResourceReferences(xMLUtils, ejbDescriptor, this);
        DescriptorNodeUtils.appendJmsDestinationReferences(xMLUtils, ejbDescriptor, this);
        if (ejbDescriptor instanceof EjbEntityDescriptor && ejbEntityDescriptor.getPersistenceType().equals("Container") && ((EjbCMPEntityDescriptor)(object4 = (EjbCMPEntityDescriptor)ejbEntityDescriptor)).isEJB20()) {
            object3 = ((EjbCMPEntityDescriptor)object4).getPersistenceDescriptor();
            EjbNode.writeQueries(this, (PersistenceDescriptor)object3, xMLUtils);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EjbDescriptor getDescriptor() throws ContentTransformationException {
        Object object = this;
        Descriptor descriptor = null;
        try {
            String string;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (this.getTagName().equals("entity")) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "persistence-type");
                object5 = XMLUtils.getTextFor(this, "persistence-type");
                descriptor = ((String)object5).equals(EjbEntityDescriptor.BEAN_PERSISTENCE) ? new EjbEntityDescriptor() : DescriptorEnvironment.createEjbCMPEntityDescriptor();
            } else {
                descriptor = this.getTagName().equals("session") ? new EjbSessionDescriptor() : new EjbMessageBeanDescriptor();
            }
            DescriptorNodeUtils.setDescriptorAttributes(this, descriptor, DescriptorNodeUtils.EJB_STYLE);
            object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "ejb-name");
            descriptor.setName(XMLUtils.getTextFor(this, "ejb-name"));
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                if (XMLUtils.hasImmediateElementChildFor(this, "home")) {
                    object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "home");
                    ((EjbAbstractDescriptor)descriptor).setHomeClassName(XMLUtils.getTextFor(this, "home"));
                    object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "remote");
                    ((EjbAbstractDescriptor)descriptor).setRemoteClassName(XMLUtils.getTextFor(this, "remote"));
                }
                if (XMLUtils.hasImmediateElementChildFor(this, "local-home")) {
                    object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "local-home");
                    ((EjbAbstractDescriptor)descriptor).setLocalHomeClassName(XMLUtils.getTextFor(this, "local-home"));
                    object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "ejb-name");
                    ((EjbAbstractDescriptor)descriptor).setLocalClassName(XMLUtils.getTextFor(this, "local"));
                }
                if (((EjbAbstractDescriptor)descriptor).getHomeClassName() == null && ((EjbAbstractDescriptor)descriptor).getLocalHomeClassName() == null) {
                    throw new RuntimeException("Invalid XML : Bean " + descriptor.getName() + " does not define a local home or home interface");
                }
            }
            object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "ejb-class");
            ((EjbDescriptor)descriptor).setEjbClassName(XMLUtils.getTextFor(this, "ejb-class"));
            if (this.getTagName().equals("entity")) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "persistence-type");
                object5 = XMLUtils.getTextFor(this, "persistence-type");
                ((EjbEntityDescriptor)descriptor).setPersistenceType((String)object5);
            }
            if (descriptor instanceof EjbEntityDescriptor) {
                object5 = (EjbEntityDescriptor)descriptor;
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "prim-key-class");
                ((EjbEntityDescriptor)object5).setPrimaryKeyClassName(XMLUtils.getTextFor(this, "prim-key-class"));
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "reentrant");
                ((EjbEntityDescriptor)object5).setReentrant(XMLUtils.getTextFor(this, "reentrant"));
                if (object5 instanceof EjbCMPEntityDescriptor) {
                    object4 = (EjbCMPEntityDescriptor)object5;
                    object3 = this.getOwnerDocument();
                    object2 = object3.getDoctype();
                    if (object2 == null) {
                        throw new RuntimeException("Invalid XML : No document type for " + object3);
                    }
                    string = object2.getPublicId();
                    boolean bl = true;
                    String string2 = EjbCMPEntityDescriptor.CMP_2_VERSION;
                    if (string.equals(EjbBundleNode.PUBLIC_DTD_ID)) {
                        if (XMLUtils.hasNodesUnder((Node)((Object)this), "cmp-version")) {
                            object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "cmp-version");
                            string2 = XMLUtils.getTextFor(this, "cmp-version");
                            bl = string2.equals(EjbCMPEntityDescriptor.CMP_2_VERSION);
                        }
                    } else {
                        if (!string.equals(EjbBundleNode.PUBLIC_DTD_ID_12)) throw new RuntimeException("Invalid XML : Unknown document type : " + object2);
                        string2 = EjbCMPEntityDescriptor.CMP_1_VERSION;
                        bl = false;
                    }
                    ((EjbCMPEntityDescriptor)object4).setCMPVersion(string2);
                    if (bl) {
                        object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "abstract-schema-name");
                        ((EjbCMPEntityDescriptor)object4).setAbstractSchemaName(XMLUtils.getTextFor(this, "abstract-schema-name"));
                    }
                    PersistenceDescriptor persistenceDescriptor = new PersistenceDescriptor();
                    ((EjbCMPEntityDescriptor)object4).setPersistenceDescriptor(persistenceDescriptor);
                    HashSet<FieldDescriptor> hashSet = new HashSet<FieldDescriptor>();
                    Object object6 = XMLUtils.getNodesUnder((Node)((Object)this), "cmp-field");
                    while (object6.hasMoreElements()) {
                        ElementNode elementNode = (ElementNode)object6.nextElement();
                        object = elementNode;
                        String string3 = "";
                        if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
                            string3 = XMLUtils.getTextFor(elementNode, "description");
                            object = XMLUtils.getFirstNodeUnder((Node)elementNode, "description");
                        }
                        FieldDescriptor fieldDescriptor = new FieldDescriptor(XMLUtils.getTextFor(elementNode, "field-name"), string3);
                        object = XMLUtils.getFirstNodeUnder((Node)elementNode, "field-name");
                        if (bl) {
                            FieldDescriptor.checkFieldName(fieldDescriptor.getName());
                        }
                        hashSet.add(fieldDescriptor);
                    }
                    persistenceDescriptor.setCMPFields(hashSet);
                    if (XMLUtils.hasNodesUnder((Node)((Object)this), "primkey-field")) {
                        object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "primkey-field");
                        object6 = XMLUtils.getTextFor(this, "primkey-field");
                        ((EjbCMPEntityDescriptor)object4).setPrimaryKeyFieldDesc(new FieldDescriptor((String)object6, ""));
                    }
                }
            }
            if (descriptor instanceof EjbSessionDescriptor) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "session-type");
                object5 = XMLUtils.getTextFor(this, "session-type");
                ((EjbSessionDescriptor)descriptor).setSessionTypeString((String)object5);
            }
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbMessageBeanDescriptor) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "transaction-type");
                ((EjbDescriptor)descriptor).setTransactionType(XMLUtils.getTextFor(this, "transaction-type"));
            }
            if ((object5 = XMLUtils.getFirstNodeUnder((Node)((Object)this), "transaction-scope")) != null) {
                object = object5;
                object4 = XMLUtils.getTextFor(this, "transaction-scope");
                ((EjbDescriptor)descriptor).setDistributedTransactionScope(((String)object4).equals("Distributed"));
            } else {
                ((EjbDescriptor)descriptor).setDistributedTransactionScope(true);
            }
            if (descriptor instanceof EjbMessageBeanDescriptor) {
                object4 = (EjbMessageBeanDescriptor)descriptor;
                if (XMLUtils.hasNodesUnder((Node)((Object)this), "message-selector")) {
                    object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "message-selector");
                    ((EjbMessageBeanDescriptor)object4).setJmsMessageSelector(XMLUtils.getTextFor(this, "message-selector"));
                }
                if (XMLUtils.hasNodesUnder((Node)((Object)this), "acknowledge-mode")) {
                    object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "acknowledge-mode");
                    object3 = XMLUtils.getTextFor(this, "acknowledge-mode");
                    if (((String)object3).equals("Auto-acknowledge")) {
                        ((EjbMessageBeanDescriptor)object4).setJmsAcknowledgeMode(1);
                    } else {
                        if (!((String)object3).equals("Dups-ok-acknowledge")) throw new IllegalArgumentException("Invalid jms acknowledge mode : " + (String)object3);
                        ((EjbMessageBeanDescriptor)object4).setJmsAcknowledgeMode(3);
                    }
                }
                if ((object3 = XMLUtils.getFirstNodeUnder((Node)((Object)this), "message-driven-destination")) != null) {
                    object = object3;
                    object2 = XMLUtils.getTextFor((ElementNode)object3, "destination-type");
                    if (((String)object2).equals("javax.jms.Queue")) {
                        ((EjbMessageBeanDescriptor)object4).setHasQueueDest();
                    } else {
                        if (!((String)object2).equals("javax.jms.Topic")) throw new IllegalArgumentException("Invalid jms dest type : " + (String)object2);
                        ((EjbMessageBeanDescriptor)object4).setHasTopicDest();
                        if (XMLUtils.hasNodesUnder((Node)object3, "subscription-durability")) {
                            string = XMLUtils.getTextFor((ElementNode)object3, "subscription-durability");
                            if (string.equals("Durable")) {
                                ((EjbMessageBeanDescriptor)object4).setHasDurableSubscription(true);
                            } else {
                                if (!string.equals("NonDurable")) throw new IllegalArgumentException("Invalid subscription durability string : " + string);
                                ((EjbMessageBeanDescriptor)object4).setHasDurableSubscription(false);
                            }
                        }
                    }
                } else {
                    ((EjbMessageBeanDescriptor)object4).setHasQueueDest();
                }
            }
            DescriptorNodeUtils.setEnvironmentProperties(this, (WritableJndiNameEnvironment)((Object)descriptor));
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                object4 = XMLUtils.getNodesUnder((Node)((Object)this), "security-role-ref");
                while (object4.hasMoreElements()) {
                    object3 = (ElementNode)object4.nextElement();
                    object = object3;
                    object2 = XMLUtils.getTextFor((ElementNode)object3, "role-name");
                    string = "";
                    if (XMLUtils.hasNodesUnder((Node)object3, "description")) {
                        string = XMLUtils.getTextFor((ElementNode)object3, "description");
                    }
                    RoleReference roleReference = new RoleReference((String)object2, string);
                    if (XMLUtils.hasNodesUnder((Node)object3, "role-link")) {
                        roleReference.setValue(XMLUtils.getTextFor((ElementNode)object3, "role-link"));
                    }
                    ((EjbDescriptor)descriptor).addRoleReference(roleReference);
                }
            }
            if ((object4 = XMLUtils.getFirstNodeUnder((Node)((Object)this), "security-identity")) != null) {
                object = object4;
                if (XMLUtils.hasNodesUnder((Node)object4, "description") && (object3 = XMLUtils.getTextFor((ElementNode)object4, "description")) != null) {
                    ((EjbDescriptor)descriptor).setSecurityIdentityDescription((String)object3);
                }
                if ((object3 = XMLUtils.getFirstNodeUnder((Node)object4, "run-as")) != null) {
                    object = object3;
                    object2 = new RunAsIdentityDescriptor();
                    if (XMLUtils.hasNodesUnder((Node)object3, "description") && (string = XMLUtils.getTextFor((ElementNode)object3, "description")) != null) {
                        ((Descriptor)object2).setDescription(string);
                    }
                    ((RunAsIdentityDescriptor)object2).setRoleName(XMLUtils.getTextFor((ElementNode)object3, "role-name"));
                    ((EjbDescriptor)descriptor).setUsesCallerIdentity(false);
                    ((EjbDescriptor)descriptor).setRunAsIdentity((RunAsIdentityDescriptor)object2);
                } else {
                    ((EjbDescriptor)descriptor).setUsesCallerIdentity(true);
                }
            } else if (descriptor instanceof EjbMessageBeanDescriptor) {
                ((EjbDescriptor)descriptor).setUsesCallerIdentity(false);
            }
            DescriptorNodeUtils.setResourceReferences(this, (WritableJndiNameEnvironment)((Object)descriptor));
            DescriptorNodeUtils.setJmsDestinationReferences(this, (WritableJndiNameEnvironment)((Object)descriptor));
            return descriptor;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ContentTransformationException((descriptor == null ? "" : descriptor.getName()) + "\n" + illegalArgumentException.getMessage(), object == null ? "" : object.toString());
        }
        catch (Exception exception) {
            throw new ContentTransformationException((descriptor == null ? "" : descriptor.getName()) + "\n" + exception.getMessage(), object == null ? "" : object.toString());
        }
    }

    public void completeLoadingDescriptor(EjbDescriptor ejbDescriptor) {
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor;
        if (ejbDescriptor instanceof EjbCMPEntityDescriptor && (ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)ejbDescriptor).isEJB20()) {
            EjbNode.parseQueries(this, ejbCMPEntityDescriptor.getPersistenceDescriptor());
        }
    }

    static void parseQueries(ElementNode elementNode, PersistenceDescriptor persistenceDescriptor) {
        Enumeration enumeration = XMLUtils.getNodesUnder((Node)elementNode, "query");
        while (enumeration.hasMoreElements()) {
            String string;
            Method method;
            ElementNode elementNode2 = (ElementNode)enumeration.nextElement();
            QueryDescriptor queryDescriptor = new QueryDescriptor();
            if (XMLUtils.hasNodesUnder((Node)elementNode2, "description")) {
                queryDescriptor.setDescription(XMLUtils.getTextFor(elementNode2, "description"));
            }
            try {
                method = EjbNode.parseQueryMethod(elementNode2, persistenceDescriptor.getParentDescriptor());
            }
            catch (Exception exception) {
                throw new RuntimeException("No method found for XML query element: " + exception.getMessage());
            }
            queryDescriptor.setQueryMethod(method);
            persistenceDescriptor.setQueryFor(method, queryDescriptor);
            if (XMLUtils.hasNodesUnder((Node)elementNode2, "result-type-mapping")) {
                string = XMLUtils.getTextFor(elementNode2, "result-type-mapping");
                if (string.equals("Remote")) {
                    queryDescriptor.setHasRemoteReturnTypeMapping();
                } else if (string.equals("Local")) {
                    queryDescriptor.setHasLocalReturnTypeMapping();
                }
            }
            if ((string = XMLUtils.getTextFor(elementNode2, "ejb-ql")) != null && string.trim().length() > 0) {
                queryDescriptor.setQuery(string);
                continue;
            }
            queryDescriptor.setQuery(null);
        }
    }

    private static Method parseQueryMethod(ElementNode elementNode, Descriptor descriptor) throws Exception {
        Object object;
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        ClassLoader classLoader = null;
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)descriptor;
        classLoader = ((EjbBundleArchivist)ejbCMPEntityDescriptor.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        if (ejbCMPEntityDescriptor.isRemoteInterfacesSupported()) {
            clazz = classLoader.loadClass(ejbCMPEntityDescriptor.getHomeClassName());
        }
        if (ejbCMPEntityDescriptor.isLocalInterfacesSupported()) {
            clazz2 = classLoader.loadClass(ejbCMPEntityDescriptor.getLocalHomeClassName());
        }
        clazz3 = classLoader.loadClass(ejbCMPEntityDescriptor.getEjbClassName());
        ElementNode elementNode2 = XMLUtils.getFirstNodeUnder((Node)elementNode, "query-method");
        String string = XMLUtils.getTextFor(elementNode2, "method-name");
        ElementNode elementNode3 = XMLUtils.getFirstNodeUnder((Node)elementNode2, "method-params");
        Vector vector = XMLUtils.getVectorOfNodesUnder((Node)elementNode, "method-param");
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object = (ElementNode)vector.elementAt(i);
            stringArray[i] = XMLUtils.getTextFor(object, "method-param");
        }
        if (string.startsWith("ejbSelect")) {
            return TypeUtil.getMethod(clazz3, classLoader, string, stringArray);
        }
        Method method = null;
        object = null;
        try {
            if (ejbCMPEntityDescriptor.isRemoteInterfacesSupported()) {
                object = TypeUtil.getMethod(clazz, classLoader, string, stringArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ejbCMPEntityDescriptor.isLocalInterfacesSupported()) {
                method = TypeUtil.getMethod(clazz2, classLoader, string, stringArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            return object;
        }
        if (method != null) {
            return method;
        }
        throw new RuntimeException("Ambiguous or invalid <query-method>");
    }

    private static void getClass(String string, ClassLoader classLoader) {
    }

    static void writeQueries(ElementNode elementNode, PersistenceDescriptor persistenceDescriptor, XMLUtils xMLUtils) {
        Iterator iterator = persistenceDescriptor.getQueriedMethods().iterator();
        while (iterator.hasNext()) {
            String string;
            Method method = (Method)iterator.next();
            QueryDescriptor queryDescriptor = persistenceDescriptor.getQueryFor(method);
            ElementNode elementNode2 = xMLUtils.getNode("query");
            if (queryDescriptor.getDescription() != null) {
                elementNode2.appendChild((Node)xMLUtils.getTextNode("description", queryDescriptor.getDescription()));
            }
            EjbNode.writeQueryMethod(elementNode2, method, persistenceDescriptor, xMLUtils);
            if (queryDescriptor.getHasLocalReturnTypeMapping() || queryDescriptor.getHasRemoteReturnTypeMapping()) {
                string = queryDescriptor.getHasRemoteReturnTypeMapping() ? "Remote" : "Local";
                elementNode2.appendChild((Node)xMLUtils.getTextNode("result-type-mapping", string));
            }
            string = queryDescriptor.getIsEjbQl() ? queryDescriptor.getQuery() : "";
            elementNode2.appendChild((Node)xMLUtils.getTextNode("ejb-ql", string));
            elementNode.appendChild((Node)elementNode2);
        }
    }

    private static void writeQueryMethod(ElementNode elementNode, Method method, PersistenceDescriptor persistenceDescriptor, XMLUtils xMLUtils) {
        ElementNode elementNode2 = xMLUtils.getNode("query-method");
        elementNode.appendChild((Node)elementNode2);
        elementNode2.appendChild((Node)xMLUtils.getTextNode("method-name", method.getName()));
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)persistenceDescriptor.getParentDescriptor();
        ElementNode elementNode3 = xMLUtils.getNode("method-params");
        elementNode2.appendChild((Node)elementNode3);
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            String string = MethodDescriptor.fixParamClassName(classArray[i].getName());
            ElementNode elementNode4 = xMLUtils.getTextNode("method-param", string);
            elementNode3.appendChild((Node)elementNode4);
        }
    }

    public static Vector readEjbNodes(InputStream inputStream, boolean bl) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            hashtable.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            hashtable.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            hashtable.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(EjbNode.class, hashtable, inputStream, bl);
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_node_ejb", throwable);
            return new Vector();
        }
    }
}

