/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.DescriptorEnvironment;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.EjbNode;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.logging.LogDomains;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EjbBundleNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public EjbBundleNode() {
        this.setTag("ejb-jar");
    }

    public void setDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        Object object;
        ElementNode elementNode;
        Document document = this.getOwnerDocument();
        if (document == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils xMLUtils = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(xMLUtils, ejbBundleDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        ElementNode elementNode2 = xMLUtils.getNode("enterprise-beans");
        this.appendChild((Node)elementNode2);
        ElementNode elementNode3 = ejbBundleDescriptor.getEjbs().iterator();
        while (elementNode3.hasNext()) {
            elementNode = (EjbDescriptor)elementNode3.next();
            object = new EjbNode();
            elementNode2.appendChild((Node)object);
            ((EjbNode)((Object)object)).setDescriptor((EjbDescriptor)elementNode);
        }
        if (ejbBundleDescriptor.hasRelationships()) {
            this.setRelationships(xMLUtils, ejbBundleDescriptor);
        }
        if (ejbBundleDescriptor.hasAssemblyInformation()) {
            Object object2;
            Vector vector;
            Object object3;
            Object object4;
            Object object5;
            elementNode3 = xMLUtils.getNode("assembly-descriptor");
            this.appendChild((Node)elementNode3);
            elementNode = ejbBundleDescriptor.getRoles().iterator();
            while (elementNode.hasNext()) {
                object = (Role)elementNode.next();
                object5 = xMLUtils.getNode("security-role");
                elementNode3.appendChild((Node)object5);
                if (!((Role)object).getDescription().equals("")) {
                    object5.appendChild((Node)xMLUtils.getTextNode("description", ((Role)object).getDescription()));
                }
                object5.appendChild((Node)xMLUtils.getTextNode("role-name", ((PrincipalImpl)object).getName()));
            }
            elementNode = ejbBundleDescriptor.getEjbs().iterator();
            while (elementNode.hasNext()) {
                object = (EjbDescriptor)elementNode.next();
                object5 = ((EjbDescriptor)object).getPermissionedMethodsByPermission();
                this.setMethodDescriptor(xMLUtils, (Map)object5, elementNode3, (EjbDescriptor)object);
                object4 = ((EjbDescriptor)object).getStyledPermissionedMethodsByPermission();
                this.setMethodDescriptor(xMLUtils, (Map)object4, elementNode3, (EjbDescriptor)object);
            }
            elementNode = ejbBundleDescriptor.getEjbs().iterator();
            while (elementNode.hasNext()) {
                object = (EjbDescriptor)elementNode.next();
                if (((EjbDescriptor)object).getMethodContainerTransactions().isEmpty()) continue;
                object5 = ((EjbDescriptor)object).getMethodContainerTransactions().keys();
                while (object5.hasMoreElements()) {
                    object4 = (MethodDescriptor)object5.nextElement();
                    object3 = (ContainerTransaction)((EjbDescriptor)object).getMethodContainerTransactions().get(object4);
                    vector = xMLUtils.getNode("container-transaction");
                    elementNode3.appendChild((Node)((Object)vector));
                    if (!((Descriptor)object3).getDescription().equals("")) {
                        vector.appendChild((Node)xMLUtils.getTextNode("description", ((Descriptor)object3).getDescription()));
                    }
                    object2 = new MethodDescriptorNode();
                    vector.appendChild((Node)object2);
                    ((MethodDescriptorNode)((Object)object2)).setDescriptor((MethodDescriptor)object4, (Descriptor)object);
                    vector.appendChild((Node)xMLUtils.getTextNode("trans-attribute", ((ContainerTransaction)object3).getTransactionAttribute()));
                }
            }
            elementNode = null;
            object = ejbBundleDescriptor.getEjbs().iterator();
            while (object.hasNext()) {
                object5 = (EjbDescriptor)object.next();
                object4 = ((EjbDescriptor)object5).getPermissionedMethodsByPermission();
                object3 = ((EjbDescriptor)object5).getStyledPermissionedMethodsByPermission();
                vector = (Vector)object4.get(MethodPermission.getExcludedMethodPermission());
                if (object3 != null && (object2 = (Collection)object3.get(MethodPermission.getExcludedMethodPermission())) != null) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.addAll(object2);
                }
                if (vector == null || vector.isEmpty()) continue;
                if (elementNode == null) {
                    elementNode = xMLUtils.getNode("exclude-list");
                    elementNode3.appendChild((Node)elementNode);
                }
                this.addMethodsTags(elementNode, vector, (EjbDescriptor)object5);
            }
        }
        if (!"".equals(ejbBundleDescriptor.getEjbClientJarUri())) {
            this.appendChild((Node)xMLUtils.getTextNode("ejb-client-jar", ejbBundleDescriptor.getEjbClientJarUri()));
        }
    }

    private void setMethodDescriptor(XMLUtils xMLUtils, Map map, ElementNode elementNode, EjbDescriptor ejbDescriptor) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            MethodPermission methodPermission = (MethodPermission)iterator.next();
            if (methodPermission.isExcluded() || (set = (Set)map.get(methodPermission)).isEmpty()) continue;
            ElementNode elementNode2 = xMLUtils.getNode("method-permission");
            elementNode.appendChild((Node)elementNode2);
            if (methodPermission.isRoleBased()) {
                elementNode2.appendChild((Node)xMLUtils.getTextNode("role-name", methodPermission.getRole().getName()));
            } else {
                elementNode2.appendChild((Node)xMLUtils.getNode("unchecked"));
            }
            this.addMethodsTags(elementNode2, set, ejbDescriptor);
        }
    }

    public EjbBundleDescriptor getDescriptor() throws ContentTransformationException {
        Object object = this;
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            EjbBundleDescriptor ejbBundleDescriptor = DescriptorEnvironment.createEjbBundleDescriptor();
            Document document = this.getOwnerDocument();
            if (document == null) {
                throw new IllegalArgumentException("Cannot set the descriptor unless this node has been  added to a document");
            }
            DocumentType documentType = document.getDoctype();
            if (documentType == null) {
                throw new RuntimeException("Invalid XML : No document type for " + document);
            }
            String string = documentType.getPublicId();
            if (string.equals(PUBLIC_DTD_ID)) {
                ejbBundleDescriptor.setEJBVersion("EJB 2.x");
            } else if (string.equals(PUBLIC_DTD_ID_12)) {
                ejbBundleDescriptor.setEJBVersion("EJB 1.x");
                _logger.log(Level.FINE, "Setting EJB version to EJB1.X...");
            } else {
                throw new RuntimeException("Invalid XML : Unknown document type : " + string + "  doctype = " + documentType);
            }
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbBundleDescriptor, DescriptorNodeUtils.EJB_STYLE);
            HashSet<EjbNode> hashSet = new HashSet<EjbNode>();
            Object object7 = XMLUtils.getNodesUnder((Node)((Object)this), EjbNode.getTags());
            while (object7.hasMoreElements()) {
                object6 = (EjbNode)((Object)object7.nextElement());
                object = object6;
                hashSet.add((EjbNode)((Object)object6));
                object5 = ((EjbNode)((Object)object6)).getDescriptor();
                ejbBundleDescriptor.addEjb((EjbDescriptor)object5);
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "ejb-client-jar")) {
                object = XMLUtils.getFirstNodeUnder((Node)((Object)this), "ejb-client-jar");
                ejbBundleDescriptor.setEjbClientJarUri(XMLUtils.getTextFor(this, "ejb-client-jar"));
            }
            this.getRelationships(ejbBundleDescriptor);
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "assembly-descriptor")) {
                Descriptor descriptor;
                Descriptor descriptor2;
                Object object8;
                Object object9;
                Object object10;
                Object object11;
                object7 = XMLUtils.getFirstNodeUnder((Node)((Object)this), "assembly-descriptor");
                object6 = XMLUtils.getNodesUnder((Node)object7, "security-role");
                while (object6.hasMoreElements()) {
                    object5 = (ElementNode)object6.nextElement();
                    object = object5;
                    object4 = "";
                    if (XMLUtils.hasNodesUnder((Node)object5, "description")) {
                        object4 = XMLUtils.getTextFor((ElementNode)object5, "description");
                    }
                    object3 = new Role(XMLUtils.getTextFor((ElementNode)object5, "role-name"));
                    ((Role)object3).setDescription((String)object4);
                    ejbBundleDescriptor.addRole((Role)object3);
                }
                if (!ejbBundleDescriptor.areResourceReferencesValid()) {
                    throw new IllegalArgumentException("Incorrectly resolved role references");
                }
                if (XMLUtils.hasNodesUnder((Node)object7, "exclude-list")) {
                    object6 = XMLUtils.getFirstNodeUnder((Node)object7, "exclude-list");
                    object = object6;
                    object5 = XMLUtils.getNodesUnder((Node)object6, "method");
                    while (object5.hasMoreElements()) {
                        object4 = (MethodDescriptorNode)((Object)object5.nextElement());
                        object3 = ((MethodDescriptorNode)((Object)object4)).getEjbName();
                        object2 = ejbBundleDescriptor.getEjbByName((String)object3);
                        object11 = ((MethodDescriptorNode)((Object)object4)).getDescriptor();
                        ((EjbDescriptor)object2).addPermissionedMethod(MethodPermission.getExcludedMethodPermission(), (MethodDescriptor)object11);
                    }
                }
                object6 = XMLUtils.getNodesUnder((Node)object7, "method-permission");
                while (object6.hasMoreElements()) {
                    object5 = (ElementNode)object6.nextElement();
                    object = object5;
                    if (XMLUtils.hasNodesUnder((Node)object5, "role-name")) {
                        object3 = XMLUtils.getNodesUnder((Node)object5, "role-name");
                        while (object3.hasMoreElements()) {
                            object2 = (ElementNode)object3.nextElement();
                            object11 = new Role(XMLUtils.getTextFor((ElementNode)object2, "role-name"));
                            object4 = new MethodPermission((Role)object11);
                            object10 = XMLUtils.getNodesUnder((Node)object5, "method");
                            while (object10.hasMoreElements()) {
                                object9 = (MethodDescriptorNode)((Object)object10.nextElement());
                                object8 = ((MethodDescriptorNode)((Object)object9)).getEjbName();
                                descriptor2 = ejbBundleDescriptor.getEjbByName((String)object8);
                                descriptor = ((MethodDescriptorNode)((Object)object9)).getDescriptor();
                                ((EjbDescriptor)descriptor2).addPermissionedMethod((MethodPermission)object4, (MethodDescriptor)descriptor);
                            }
                        }
                        continue;
                    }
                    object4 = MethodPermission.getUncheckedMethodPermission();
                    object3 = XMLUtils.getNodesUnder((Node)object5, "method");
                    while (object3.hasMoreElements()) {
                        object2 = (MethodDescriptorNode)((Object)object3.nextElement());
                        object11 = ((MethodDescriptorNode)((Object)object2)).getEjbName();
                        object10 = ejbBundleDescriptor.getEjbByName((String)object11);
                        object9 = ((MethodDescriptorNode)((Object)object2)).getDescriptor();
                        ((EjbDescriptor)object10).addPermissionedMethod((MethodPermission)object4, (MethodDescriptor)object9);
                    }
                }
                object6 = new Hashtable();
                object5 = XMLUtils.getNodesUnder((Node)object7, "container-transaction");
                while (object5.hasMoreElements()) {
                    object4 = (ElementNode)object5.nextElement();
                    object = object4;
                    object3 = "";
                    if (XMLUtils.hasNodesUnder((Node)object4, "description")) {
                        object3 = XMLUtils.getTextFor((ElementNode)object4, "description");
                    }
                    object2 = XMLUtils.getNodesUnder((Node)object4, "method");
                    while (object2.hasMoreElements()) {
                        object11 = (MethodDescriptorNode)((Object)object2.nextElement());
                        object10 = XMLUtils.getTextFor((ElementNode)object11, "method-name");
                        object9 = ((MethodDescriptorNode)((Object)object11)).getEjbName();
                        object8 = ejbBundleDescriptor.getEjbByName((String)object9);
                        descriptor2 = ((MethodDescriptorNode)((Object)object11)).getDescriptor();
                        descriptor = new ContainerTransaction(XMLUtils.getTextFor((ElementNode)object4, "trans-attribute"), (String)object3);
                        ((EjbDescriptor)object8).getMethodContainerTransactions().put(descriptor2, descriptor);
                    }
                }
            }
            object7 = hashSet.iterator();
            while (object7.hasNext()) {
                object6 = (EjbNode)((Object)object7.next());
                object5 = XMLUtils.getTextFor((ElementNode)object6, "ejb-name");
                object4 = ejbBundleDescriptor.getEjbByName((String)object5);
                object3 = XMLUtils.getNodesUnder((Node)object6, "ejb-ref");
                while (object3.hasMoreElements()) {
                    object2 = (ElementNode)object3.nextElement();
                    object = object2;
                    this.addEJBReference(ejbBundleDescriptor, (EjbDescriptor)object4, (ElementNode)object2, false);
                }
                object3 = XMLUtils.getNodesUnder((Node)object6, "ejb-local-ref");
                while (object3.hasMoreElements()) {
                    object2 = (ElementNode)object3.nextElement();
                    object = object2;
                    this.addEJBReference(ejbBundleDescriptor, (EjbDescriptor)object4, (ElementNode)object2, true);
                }
            }
            return ejbBundleDescriptor;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.log(Level.WARNING, "enterprise.deployment_illarg", illegalArgumentException);
            throw new ContentTransformationException(illegalArgumentException.getMessage(), object.toString());
        }
        catch (ContentTransformationException contentTransformationException) {
            throw contentTransformationException;
        }
        catch (Exception exception) {
            throw new ContentTransformationException(exception.getMessage(), object.toString());
        }
    }

    private void addMethodTag(ElementNode elementNode, MethodDescriptor methodDescriptor, EjbDescriptor ejbDescriptor) {
        MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
        elementNode.appendChild((Node)((Object)methodDescriptorNode));
        methodDescriptorNode.setDescriptor(methodDescriptor, ejbDescriptor);
    }

    private void addMethodsTags(ElementNode elementNode, Collection collection, EjbDescriptor ejbDescriptor) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addMethodTag(elementNode, (MethodDescriptor)iterator.next(), ejbDescriptor);
        }
    }

    private void addEJBReference(EjbBundleDescriptor ejbBundleDescriptor, EjbDescriptor ejbDescriptor, ElementNode elementNode, boolean bl) {
        String string;
        String string2;
        String string3 = "";
        if (XMLUtils.getFirstNodeUnder((Node)elementNode, "description") != null) {
            string3 = XMLUtils.getTextFor(elementNode, "description");
        }
        String string4 = XMLUtils.getTextFor(elementNode, "ejb-ref-name");
        if (bl) {
            string2 = XMLUtils.getTextFor(elementNode, "local-home");
            string = XMLUtils.getTextFor(elementNode, "local");
        } else {
            string2 = XMLUtils.getTextFor(elementNode, "home");
            string = XMLUtils.getTextFor(elementNode, "remote");
        }
        String string5 = XMLUtils.getTextFor(elementNode, "ejb-ref-type");
        if (XMLUtils.hasNodesUnder((Node)elementNode, "ejb-link")) {
            String string6 = XMLUtils.getTextFor(elementNode, "ejb-link");
            if (!ejbBundleDescriptor.hasEjbByName(string6)) {
                EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
                ejbExternalDescriptor.setName(string6);
                if (bl) {
                    ejbExternalDescriptor.setLocalHomeClassName(string2);
                    ejbExternalDescriptor.setLocalClassName(string);
                } else {
                    ejbExternalDescriptor.setHomeClassName(string2);
                    ejbExternalDescriptor.setRemoteClassName(string);
                }
                ejbExternalDescriptor.setType(string5);
                ejbExternalDescriptor.setLinkName(string6);
                EjbReferenceDescriptor ejbReferenceDescriptor = new EjbReferenceDescriptor(string4, string3, ejbExternalDescriptor, bl);
                ejbDescriptor.addEjbReferenceDescriptor(ejbReferenceDescriptor);
            } else {
                EjbDescriptor ejbDescriptor2 = ejbBundleDescriptor.getEjbByName(string6);
                if (bl) {
                    DescriptorNodeUtils.checkEjbLocalReference(ejbDescriptor2, string5, string2, string, string6);
                } else {
                    DescriptorNodeUtils.checkEjbReference(ejbDescriptor2, string5, string2, string, string6);
                }
                EjbReferenceDescriptor ejbReferenceDescriptor = new EjbReferenceDescriptor(string4, string3, ejbDescriptor2, bl);
                ejbDescriptor.addEjbReferenceDescriptor(ejbReferenceDescriptor);
            }
        } else {
            String string7 = EjbReferenceDescriptor.createUniqueNameAmongstNamedDescriptors("ExternalRef", ejbDescriptor.getEjbReferenceDescriptors());
            EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
            ejbExternalDescriptor.setName(string7);
            if (bl) {
                ejbExternalDescriptor.setLocalHomeClassName(string2);
                ejbExternalDescriptor.setLocalClassName(string);
            } else {
                ejbExternalDescriptor.setHomeClassName(string2);
                ejbExternalDescriptor.setRemoteClassName(string);
            }
            ejbExternalDescriptor.setType(string5);
            EjbReferenceDescriptor ejbReferenceDescriptor = new EjbReferenceDescriptor(string4, string3, ejbExternalDescriptor, bl);
            ejbDescriptor.addEjbReferenceDescriptor(ejbReferenceDescriptor);
        }
    }

    public void completeLoadingDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        Enumeration enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "entity");
        while (enumeration.hasMoreElements()) {
            EjbNode ejbNode = (EjbNode)((Object)enumeration.nextElement());
            String string = XMLUtils.getTextFor(ejbNode, "ejb-name");
            EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(string);
            ejbNode.completeLoadingDescriptor(ejbDescriptor);
        }
    }

    private void setRelationships(XMLUtils xMLUtils, EjbBundleDescriptor ejbBundleDescriptor) {
        if (ejbBundleDescriptor.getRelationships().size() == 0) {
            return;
        }
        ElementNode elementNode = xMLUtils.getNode("relationships");
        this.appendChild((Node)elementNode);
        if (!ejbBundleDescriptor.getRelationshipsDescription().equals("")) {
            elementNode.appendChild((Node)xMLUtils.getTextNode("description", ejbBundleDescriptor.getRelationshipsDescription()));
        }
        Iterator iterator = ejbBundleDescriptor.getRelationships().iterator();
        while (iterator.hasNext()) {
            RelationshipDescriptor relationshipDescriptor = (RelationshipDescriptor)iterator.next();
            ElementNode elementNode2 = xMLUtils.getNode("ejb-relation");
            elementNode.appendChild((Node)elementNode2);
            if (!relationshipDescriptor.getDescription().equals("")) {
                elementNode2.appendChild((Node)xMLUtils.getTextNode("description", relationshipDescriptor.getDescription()));
            }
            if (!relationshipDescriptor.getName().equals("")) {
                elementNode2.appendChild((Node)xMLUtils.getTextNode("ejb-relation-name", relationshipDescriptor.getName()));
            }
            this.storeEjbRelationRole(elementNode2, relationshipDescriptor.getSource(), xMLUtils);
            this.storeEjbRelationRole(elementNode2, relationshipDescriptor.getSink(), xMLUtils);
        }
    }

    private void storeEjbRelationRole(ElementNode elementNode, RelationRoleDescriptor relationRoleDescriptor, XMLUtils xMLUtils) {
        ElementNode elementNode2 = xMLUtils.getNode("ejb-relationship-role");
        String string = relationRoleDescriptor.getDescription();
        if (string != null && !string.equals("")) {
            elementNode2.appendChild((Node)xMLUtils.getTextNode("description", string));
        }
        elementNode2.appendChild((Node)xMLUtils.getTextNode("ejb-relationship-role-name", relationRoleDescriptor.getName()));
        elementNode2.appendChild((Node)xMLUtils.getTextNode("multiplicity", relationRoleDescriptor.getIsMany() ? "Many" : "One"));
        if (relationRoleDescriptor.getCascadeDelete()) {
            elementNode2.appendChild((Node)xMLUtils.getNode("cascade-delete"));
        }
        ElementNode elementNode3 = xMLUtils.getNode("relationship-role-source");
        if (!relationRoleDescriptor.getRoleSourceDescription().equals("")) {
            elementNode2.appendChild((Node)xMLUtils.getTextNode("description", relationRoleDescriptor.getRoleSourceDescription()));
        }
        elementNode3.appendChild((Node)xMLUtils.getTextNode("ejb-name", relationRoleDescriptor.getOwner().getName()));
        elementNode2.appendChild((Node)elementNode3);
        if (relationRoleDescriptor.getCMRField() != null) {
            ElementNode elementNode4 = xMLUtils.getNode("cmr-field");
            if (!relationRoleDescriptor.getCMRFieldDescription().equals("")) {
                elementNode4.appendChild((Node)xMLUtils.getTextNode("description", relationRoleDescriptor.getCMRFieldDescription()));
            }
            elementNode4.appendChild((Node)xMLUtils.getTextNode("cmr-field-name", relationRoleDescriptor.getCMRField()));
            String string2 = relationRoleDescriptor.getCMRFieldType();
            if (string2 != null && !string2.equals("")) {
                elementNode4.appendChild((Node)xMLUtils.getTextNode("cmr-field-type", string2));
            }
            elementNode2.appendChild((Node)elementNode4);
        }
        elementNode.appendChild((Node)elementNode2);
    }

    private void getRelationships(EjbBundleDescriptor ejbBundleDescriptor) throws ParseException {
        Object object;
        ElementNode elementNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "relationships");
        if (elementNode == null) {
            return;
        }
        if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
            object = XMLUtils.getTextFor(elementNode, "description");
            ejbBundleDescriptor.setRelationshipsDescription((String)object);
        }
        object = XMLUtils.getNodesUnder((Node)elementNode, "ejb-relation");
        while (object.hasMoreElements()) {
            Object object2;
            ElementNode elementNode2 = (ElementNode)object.nextElement();
            RelationshipDescriptor relationshipDescriptor = new RelationshipDescriptor();
            if (XMLUtils.hasNodesUnder((Node)elementNode2, "description")) {
                object2 = XMLUtils.getTextFor(elementNode2, "description");
                relationshipDescriptor.setDescription((String)object2);
            }
            if (XMLUtils.hasNodesUnder((Node)elementNode2, "ejb-relation-name")) {
                object2 = XMLUtils.getTextFor(elementNode2, "ejb-relation-name");
                relationshipDescriptor.setName((String)object2);
            }
            object2 = XMLUtils.getNodesUnder((Node)elementNode2, "ejb-relationship-role");
            ElementNode elementNode3 = (ElementNode)object2.nextElement();
            RelationRoleDescriptor relationRoleDescriptor = this.loadEjbRelationRole(elementNode3, ejbBundleDescriptor);
            elementNode3 = (ElementNode)object2.nextElement();
            RelationRoleDescriptor relationRoleDescriptor2 = this.loadEjbRelationRole(elementNode3, ejbBundleDescriptor);
            relationRoleDescriptor.setPartner(relationRoleDescriptor2);
            relationRoleDescriptor2.setPartner(relationRoleDescriptor);
            relationshipDescriptor.setSource(relationRoleDescriptor);
            relationRoleDescriptor.setRelationshipDescriptor(relationshipDescriptor);
            relationshipDescriptor.setSink(relationRoleDescriptor2);
            relationRoleDescriptor2.setRelationshipDescriptor(relationshipDescriptor);
            if (relationRoleDescriptor.getCMRField() != null && relationRoleDescriptor2.getCMRField() != null) {
                relationshipDescriptor.setIsBidirectional(true);
            } else {
                relationshipDescriptor.setIsBidirectional(false);
            }
            String string = "ERROR: Cascade-delete can only be specified if the other role has a multiplicity of One";
            if (relationRoleDescriptor.getCascadeDelete() && relationRoleDescriptor2.getIsMany()) {
                throw new EJBException(string);
            }
            if (relationRoleDescriptor2.getCascadeDelete() && relationRoleDescriptor.getIsMany()) {
                throw new EJBException(string);
            }
            ejbBundleDescriptor.addRelationship(relationshipDescriptor);
        }
    }

    private RelationRoleDescriptor loadEjbRelationRole(ElementNode elementNode, EjbBundleDescriptor ejbBundleDescriptor) throws ParseException {
        ElementNode elementNode2;
        String string;
        String string2;
        RelationRoleDescriptor relationRoleDescriptor = new RelationRoleDescriptor();
        if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
            string2 = XMLUtils.getTextFor(elementNode, "description");
            relationRoleDescriptor.setDescription(string2);
        }
        string2 = XMLUtils.getTextFor(elementNode, "ejb-relationship-role-name");
        relationRoleDescriptor.setName(string2);
        if (!XMLUtils.hasNodesUnder((Node)elementNode, "multiplicity")) {
            throw new ParseException("Multiplicity Tag not specified for Relationship Role :" + string2);
        }
        String string3 = XMLUtils.getTextFor(elementNode, "multiplicity");
        if (string3.equals("Many")) {
            relationRoleDescriptor.setIsMany(true);
        } else if (string3.equals("One")) {
            relationRoleDescriptor.setIsMany(false);
        } else {
            throw new ParseException("Illegal Multiplicity Value : " + string3 + ". Use either One or Many");
        }
        ElementNode elementNode3 = XMLUtils.getFirstNodeUnder((Node)elementNode, "relationship-role-source");
        if (XMLUtils.hasNodesUnder((Node)elementNode3, "description")) {
            string = XMLUtils.getTextFor(elementNode3, "description");
            relationRoleDescriptor.setRoleSourceDescription(string);
        }
        string = XMLUtils.getTextFor(elementNode3, "ejb-name");
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)ejbBundleDescriptor.getEjbByName(string);
        relationRoleDescriptor.setPersistenceDescriptor(ejbCMPEntityDescriptor.getPersistenceDescriptor());
        if (XMLUtils.hasNodesUnder((Node)elementNode, "cascade-delete")) {
            relationRoleDescriptor.setCascadeDelete(true);
        }
        if ((elementNode2 = XMLUtils.getFirstNodeUnder((Node)elementNode, "cmr-field")) != null) {
            if (XMLUtils.hasNodesUnder((Node)elementNode2, "description")) {
                String string4 = XMLUtils.getTextFor(elementNode2, "description");
                relationRoleDescriptor.setCMRFieldDescription(string4);
            }
            relationRoleDescriptor.setCMRField(XMLUtils.getTextFor(elementNode2, "cmr-field-name"));
            if (XMLUtils.hasNodesUnder((Node)elementNode2, "cmr-field-type")) {
                relationRoleDescriptor.setCMRFieldType(XMLUtils.getTextFor(elementNode2, "cmr-field-type"));
            }
        }
        return relationRoleDescriptor;
    }

    public static Vector readEjbBundleNodes(InputStream inputStream, boolean bl) throws ParseException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("ejb-jar", "com.sun.enterprise.deployment.xml.EjbBundleNode");
            hashtable.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            hashtable.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            hashtable.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            hashtable.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(EjbBundleNode.class, hashtable, inputStream, bl);
        }
        catch (SAXException sAXException) {
            _logger.log(Level.SEVERE, "enterprise.deployment_parser_cannot_parse", sAXException);
            throw new ParseException(sAXException);
        }
        catch (Throwable throwable) {
            throw new ParseException(throwable.getMessage());
        }
    }

    public static XmlDocument getDocument(EjbBundleDescriptor ejbBundleDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        EjbBundleNode ejbBundleNode = new EjbBundleNode();
        xmlDocument.appendChild((Node)((Object)ejbBundleNode));
        ejbBundleNode.setDescriptor(ejbBundleDescriptor);
        return xmlDocument;
    }

    public static EjbBundleNode read(InputStream inputStream, boolean bl) throws ParseException {
        Vector vector = EjbBundleNode.readEjbBundleNodes(inputStream, bl);
        if (vector.size() > 0) {
            return (EjbBundleNode)((Object)vector.elementAt(0));
        }
        throw new ParseException("No Ejb bundle nodes could be found");
    }
}

