/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConnectorNode
extends ElementNode
implements ConnectorTagNames {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/connector_1_0.dtd";
    public static String DD_BASIC_PASSWORD = "BasicPassword";
    public static String DD_KERBEROS = "Kerbv5";
    public static String DD_NO_TRANSACTION = "NoTransaction";
    public static String DD_LOCAL_TRANSACTION = "LocalTransaction";
    public static String DD_XA_TRANSACTION = "XATransaction";

    public ConnectorNode() {
        this.setTag("connector");
    }

    public void setDescriptor(ConnectorDescriptor connectorDescriptor) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils xMLUtils = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(xMLUtils, connectorDescriptor, this, DescriptorNodeUtils.CONNECTOR_STYLE);
        DescriptorNodeUtils.appendOtherDescriptorAttribs(xMLUtils, connectorDescriptor, this);
        DescriptorNodeUtils.appendResourceAdapter(xMLUtils, connectorDescriptor, this);
    }

    public ConnectorDescriptor getDescriptor() throws ContentTransformationException {
        ConnectorNode connectorNode = this;
        try {
            Object object;
            String string;
            Object object2;
            String string2;
            String string3;
            String string4;
            ConnectorDescriptor connectorDescriptor = new ConnectorDescriptor();
            connectorDescriptor.setConnectionFactoryInterface(XMLUtils.getTextFor(this, "connectionfactory-interface"));
            connectorDescriptor.setConnectionFactoryImpl(XMLUtils.getTextFor(this, "connectionfactory-impl-class"));
            connectorDescriptor.setConnectionInterface(XMLUtils.getTextFor(this, "connection-interface"));
            connectorDescriptor.setConnectionImpl(XMLUtils.getTextFor(this, "connection-impl-class"));
            connectorDescriptor.setManagedConnectionFactoryImpl(XMLUtils.getTextFor(this, "managedconnectionfactory-class"));
            String string5 = XMLUtils.getTextFor(this, "reauthentication-support");
            connectorDescriptor.setReauthenticationSupport(Boolean.valueOf(string5));
            connectorDescriptor.setName(XMLUtils.getTextFor(this, "display-name"));
            ElementNode elementNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "license");
            if (elementNode != null) {
                connectorNode = elementNode;
                string4 = XMLUtils.getTextFor(elementNode, "license-required");
                connectorDescriptor.setLicenseRequired(Boolean.valueOf(string4));
                if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
                    connectorDescriptor.setLicenseDescription(XMLUtils.getTextFor(elementNode, "description"));
                }
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "description")) {
                connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "description");
                connectorDescriptor.setConnectorDescription(XMLUtils.getTextFor(this, "description"));
            }
            connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "eis-type");
            connectorDescriptor.setEisType(XMLUtils.getTextFor(this, "eis-type"));
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "large-icon")) {
                connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "large-icon");
                connectorDescriptor.setLargeIconUri(XMLUtils.getTextFor(this, "large-icon"));
            }
            if (XMLUtils.hasNodesUnder((Node)((Object)this), "small-icon")) {
                connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "small-icon");
                connectorDescriptor.setSmallIconUri(XMLUtils.getTextFor(this, "small-icon"));
            }
            connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "spec-version");
            connectorDescriptor.setSpecVersion(XMLUtils.getTextFor(this, "spec-version"));
            connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "vendor-name");
            connectorDescriptor.setVendorName(XMLUtils.getTextFor(this, "vendor-name"));
            connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "version");
            connectorDescriptor.setVersion(XMLUtils.getTextFor(this, "version"));
            connectorNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "transaction-support");
            string4 = XMLUtils.getTextFor(this, "transaction-support");
            int n = 0;
            if (string4.equals(DD_XA_TRANSACTION)) {
                n = 2;
            } else if (string4.equals(DD_LOCAL_TRANSACTION)) {
                n = 1;
            } else if (string4.equals(DD_NO_TRANSACTION)) {
                n = 0;
            } else {
                throw new IllegalArgumentException("Invalid transaction support value");
            }
            connectorDescriptor.setTransactionSupport(n);
            Enumeration enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "config-property");
            while (enumeration.hasMoreElements()) {
                elementNode = (ElementNode)enumeration.nextElement();
                connectorNode = elementNode;
                string3 = "";
                if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
                    string3 = XMLUtils.getTextFor(elementNode, "description");
                }
                string2 = XMLUtils.getTextFor(elementNode, "config-property-type");
                object2 = XMLUtils.getTextFor(elementNode, "config-property-name");
                string = "";
                if (XMLUtils.hasNodesUnder((Node)elementNode, "config-property-value")) {
                    string = XMLUtils.getTextFor(elementNode, "config-property-value");
                }
                object = new EnvironmentProperty((String)object2, string, string3, string2);
                connectorDescriptor.addConfigProperty((EnvironmentProperty)object);
            }
            enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "security-permission");
            while (enumeration.hasMoreElements()) {
                elementNode = (ElementNode)enumeration.nextElement();
                connectorNode = elementNode;
                string3 = "";
                if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
                    string3 = XMLUtils.getTextFor(elementNode, "description");
                }
                string2 = XMLUtils.getTextFor(elementNode, "security-permission-spec");
                object2 = new SecurityPermission(string3, string2);
                connectorDescriptor.addSecurityPermission((SecurityPermission)object2);
            }
            enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "authentication-mechanism");
            while (enumeration.hasMoreElements()) {
                elementNode = (ElementNode)enumeration.nextElement();
                connectorNode = elementNode;
                string3 = "";
                if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
                    string3 = XMLUtils.getTextFor(elementNode, "description");
                }
                string2 = XMLUtils.getTextFor(elementNode, "authentication-mechanism-type");
                int n2 = 0;
                if (string2.equals(DD_BASIC_PASSWORD)) {
                    n2 = 0;
                } else if (string2.equals(DD_KERBEROS)) {
                    n2 = 1;
                } else {
                    throw new IllegalArgumentException("Invalid auth-mech-type");
                }
                string = XMLUtils.getTextFor(elementNode, "credential-interface");
                object = new AuthMechanism(string3, n2, string);
                connectorDescriptor.addAuthMechanism((AuthMechanism)object);
            }
            return connectorDescriptor;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ContentTransformationException(illegalArgumentException.getMessage(), connectorNode == null ? "" : connectorNode.toString());
        }
        catch (Exception exception) {
            throw new ContentTransformationException(exception.getMessage(), connectorNode == null ? "" : connectorNode.toString());
        }
    }

    public static Vector readConnectorNodes(InputStream inputStream, boolean bl) throws ParseException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("connector", "com.sun.enterprise.deployment.xml.ConnectorNode");
            return XMLUtils.getNodesByType(ConnectorNode.class, hashtable, inputStream, bl);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
        catch (Throwable throwable) {
            throw new ParseException(throwable.getMessage());
        }
    }

    public static XmlDocument getDocument(ConnectorDescriptor connectorDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        ConnectorNode connectorNode = new ConnectorNode();
        xmlDocument.appendChild((Node)((Object)connectorNode));
        connectorNode.setDescriptor(connectorDescriptor);
        return xmlDocument;
    }

    public static ConnectorNode read(InputStream inputStream, boolean bl) throws ParseException {
        Vector vector = ConnectorNode.readConnectorNodes(inputStream, bl);
        if (vector.size() > 0) {
            return (ConnectorNode)vector.elementAt(0);
        }
        throw new ParseException("No connector nodes could be found");
    }
}

