/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ApplicationNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    private Hashtable contextRootMap = new Hashtable();
    private Hashtable ejbBundleArchiveMap = new Hashtable();
    private Hashtable webBundleArchiveMap = new Hashtable();
    private Hashtable applicationClientDescriptorArchiveMap = new Hashtable();
    private Hashtable rarDescriptorArchiveMap = new Hashtable();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public ApplicationNode() {
        this.setTag("application");
    }

    public void setDescriptor(Application application) {
        Archivist archivist;
        Serializable serializable;
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils xMLUtils = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(xMLUtils, application, this, DescriptorNodeUtils.APP_STYLE);
        Iterator iterator = application.getArchivableDescriptors().iterator();
        while (iterator.hasNext()) {
            ElementNode elementNode;
            serializable = (BundleDescriptor)iterator.next();
            archivist = ((BundleDescriptor)serializable).getArchivist();
            ElementNode elementNode2 = xMLUtils.getNode("module");
            this.appendChild((Node)elementNode2);
            if (serializable instanceof WebBundleDescriptor) {
                elementNode = xMLUtils.getNode("web");
                elementNode2.appendChild((Node)elementNode);
                elementNode.appendChild((Node)xMLUtils.getTextNode("web-uri", ((BundleDescriptor)serializable).getArchivist().getArchiveUri()));
                elementNode.appendChild((Node)xMLUtils.getTextNode("context-root", ((WebBundleDescriptor)serializable).getContextRoot()));
            } else if (serializable instanceof EjbBundleDescriptor) {
                elementNode = xMLUtils.getTextNode("ejb", ((BundleDescriptor)serializable).getArchivist().getArchiveUri());
                elementNode2.appendChild((Node)elementNode);
            } else if (serializable instanceof ApplicationClientDescriptor) {
                elementNode = xMLUtils.getTextNode("java", ((BundleDescriptor)serializable).getArchivist().getArchiveUri());
                elementNode2.appendChild((Node)elementNode);
            } else if (serializable instanceof ConnectorDescriptor) {
                elementNode = xMLUtils.getTextNode("connector", ((BundleDescriptor)serializable).getArchivist().getArchiveUri());
                elementNode2.appendChild((Node)elementNode);
            }
            if (!archivist.hasExternalDescriptor()) continue;
            elementNode2.appendChild((Node)xMLUtils.getTextNode("alt-dd", archivist.getExternalDescriptorArchiveUri()));
        }
        iterator = application.getRoles().iterator();
        while (iterator.hasNext()) {
            serializable = (Role)iterator.next();
            archivist = xMLUtils.getNode("security-role");
            this.appendChild((Node)((Object)archivist));
            if (!"".equals(((Role)serializable).getDescription())) {
                archivist.appendChild((Node)xMLUtils.getTextNode("description", ((Role)serializable).getDescription()));
            }
            archivist.appendChild((Node)xMLUtils.getTextNode("role-name", ((PrincipalImpl)serializable).getName()));
        }
    }

    public Application getApplication(ClassLoader classLoader, String string) throws ContentTransformationException {
        ApplicationNode applicationNode = this;
        try {
            Object object;
            ElementNode elementNode;
            Application application = new Application("", new File(""));
            if (string != null) {
                application.setName(string);
                DescriptorNodeUtils.setDescriptorAttributes(this, application, DescriptorNodeUtils.APP_STYLE, false);
            } else {
                DescriptorNodeUtils.setDescriptorAttributes(this, application, DescriptorNodeUtils.APP_STYLE);
            }
            Enumeration enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "module");
            while (enumeration.hasMoreElements()) {
                String string2;
                ElementNode elementNode2;
                elementNode = (ElementNode)enumeration.nextElement();
                applicationNode = elementNode;
                object = "";
                if (XMLUtils.getFirstNodeUnder((Node)elementNode, "alt-dd") != null) {
                    object = XMLUtils.getTextFor(elementNode, "alt-dd");
                }
                if (XMLUtils.hasNodesUnder((Node)elementNode, "web")) {
                    elementNode2 = XMLUtils.getFirstNodeUnder((Node)elementNode, "web");
                    applicationNode = elementNode2;
                    string2 = XMLUtils.getTextFor(elementNode2, "web-uri");
                    String string3 = XMLUtils.getTextFor(elementNode2, "context-root");
                    this.contextRootMap.put(string2, string3);
                    this.webBundleArchiveMap.put(string2, object);
                }
                if (XMLUtils.hasNodesUnder((Node)elementNode, "ejb")) {
                    elementNode2 = XMLUtils.getFirstNodeUnder((Node)elementNode, "ejb");
                    applicationNode = elementNode2;
                    string2 = XMLUtils.getTextFor(elementNode, "ejb");
                    this.ejbBundleArchiveMap.put(string2, object);
                }
                if (XMLUtils.hasNodesUnder((Node)elementNode, "java")) {
                    elementNode2 = XMLUtils.getFirstNodeUnder((Node)elementNode, "java");
                    applicationNode = elementNode2;
                    string2 = XMLUtils.getTextFor(elementNode, "java");
                    this.applicationClientDescriptorArchiveMap.put(string2, object);
                }
                if (!XMLUtils.hasNodesUnder((Node)elementNode, "connector")) continue;
                elementNode2 = XMLUtils.getFirstNodeUnder((Node)elementNode, "connector");
                applicationNode = elementNode2;
                string2 = XMLUtils.getTextFor(elementNode, "connector");
                this.rarDescriptorArchiveMap.put(string2, object);
            }
            enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "security-role");
            while (enumeration.hasMoreElements()) {
                elementNode = (ElementNode)enumeration.nextElement();
                applicationNode = elementNode;
                object = new Role(XMLUtils.getTextFor(elementNode, "role-name"));
                if (XMLUtils.hasNodesUnder((Node)elementNode, "description")) {
                    ((Role)object).setDescription(XMLUtils.getTextFor(elementNode, "description"));
                }
                application.addRole((Role)object);
            }
            return application;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.log(Level.WARNING, "enterprise.deployment_illarg", illegalArgumentException);
            throw new ContentTransformationException(illegalArgumentException.getMessage(), applicationNode == null ? "" : applicationNode.toString());
        }
        catch (Exception exception) {
            throw new ContentTransformationException(exception.getMessage(), applicationNode == null ? "" : applicationNode.toString());
        }
    }

    public Hashtable getEjbBundleArchiveMap() {
        return this.ejbBundleArchiveMap;
    }

    public Hashtable getWebBundleArchiveMap() {
        return this.webBundleArchiveMap;
    }

    public Hashtable getApplicationClientDescriptorArchiveMap() {
        return this.applicationClientDescriptorArchiveMap;
    }

    public Hashtable getRarDescriptorArchiveMap() {
        return this.rarDescriptorArchiveMap;
    }

    public static void resolveInterJarEjbReferences(Application application) {
        Enumeration enumeration = application.getEjbReferenceDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            EjbReferenceDescriptor ejbReferenceDescriptor = (EjbReferenceDescriptor)enumeration.nextElement();
            if (!EjbReferenceDescriptor.INTERNAL_UNRESOLVED_STATE.equals(ejbReferenceDescriptor.getState())) continue;
            String string = ejbReferenceDescriptor.getHomeClassName();
            String string2 = ejbReferenceDescriptor.getBeanClassName();
            String string3 = ejbReferenceDescriptor.getLinkName();
            int n = string3.lastIndexOf(35);
            if (n != -1) {
                object = string3.substring(n + 1);
                String string4 = string3.substring(0, n);
                BundleDescriptor bundleDescriptor = ejbReferenceDescriptor.getReferringBundleDescriptor();
                String string5 = bundleDescriptor.getArchivist().getArchiveUri();
                int n2 = string5.lastIndexOf(47);
                String string6 = string5.substring(0, n2 + 1) + string4;
                EjbBundleDescriptor ejbBundleDescriptor = application.getEjbBundleByUri(string6);
                EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName((String)object);
                ejbReferenceDescriptor.setEjbDescriptor(ejbDescriptor);
            } else if (application.hasEjbByName(string3)) {
                object = application.getEjbByName(ejbReferenceDescriptor.getLinkName());
                ejbReferenceDescriptor.setEjbDescriptor((EjbAbstractDescriptor)object);
            } else {
                throw new RuntimeException("Error: Unresolved <ejb-link>: " + string3);
            }
            if (!string.equals(ejbReferenceDescriptor.getHomeClassName()) && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "WARNING " + string3 + " ejb-ref expected home interface to be " + string + " and got " + ejbReferenceDescriptor.getHomeClassName());
            }
            if (string2.equals(ejbReferenceDescriptor.getBeanClassName()) || !_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "WARNING" + string3 + " ejb-ref expected bean interface to be " + string2 + " and got " + ejbReferenceDescriptor.getBeanClassName());
        }
    }

    public String getContextRootFor(String string) {
        if (this.contextRootMap.get(string) != null) {
            return (String)this.contextRootMap.get(string);
        }
        throw new RuntimeException("Cannot find context root for web bundle with entry " + string + " in this ear");
    }

    public static Vector readApplicationNodes(InputStream inputStream, boolean bl) throws ParseException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(RuntimeDescriptorNode.RUNTIME_TAG, "com.sun.enterprise.deployment.xml.RuntimeDescriptorNode");
            hashtable.put("application", "com.sun.enterprise.deployment.xml.ApplicationNode");
            Vector vector = XMLUtils.getNodesByType(ApplicationNode.class, hashtable, inputStream, bl);
            return vector;
        }
        catch (SAXException sAXException) {
            _logger.log(Level.SEVERE, "enterprise.deployment_parser_cannot_parse", sAXException);
            throw new ParseException(sAXException);
        }
        catch (Throwable throwable) {
            throw new ParseException(throwable.getMessage());
        }
    }

    public static ApplicationNode read(InputStream inputStream, boolean bl) throws ParseException {
        Vector vector = ApplicationNode.readApplicationNodes(inputStream, bl);
        if (vector.size() > 0) {
            return (ApplicationNode)((Object)vector.elementAt(0));
        }
        throw new ParseException("No application nodes were found");
    }

    public static RuntimeDescriptorNode readRtdn(InputStream inputStream, boolean bl) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(RuntimeDescriptorNode.RUNTIME_TAG, "com.sun.enterprise.util.xml.RuntimeDescriptorNode");
            Vector vector = XMLUtils.getNodesByType(RuntimeDescriptorNode.class, hashtable, inputStream, bl);
            return (RuntimeDescriptorNode)((Object)vector.elementAt(0));
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_node_runtime", throwable);
            return null;
        }
    }

    public static XmlDocument getDocument(Application application) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        ApplicationNode applicationNode = new ApplicationNode();
        xmlDocument.appendChild((Node)((Object)applicationNode));
        applicationNode.setDescriptor(application);
        return xmlDocument;
    }
}

