/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.logging.LogDomains;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;

public class ApplicationClientRuntimeDescriptorNode
extends ElementNode {
    public static String RUNTIME_TAG = "j2ee-ri-specific-information";
    private static String APPLICATION_CLIENT = "app-client";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public ApplicationClientRuntimeDescriptorNode() {
        this.setTag(RUNTIME_TAG);
    }

    public void setDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        ElementNode elementNode;
        EnvironmentProperty environmentProperty;
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils xMLUtils = new XMLUtils(this.getOwnerDocument());
        ElementNode elementNode2 = xMLUtils.getNode(APPLICATION_CLIENT);
        this.appendChild((Node)elementNode2);
        Iterator iterator = applicationClientDescriptor.getResourceReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (ResourceReferenceDescriptor)iterator.next();
            elementNode = RuntimeDescriptorNode.getResourceReferenceNodeFor((ResourceReferenceDescriptor)environmentProperty, xMLUtils);
            elementNode2.appendChild((Node)elementNode);
        }
        iterator = applicationClientDescriptor.getEjbReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            environmentProperty = (EjbReferenceDescriptor)iterator.next();
            elementNode = xMLUtils.getNode("ejb-ref");
            elementNode2.appendChild((Node)elementNode);
            elementNode.appendChild((Node)xMLUtils.getTextNode("ejb-ref-name", environmentProperty.getName()));
            elementNode.appendChild((Node)xMLUtils.getTextNode("jndi-name", ((EjbReferenceDescriptor)environmentProperty).getJndiName()));
        }
        RuntimeDescriptorNode.setJmsDestinationReferenceInfo(applicationClientDescriptor, xMLUtils, elementNode2);
    }

    public void updateRuntimeInformation(ApplicationClientDescriptor applicationClientDescriptor) throws ContentTransformationException {
        try {
            EnvironmentProperty environmentProperty;
            String string;
            ElementNode elementNode;
            Enumeration enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "resource-ref");
            while (enumeration.hasMoreElements()) {
                elementNode = (ElementNode)enumeration.nextElement();
                string = XMLUtils.getTextFor(elementNode, "res-ref-name");
                environmentProperty = applicationClientDescriptor.getResourceReferenceByName(string);
                RuntimeDescriptorNode.updateResourceReference((ResourceReferenceDescriptor)environmentProperty, elementNode);
            }
            enumeration = XMLUtils.getNodesUnder((Node)((Object)this), "ejb-ref");
            while (enumeration.hasMoreElements()) {
                elementNode = (ElementNode)enumeration.nextElement();
                string = XMLUtils.getTextFor(elementNode, "ejb-ref-name");
                environmentProperty = applicationClientDescriptor.getEjbReferenceByName(string);
                ((EjbReferenceDescriptor)environmentProperty).setJndiName(XMLUtils.getTextFor(elementNode, "jndi-name"));
            }
            RuntimeDescriptorNode.updateJmsDestinationReferences(applicationClientDescriptor, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ContentTransformationException(illegalArgumentException.getMessage(), this.toString());
        }
    }

    public static Vector readRuntimeNodes(InputStream inputStream) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(RUNTIME_TAG, "com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode");
            return XMLUtils.getNodesByType(ApplicationClientRuntimeDescriptorNode.class, hashtable, inputStream, false);
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_node_runtime", throwable);
            return new Vector();
        }
    }

    public static ApplicationClientRuntimeDescriptorNode read(InputStream inputStream) {
        Vector vector = ApplicationClientRuntimeDescriptorNode.readRuntimeNodes(inputStream);
        if (vector == null) {
            return null;
        }
        ApplicationClientRuntimeDescriptorNode applicationClientRuntimeDescriptorNode = (ApplicationClientRuntimeDescriptorNode)((Object)vector.elementAt(0));
        return applicationClientRuntimeDescriptorNode;
    }

    public static XmlDocument getDocument(ApplicationClientDescriptor applicationClientDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(RuntimeDescriptorNode.PUBLIC_DTD_ID, RuntimeDescriptorNode.SYSTEM_ID, null);
        ApplicationClientRuntimeDescriptorNode applicationClientRuntimeDescriptorNode = new ApplicationClientRuntimeDescriptorNode();
        xmlDocument.appendChild((Node)((Object)applicationClientRuntimeDescriptorNode));
        applicationClientRuntimeDescriptorNode.setDescriptor(applicationClientDescriptor);
        return xmlDocument;
    }
}

