/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.web;

import com.sun.enterprise.deployment.WebDescriptorFactoryImpl;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.Constants;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.Tag;
import com.sun.enterprise.deployment.web.TagAttribute;
import com.sun.enterprise.deployment.web.TagLib;
import com.sun.enterprise.deployment.web.TagLibValidator;
import com.sun.enterprise.deployment.web.TagVariable;
import com.sun.enterprise.deployment.web.WebDescriptorFactory;
import com.sun.enterprise.deployment.xml.XMLParser;
import com.sun.enterprise.deployment.xml.XMLTree;
import com.sun.logging.LogDomains;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TagLibReader {
    private WebDescriptorFactory factory = null;
    private static final boolean DefaultXMLValidation = true;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$InitializationParameter;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$AppListenerDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$TagVariable;

    public TagLib getDescriptor(InputStream inputStream, WebDescriptorFactory webDescriptorFactory) throws Exception {
        return this.getDescriptor(inputStream, webDescriptorFactory, true);
    }

    public TagLib getDescriptor(InputStream inputStream, WebDescriptorFactory webDescriptorFactory, boolean bl) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("null inputStream");
        }
        if (webDescriptorFactory == null) {
            throw new NullPointerException("null factory");
        }
        this.factory = webDescriptorFactory;
        XMLTree xMLTree = null;
        XMLParser xMLParser = new XMLParser();
        try {
            xMLTree = xMLParser.process(inputStream, bl);
        }
        catch (Exception exception) {
            throw new IllegalStateException("can't read tld: " + exception.getMessage());
        }
        TagLib tagLib = null;
        try {
            if (!xMLTree.getName().equals("taglib")) {
                throw new IllegalStateException("'taglib' not found");
            }
            XMLTree xMLTree2 = xMLTree.getFirstElement("short-name");
            boolean bl2 = xMLTree2 != null;
            tagLib = bl2 ? this.processTagLib12(xMLTree) : this.processTagLib11(xMLTree);
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_parsing_error", throwable);
            throw new Exception("parsing error: " + throwable.getMessage());
        }
        return tagLib;
    }

    private TagLib processTagLib11(XMLTree xMLTree) {
        TagLib tagLib = (TagLib)this.factory.createDescriptor(TagLib.class);
        XMLTree xMLTree2 = xMLTree.getFirstElement("tlibversion");
        tagLib.setTagLibVersion(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("jspversion");
        if (xMLTree2 != null) {
            tagLib.setJspVersion(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("shortname")) != null) {
            tagLib.setName(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("uri")) != null) {
            tagLib.setUri(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("info")) != null) {
            tagLib.setDescription(xMLTree2.getValue());
        }
        Enumeration enumeration = xMLTree.elements("tag");
        while (enumeration.hasMoreElements()) {
            tagLib.addTag(this.processTag11((XMLTree)enumeration.nextElement()));
        }
        return tagLib;
    }

    private Tag processTag11(XMLTree xMLTree) {
        Tag tag = (Tag)this.factory.createDescriptor(Tag.class);
        XMLTree xMLTree2 = xMLTree.getFirstElement("name");
        tag.setName(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("tagclass");
        tag.setTagClass(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("teiclass");
        if (xMLTree2 != null) {
            tag.setTagExtraInfoClass(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("bodycontent")) != null) {
            tag.setBodyContent(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("info")) != null) {
            tag.setDescription(xMLTree2.getValue());
        }
        Enumeration enumeration = xMLTree.elements("attribute");
        while (enumeration.hasMoreElements()) {
            XMLTree xMLTree3 = (XMLTree)enumeration.nextElement();
            tag.addTagAttribute(this.processTagAttribute(xMLTree3));
        }
        return tag;
    }

    private TagLib processTagLib12(XMLTree xMLTree) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TagLib tagLib = (TagLib)this.factory.createDescriptor(TagLib.class);
        XMLTree xMLTree2 = xMLTree.getFirstElement("tlib-version");
        tagLib.setTagLibVersion(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("jsp-version");
        if (xMLTree2 != null) {
            tagLib.setJspVersion(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("short-name")) != null) {
            tagLib.setName(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("uri")) != null) {
            tagLib.setUri(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.TagLib12_DISPLAYNAME)) != null) {
            tagLib.setDisplayName(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.TagLib12_SMALLICON)) != null) {
            tagLib.setSmallIconUri(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.TagLib12_LARGEICON)) != null) {
            tagLib.setLargeIconUri(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.TagLib12_DESCRIPTION)) != null) {
            tagLib.setDescription(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("validator")) != null) {
            object4 = (TagLibValidator)this.factory.createDescriptor(TagLibValidator.class);
            object3 = xMLTree2.getFirstElement("validator-class");
            object4.setValidatorClass(((XMLTree)object3).getValue());
            object2 = xMLTree2.elements("init-param");
            while (object2.hasMoreElements()) {
                object = (XMLTree)object2.nextElement();
                InitializationParameter initializationParameter = (InitializationParameter)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$InitializationParameter == null ? TagLibReader.class$("com.sun.enterprise.deployment.web.InitializationParameter") : class$com$sun$enterprise$deployment$web$InitializationParameter);
                XMLTree xMLTree3 = ((XMLTree)object).getFirstElement("param-name");
                initializationParameter.setName(xMLTree3.getValue());
                xMLTree3 = ((XMLTree)object).getFirstElement("param-value");
                initializationParameter.setValue(xMLTree3.getValue());
                xMLTree3 = ((XMLTree)object).getFirstElement(Constants.DESCRIPTION);
                if (xMLTree3 != null) {
                    initializationParameter.setDescription(xMLTree3.getValue());
                }
                object4.addParameter(initializationParameter);
            }
            tagLib.setValidator((TagLibValidator)object4);
        }
        object4 = xMLTree.elements(Constants.TagLib12_LISTENER);
        while (object4.hasMoreElements()) {
            object3 = (XMLTree)object4.nextElement();
            object = (AppListenerDescriptor)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$AppListenerDescriptor == null ? TagLibReader.class$("com.sun.enterprise.deployment.web.AppListenerDescriptor") : class$com$sun$enterprise$deployment$web$AppListenerDescriptor);
            object2 = ((XMLTree)object3).getFirstElement(Constants.TagList12_CLASS);
            object.setListener(((XMLTree)object2).getValue());
            tagLib.addListener((AppListenerDescriptor)object);
        }
        object3 = xMLTree.elements("tag");
        while (object3.hasMoreElements()) {
            tagLib.addTag(this.processTag12((XMLTree)object3.nextElement()));
        }
        return tagLib;
    }

    private Tag processTag12(XMLTree xMLTree) {
        Object object;
        Object object2;
        Tag tag = (Tag)this.factory.createDescriptor(Tag.class);
        XMLTree xMLTree2 = xMLTree.getFirstElement("name");
        tag.setName(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("tag-class");
        tag.setTagClass(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("tei-class");
        if (xMLTree2 != null) {
            tag.setTagExtraInfoClass(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement("body-content")) != null) {
            tag.setBodyContent(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.Tag12_DISPLAYNAME)) != null) {
            tag.setDisplayName(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.Tag12_SMALLICON)) != null) {
            tag.setSmallIconUri(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.Tag12_LARGEICON)) != null) {
            tag.setLargeIconUri(xMLTree2.getValue());
        }
        if ((xMLTree2 = xMLTree.getFirstElement(Constants.Tag12_DESCRIPTION)) != null) {
            tag.setDescription(xMLTree2.getValue());
        }
        Enumeration enumeration = xMLTree.elements("variable");
        while (enumeration.hasMoreElements()) {
            object2 = (XMLTree)enumeration.nextElement();
            object = (TagVariable)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$TagVariable == null ? TagLibReader.class$("com.sun.enterprise.deployment.web.TagVariable") : class$com$sun$enterprise$deployment$web$TagVariable);
            xMLTree2 = ((XMLTree)object2).getFirstElement("name-given");
            if (xMLTree2 != null) {
                object.setGivenName(xMLTree2.getValue());
            } else {
                xMLTree2 = ((XMLTree)object2).getFirstElement("name-from-attribute");
                object.setAttributeName(xMLTree2.getValue());
            }
            xMLTree2 = xMLTree.getFirstElement("variable-class");
            if (xMLTree2 != null) {
                object.setVariableClass(xMLTree2.getValue());
            }
            if ((xMLTree2 = xMLTree.getFirstElement("declare")) != null) {
                object.setIsDeclared(true);
            } else {
                object.setIsDeclared(false);
            }
            xMLTree2 = xMLTree.getFirstElement("scope");
            if (xMLTree2 != null) {
                object.setScope(xMLTree2.getValue());
            }
            tag.addTagVariable((TagVariable)object);
        }
        object2 = xMLTree.elements("attribute");
        while (object2.hasMoreElements()) {
            object = (XMLTree)object2.nextElement();
            tag.addTagAttribute(this.processTagAttribute((XMLTree)object));
        }
        return tag;
    }

    private TagAttribute processTagAttribute(XMLTree xMLTree) {
        TagAttribute tagAttribute = (TagAttribute)this.factory.createDescriptor(TagAttribute.class);
        XMLTree xMLTree2 = xMLTree.getFirstElement("name");
        tagAttribute.setName(xMLTree2.getValue());
        xMLTree2 = xMLTree.getFirstElement("required");
        if (xMLTree2 != null) {
            tagAttribute.setIsRequired(this.booleanValue(xMLTree2.getValue()));
        }
        if ((xMLTree2 = xMLTree.getFirstElement("rtexprvalue")) != null) {
            tagAttribute.setAllowsScriptletExpressions(this.booleanValue(xMLTree2.getValue()));
        }
        if ((xMLTree2 = xMLTree.getFirstElement("type")) != null) {
            tagAttribute.setType(xMLTree2.getValue());
        }
        return tagAttribute;
    }

    private boolean booleanValue(String string) {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
            return true;
        }
        if (!string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no")) {
            throw new RuntimeException("Invalid value");
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            TagLibReader tagLibReader = new TagLibReader();
            TagLib tagLib = tagLibReader.getDescriptor(fileInputStream, new WebDescriptorFactoryImpl(), false);
            System.out.println(tagLib.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

