/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.deployment.Utils;
import com.iplanet.ias.deployment.WebBundleXmlReader;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.TagLibDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebDescriptorFactoryImpl;
import com.sun.enterprise.deployment.web.TagLibReader;
import com.sun.enterprise.deployment.web.WebApplicationReader;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class WebBundleArchivist
extends Archivist {
    public static final String DESTINATION_CLASSES = "WEB-INF" + File.separator + "classes";
    private static String WEB_INF = "WEB-INF/";
    public static String SERVLET_ENTRY_ROOT = WEB_INF + "classes";
    public static String DEPLOYMENT_DESCRIPTOR_ENTRY = WEB_INF + "web.xml";
    public static String LIBRARY_ENTRY_ROOT = WEB_INF + "lib";
    private WebBundleDescriptor webBundleDescriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebBundleArchivist.class);
    public static String IAS_DEPLOYMENT_DESCRIPTOR_ENTRY = "WEB-INF/sun-web.xml";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public WebBundleArchivist(String string, WebBundleDescriptor webBundleDescriptor) {
        this(true, string, webBundleDescriptor);
    }

    public WebBundleArchivist(boolean bl, String string, WebBundleDescriptor webBundleDescriptor) {
        super(string, bl);
        this.webBundleDescriptor = webBundleDescriptor;
        this.webBundleDescriptor.setArchivist(this);
    }

    public Descriptor getDescriptor() {
        return this.webBundleDescriptor;
    }

    public static boolean isWebBundle(File file) throws IOException {
        WebBundleArchivist.checkExists(file);
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean bl = zipEntry != null;
        jarFile.close();
        return bl;
    }

    protected File getArchiveFile() throws IOException {
        File file = this.getWebJarFile();
        Application application = this.webBundleDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist applicationArchivist = application.getApplicationArchivist();
            File file2 = applicationArchivist.getApplicationFile();
            file = WebBundleArchivist.getWebTemp(WebBundleArchivist.getDirectory(file2));
            applicationArchivist.extractBundleToFile(this.webBundleDescriptor, file);
            file.deleteOnExit();
        }
        return file;
    }

    public void writeDeploymentInfo(ZipOutputStream zipOutputStream) throws IOException {
        this.writeDeploymentInfo(zipOutputStream, DEPLOYMENT_DESCRIPTOR_ENTRY);
    }

    public void writeDeploymentInfo(ZipOutputStream zipOutputStream, String string) throws IOException {
        WebBundleArchivist.writeDocumentToJar((Document)WebBundleNode.getDocument(this.webBundleDescriptor), string, zipOutputStream);
    }

    public void updateFiles(Hashtable hashtable) throws IOException {
        super.updateFiles(hashtable);
        this.webBundleDescriptor.changed();
    }

    public void removeEntries(Vector vector) throws IOException {
        super.removeEntries(vector);
        this.webBundleDescriptor.changed();
    }

    private static Set getContentFilesToAdd(Vector vector, String string) throws IOException {
        Set set = new HashSet();
        if (vector != null) {
            set.addAll(vector);
        } else {
            File file = new File(string);
            if (file.exists()) {
                set = FileUtil.getAllFilesUnder(new File(string), null);
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("warning.static_content.packaged", "", new Object[]{string}));
            }
        }
        return set;
    }

    private static Set getClassFilesToAdd(String string) throws IOException {
        Set set = new HashSet();
        if (string != null) {
            set = FileUtil.getAllFilesUnder(new File(string), null);
        }
        return set;
    }

    private static void writeEntry(String string, FileInputStream fileInputStream, ZipOutputStream zipOutputStream, File file) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        fileInputStream = new FileInputStream(file);
        zipOutputStream.putNextEntry(zipEntry);
        ApplicationArchivist.copy(fileInputStream, zipOutputStream);
        fileInputStream.close();
        zipOutputStream.closeEntry();
    }

    private static void checkJspFileIncluded(WebBundleDescriptor webBundleDescriptor, FileContentsDescriptor fileContentsDescriptor) throws IOException {
        Iterator iterator = webBundleDescriptor.getJspDescriptors().iterator();
        while (iterator.hasNext()) {
            JspDescriptorImpl jspDescriptorImpl = (JspDescriptorImpl)iterator.next();
            String string = jspDescriptorImpl.getJspFileName();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (fileContentsDescriptor.getFilesSet().contains(new File(string))) continue;
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptiondeploymentdescriptor", "The deployment descriptor declares the jsp with filename attribute: {0} but it is not present in: {1}", new Object[]{jspDescriptorImpl.getJspFileName(), fileContentsDescriptor}));
        }
    }

    public Vector getClassNames() throws IOException {
        Vector vector = super.getClassEntryNames();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (!string.startsWith(SERVLET_ENTRY_ROOT)) continue;
            int n = SERVLET_ENTRY_ROOT.length() + 1;
            String string2 = string.substring(n);
            String string3 = FileUtil.classNameFromEntryName(string2);
            vector2.add(string3);
        }
        return vector2;
    }

    public Vector getJspFileNames() throws IOException {
        Vector vector = super.getEntryNames();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (!string.endsWith(".jsp")) continue;
            vector2.add(string);
        }
        return vector2;
    }

    public boolean isDeletable(String string) {
        boolean bl = true;
        if (string.equals("META-INF/MANIFEST.MF") || string.equals(DEPLOYMENT_DESCRIPTOR_ENTRY)) {
            bl = false;
        }
        return bl;
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fileContentsDescriptor, FileContentsDescriptor fileContentsDescriptor2) throws IOException {
        Hashtable hashtable = this.createStaticEntryNameMap(fileContentsDescriptor2);
        Hashtable hashtable2 = this.createClassEntryNameMap(fileContentsDescriptor);
        hashtable.putAll(hashtable2);
        hashtable.remove(DEPLOYMENT_DESCRIPTOR_ENTRY);
        return hashtable;
    }

    private Hashtable createStaticEntryNameMap(FileContentsDescriptor fileContentsDescriptor) throws IOException {
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        Hashtable hashtable2 = fileContentsDescriptor.getEntryNameMap();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file = (File)hashtable2.get(string);
            if (string.endsWith(".tld") && !string.startsWith(WEB_INF)) {
                string = WEB_INF + string;
            }
            hashtable.put(string, file);
        }
        return hashtable;
    }

    private Hashtable createClassEntryNameMap(FileContentsDescriptor fileContentsDescriptor) throws IOException {
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        Hashtable hashtable2 = fileContentsDescriptor.getEntryNameMap();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file = (File)hashtable2.get(string);
            if (string.endsWith(".class")) {
                if (!string.startsWith(SERVLET_ENTRY_ROOT + "/")) {
                    string = SERVLET_ENTRY_ROOT + "/" + string;
                }
            } else if (string.endsWith(".jar")) {
                if (!string.startsWith(LIBRARY_ENTRY_ROOT + "/")) {
                    string = LIBRARY_ENTRY_ROOT + "/" + string;
                }
            } else if (!string.startsWith(SERVLET_ENTRY_ROOT + "/")) {
                string = SERVLET_ENTRY_ROOT + "/" + string;
            }
            hashtable.put(string, file);
        }
        return hashtable;
    }

    public static void createPackage(FileContentsDescriptor fileContentsDescriptor, FileContentsDescriptor fileContentsDescriptor2, File file, File file2) throws IOException, ArchiveException {
        _logger.log(Level.FINE, "FileContentsDescriptor is :" + fileContentsDescriptor2);
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptioncannotpackagewebapp", "Cannot package web application: {0} does not exist.", new Object[]{file}));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        WebDescriptorFactoryImpl webDescriptorFactoryImpl = new WebDescriptorFactoryImpl();
        WebApplicationReader webApplicationReader = new WebApplicationReader();
        WebBundleDescriptor webBundleDescriptor = null;
        try {
            webBundleDescriptor = (WebBundleDescriptor)webApplicationReader.getDescriptor(fileInputStream, webDescriptorFactoryImpl, false);
        }
        catch (Throwable throwable) {
            fileInputStream.close();
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptoinreadingwebxml", "Error reading web xml: {0}", new Object[]{throwable.getMessage()}));
        }
        if (webBundleDescriptor != null) {
            String string;
            File file3;
            File file4;
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            WebBundleArchivist webBundleArchivist = new WebBundleArchivist(file2.toString(), webBundleDescriptor);
            Enumeration enumeration = fileContentsDescriptor2.getFiles();
            while (enumeration.hasMoreElements()) {
                file4 = (File)enumeration.nextElement();
                file3 = fileContentsDescriptor2.getFullFileFor(file4);
                string = file4.toString().replace(File.separatorChar, '/');
                if (DEPLOYMENT_DESCRIPTOR_ENTRY.equals(string)) continue;
                WebBundleArchivist.writeEntry(string, fileInputStream, zipOutputStream, file3);
            }
            fileInputStream.close();
            WebBundleArchivist.checkJspFileIncluded(webBundleDescriptor, fileContentsDescriptor2);
            enumeration = fileContentsDescriptor.getFiles();
            while (enumeration.hasMoreElements()) {
                file4 = (File)enumeration.nextElement();
                file3 = fileContentsDescriptor.getFullFileFor(file4);
                string = "";
                string = file4.toString().endsWith(".class") ? SERVLET_ENTRY_ROOT + "/" + file4.toString().replace(File.separatorChar, '/') : (file4.toString().endsWith(".jar") ? LIBRARY_ENTRY_ROOT + "/" + file4.toString().replace(File.separatorChar, '/') : SERVLET_ENTRY_ROOT + "/" + file4.getName());
                if (DEPLOYMENT_DESCRIPTOR_ENTRY.equals(string)) continue;
                WebBundleArchivist.writeEntry(string, fileInputStream, zipOutputStream, file3);
            }
            webBundleArchivist.writeDeploymentInfo(zipOutputStream);
            zipOutputStream.close();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.createdwebapp", "Created WebApplication {0}", new Object[]{file2}));
            }
        }
    }

    public static void createPackage(String string, Vector vector, Vector vector2, String string2, Vector vector3, String string3, String string4) throws IOException, ArchiveException {
        vector3 = new Vector(WebBundleArchivist.getContentFilesToAdd(vector3, string2));
        if (vector == null) {
            vector = new Vector(WebBundleArchivist.getClassFilesToAdd(string));
        }
        FileContentsDescriptor fileContentsDescriptor = null;
        fileContentsDescriptor = string == null ? new FileContentsDescriptor() : new FileContentsDescriptor(string, vector);
        FileContentsDescriptor fileContentsDescriptor2 = new FileContentsDescriptor(string2, vector3);
        WebBundleArchivist.createPackage(fileContentsDescriptor, fileContentsDescriptor2, new File(string3), new File(string4));
    }

    public File getWebJarFile() {
        return new File(this.getArchiveUri());
    }

    void save(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        File file2 = WebBundleArchivist.getWebTemp(WebBundleArchivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, string);
        } else {
            this.writeDeploymentInfo(zipOutputStream, string);
        }
        Manifest manifest = new Manifest();
        WebBundleArchivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl = file2.renameTo(file);
        if (!bl) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, file.toString());
    }

    public void save(File file) throws IOException {
        this.save(file, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    public static WebBundleDescriptor open(File file) throws IOException, ArchiveException {
        try {
            return WebBundleArchivist.open(file, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static WebBundleDescriptor open(File file, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionwebfiledoesnotexist", "{0} does not exist", new Object[]{file}));
        }
        ZipFile zipFile = new ZipFile(file);
        WebBundleDescriptor webBundleDescriptor = WebBundleArchivist.open(file, DEPLOYMENT_DESCRIPTOR_ENTRY, zipFile, bl);
        zipFile.close();
        return webBundleDescriptor;
    }

    static WebBundleDescriptor open(File file, String string, ZipFile zipFile) throws IOException, ArchiveException {
        try {
            return WebBundleArchivist.open(file, string, zipFile, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    static WebBundleDescriptor open(File file, String string, ZipFile zipFile, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionwebfiledoesnotexist", "{0} does not exist", new Object[]{file}));
        }
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry != null) {
            Object object;
            if (bl) {
                WebBundleArchivist.validate(zipFile.getInputStream(zipEntry));
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            WebApplicationReader webApplicationReader = new WebApplicationReader();
            WebBundleDescriptor webBundleDescriptor = null;
            try {
                webBundleDescriptor = (WebBundleDescriptor)webApplicationReader.getDescriptor(inputStream, new WebDescriptorFactoryImpl(), false);
                inputStream.close();
            }
            catch (Throwable throwable) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionparsingdescriptor", "Error parsing descriptor: {0}", new Object[]{throwable.getMessage()}));
            }
            WebDescriptorFactoryImpl webDescriptorFactoryImpl = new WebDescriptorFactoryImpl();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                String string2 = ((ZipEntry)object).getName();
                if (!string2.startsWith(WEB_INF) || !string2.endsWith(".tld")) continue;
                try {
                    InputStream inputStream2;
                    block10: {
                        inputStream2 = zipFile.getInputStream((ZipEntry)object);
                        try {
                            TagLibReader tagLibReader = new TagLibReader();
                            TagLibDescriptor tagLibDescriptor = (TagLibDescriptor)tagLibReader.getDescriptor(inputStream2, webDescriptorFactoryImpl, false);
                            webBundleDescriptor.addTagLib(tagLibDescriptor);
                        }
                        catch (Throwable throwable) {
                            if (!_logger.isLoggable(Level.FINE)) break block10;
                            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.unabletoloadtld", "Unable to load TLD {0}\n {1}", new Object[]{string2, throwable.toString()}));
                        }
                    }
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.unabletoreadtld", "Unable to open TLD {0}\n {1}", new Object[]{string2, iOException.toString()}));
                }
            }
            object = new WebBundleArchivist(file.toString(), webBundleDescriptor);
            webBundleDescriptor.setArchivist((Archivist)object);
            return webBundleDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeploymentinfo", "No deployment info found at: {0} in {1}", new Object[]{string, zipFile.getName()}));
    }

    public void addWebJar(File file) throws IOException, ArchiveException {
        WebBundleDescriptor webBundleDescriptor = WebBundleArchivist.open(file);
        this.webBundleDescriptor.addWebBundleDescriptor(webBundleDescriptor);
        File file2 = WebBundleArchivist.createTempFile(WebBundleArchivist.getDirectory(this.getWebJarFile()));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        Vector<String> vector = new Vector<String>();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement("META-INF/MANIFEST.MF");
        JarFile jarFile = new JarFile(this.getWebJarFile());
        JarFile jarFile2 = new JarFile(file);
        WebBundleArchivist.addJarToOutput(zipOutputStream, jarFile, vector);
        WebBundleArchivist.addJarToOutput(zipOutputStream, jarFile2, vector);
        this.writeDeploymentInfo(zipOutputStream);
        Manifest manifest = super.createManifest();
        WebBundleArchivist.writeManifest(manifest, zipOutputStream);
        zipOutputStream.close();
        fileOutputStream.close();
        if (!file2.renameTo(this.getWebJarFile())) {
            _logger.log(Level.FINE, "Error renaming JAR");
        }
    }

    protected void makeArchiveClassLoadable(JarInputStream jarInputStream, AbstractArchive abstractArchive) throws IOException {
    }

    public String toString() {
        return "WebBundleArchivist " + this.getArchiveUri();
    }

    static WebBundleDescriptor open(File file, String string, JarFile jarFile, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        WebBundleDescriptor webBundleDescriptor = WebBundleArchivist.open(file, string, jarFile, bl);
        if (bl2 && webBundleDescriptor != null) {
            String string2 = Utils.getSunDescriptorName(string);
            SunWebApp sunWebApp = WebBundleArchivist.createSunWebApp(jarFile, string2, false);
            webBundleDescriptor.setSunDescriptor(sunWebApp);
        }
        return webBundleDescriptor;
    }

    static WebBundleDescriptor open(File file, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        WebBundleDescriptor webBundleDescriptor = WebBundleArchivist.open(file, bl);
        if (bl2 && webBundleDescriptor != null) {
            JarFile jarFile = new JarFile(file);
            SunWebApp sunWebApp = WebBundleArchivist.createSunWebApp(jarFile, IAS_DEPLOYMENT_DESCRIPTOR_ENTRY, false);
            webBundleDescriptor.setSunDescriptor(sunWebApp);
            jarFile.close();
        }
        return webBundleDescriptor;
    }

    public void save(File file, boolean bl) throws IOException {
        this.save(file, DEPLOYMENT_DESCRIPTOR_ENTRY, null, bl);
    }

    void save(File file, String string, ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        File file2 = WebBundleArchivist.getWebTemp(WebBundleArchivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        String string2 = Utils.getSunDescriptorName(string);
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, string);
            if (bl) {
                this.writeSunDeploymentInfo(zipOutputStream2, string2);
            }
        } else {
            this.writeDeploymentInfo(zipOutputStream, string);
            if (bl) {
                this.writeSunDeploymentInfo(zipOutputStream, string2);
            }
        }
        Manifest manifest = new Manifest();
        WebBundleArchivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (bl) {
                vector.addElement("WEB-INF/sun-web.xml");
            }
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl2 = file2.renameTo(file);
        if (!bl2) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, file.toString());
    }

    private void writeSunDeploymentInfo(ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(zipEntry);
        SunWebApp sunWebApp = this.webBundleDescriptor.getSunDescriptor();
        sunWebApp.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public static SunWebApp createSunWebApp(JarFile jarFile, String string, boolean bl) throws IOException, ArchiveException {
        SunWebApp sunWebApp = null;
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            try {
                sunWebApp = WebBundleXmlReader.createIasWebDescriptorObj(inputStream, bl);
                inputStream.close();
            }
            catch (Exception exception) {
                throw new ArchiveException(exception.getMessage());
            }
        }
        return sunWebApp;
    }
}

