/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class ResourceReferenceDescriptor
extends EnvironmentProperty
implements NamedDescriptor,
ResourceReference {
    public static String APPLICATION_AUTHORIZATION = "Application";
    public static String CONTAINER_AUTHORIZATION = "Container";
    public static String RESOURCE_SHAREABLE = "Shareable";
    public static String RESOURCE_UNSHAREABLE = "Unshareable";
    private static final String URL_RESOURCE_TYPE = "java.net.URL";
    private static final String CONNECTOR_RESOURCE_TYPE = "javax.resource.cci.ConnectionFactory";
    private static final String MAIL_RESOURCE_TYPE = "javax.mail.Session";
    private static final String JDBC_RESOURCE_TYPE = "javax.sql.DataSource";
    private String type;
    private ResourcePrincipal resourcePrincipal = null;
    private MailConfiguration mailConfiguration;
    private String authorization;
    private DataSource dataSource;
    private DataSource pmDataSource;
    private String sharingScope;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceReferenceDescriptor.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public ResourceReferenceDescriptor(String string, String string2, String string3) {
        super(string, "", string2);
        this.type = string3;
        this.sharingScope = RESOURCE_SHAREABLE;
    }

    public ResourceReferenceDescriptor() {
        this.sharingScope = RESOURCE_SHAREABLE;
    }

    public String getJndiName() {
        return super.getValue();
    }

    public void setJndiName(String string) {
        super.setValue(string);
    }

    public String getSharingScope() {
        if (this.sharingScope == null) {
            return "";
        }
        return this.sharingScope;
    }

    public void setSharingScope(String string) {
        this.sharingScope = string;
    }

    public boolean isResolved() {
        return true;
    }

    public boolean isContainerAuthorization() {
        return this.getAuthorization().equals(CONTAINER_AUTHORIZATION);
    }

    public String getAuthorization() {
        if (this.authorization == null) {
            this.authorization = APPLICATION_AUTHORIZATION;
        }
        return this.authorization;
    }

    public void setAuthorization(String string) {
        if (this.isBoundsChecking()) {
            // empty if block
        }
        this.authorization = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public DataSource getPMJDBCDataSource() {
        if (this.pmDataSource == null) {
            try {
                InitialContext initialContext = new InitialContext();
                String string = ResourceInstaller.getPMJndiName(this.getJndiName());
                this.pmDataSource = (DataSource)initialContext.lookup(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pmDataSource;
    }

    public DataSource getJDBCDataSource() {
        if (this.dataSource == null) {
            try {
                InitialContext initialContext = new InitialContext();
                this.dataSource = (DataSource)initialContext.lookup(this.getJndiName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dataSource;
    }

    public boolean isMailResource() {
        return this.getType().equals(MAIL_RESOURCE_TYPE);
    }

    public boolean isJDBCResource() {
        return this.getType().equals(JDBC_RESOURCE_TYPE);
    }

    public boolean isURLResource() {
        return this.getType().equals(URL_RESOURCE_TYPE);
    }

    public boolean isJMSConnectionFactory() {
        String string = this.getType();
        return string.equals("javax.jms.QueueConnectionFactory") || string.equals("javax.jms.TopicConnectionFactory");
    }

    public ResourcePrincipal getResourcePrincipal() {
        return this.resourcePrincipal;
    }

    public void setResourcePrincipal(ResourcePrincipal resourcePrincipal) {
        this.resourcePrincipal = resourcePrincipal;
    }

    public void setMailConfiguration(MailConfiguration mailConfiguration) {
        this.mailConfiguration = mailConfiguration;
    }

    public MailConfiguration getMailConfiguration() {
        return this.mailConfiguration;
    }

    public boolean equals(Object object) {
        if (object instanceof ResourceReference) {
            ResourceReference resourceReference = (ResourceReference)object;
            return resourceReference.getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        String string = "Res-Ref-Env-Property: " + super.getName() + "@" + this.getType() + "@" + super.getDescription();
        if (this.isResolved()) {
            string = string + " resolved as: jndi: " + this.getJndiName() + "@res principal: " + this.getResourcePrincipal() + "@mail: " + this.getMailConfiguration();
        }
        return string;
    }

    public boolean isResourceConnectionFactory() {
        return this.getType().equals(CONNECTOR_RESOURCE_TYPE);
    }

    public void checkType() {
        if (this.type != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.type, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Throwable throwable) {
                if (this.isBoundsChecking()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{this.type}));
                }
                return;
            }
        }
    }
}

