/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJBException;

public final class PersistenceDescriptor
extends Descriptor {
    private static final boolean debug = false;
    public static final String DELETE_ROW = "deleteRow";
    public static final String CREATE_ROW = "createRow";
    public static final String LOAD_ROW = "loadRow";
    public static final String STORE_ROW = "storeRow";
    public static final String CREATE_TABLE = "createTable";
    public static final String DELETE_TABLE = "deleteTable";
    public static final String FINDBYPRIMARYKEY = "findByPrimaryKey";
    public static final String FINDBYSOURCEKEY = "findBySourceKey";
    public static final String FINDBYSINKKEY = "findBySinkKey";
    private Set cmpFields = new HashSet();
    private Set pkeyFields = new HashSet();
    private boolean pkeyIsOneField = false;
    private boolean pkeyFieldSpecified = true;
    private String primaryKeyClassName;
    private boolean pkeyStuffInitialized = false;
    private boolean pkeyFieldsAllPrimitive = false;
    private Set allSqlStatementedMethods;
    private Hashtable methodSqlMap = new Hashtable();
    private boolean createTableOnDeployment = true;
    private boolean deleteTableOnUndeployment = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PersistenceDescriptor.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private Descriptor parentDesc;
    private Class persistentClass;
    private Class stateClass;
    private Class primaryKeyClass;
    private PersistentFieldInfo[] persFieldInfo;
    private PersistentFieldInfo[] persNoPkeyFieldInfo;
    private PersistentFieldInfo[] pkeyFieldInfo;
    private boolean fieldInfoInitialized = false;
    private PersistentFieldInfo[] fkeyFields;
    private CMRFieldInfo[] cmrFieldInfo;
    private Field[] pkeyClassPkeyFields;
    private Hashtable queries = new Hashtable();
    private HashSet allQueriedMethods;
    private String tableName;

    public PersistenceDescriptor() {
    }

    public PersistenceDescriptor(PersistenceDescriptor persistenceDescriptor) {
        super(persistenceDescriptor);
        this.getCMPFields().addAll(persistenceDescriptor.getCMPFields());
        this.methodSqlMap = new Hashtable(persistenceDescriptor.getMethodSqlMap());
        this.createTableOnDeployment = persistenceDescriptor.createTableOnDeployment;
        this.deleteTableOnUndeployment = persistenceDescriptor.deleteTableOnUndeployment;
    }

    public String getCMRFieldReturnType(String string) {
        String string2 = "java.util.Collection";
        try {
            if (!string.trim().equals("")) {
                Class clazz = this.getPersistentClass();
                String string3 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
                Method method = TypeUtil.getMethod(clazz, clazz.getClassLoader(), string3, new String[0]);
                string2 = method.getReturnType().getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public boolean classesChanged() {
        Serializable serializable;
        Iterator iterator;
        this.persistentClass = null;
        this.stateClass = null;
        Class clazz = this.getPersistentClass();
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)this.parentDesc;
        Vector vector = ejbCMPEntityDescriptor.getFieldDescriptors();
        if (this.cmpFields != null) {
            iterator = this.cmpFields.iterator();
            while (iterator.hasNext()) {
                serializable = (FieldDescriptor)iterator.next();
                if (vector.contains(serializable)) continue;
                iterator.remove();
            }
        }
        if (this.pkeyFields != null) {
            iterator = this.pkeyFields.iterator();
            while (iterator.hasNext()) {
                serializable = (FieldDescriptor)iterator.next();
                if (vector.contains(serializable)) continue;
                iterator.remove();
            }
        }
        if ((iterator = ejbCMPEntityDescriptor.getPrimaryKeyFieldDesc()) != null && !vector.contains(iterator)) {
            ejbCMPEntityDescriptor.setPrimaryKeyFieldDesc(null);
        }
        serializable = (Hashtable)this.queries.clone();
        this.queries = new Hashtable();
        this.initializeAllQueriedMethods();
        Iterator iterator2 = ((Hashtable)serializable).keySet().iterator();
        while (iterator2.hasNext()) {
            Method method = (Method)iterator2.next();
            Method method2 = this.findEquivalentMethod(this.allQueriedMethods, method);
            if (method2 == null) continue;
            QueryDescriptor queryDescriptor = (QueryDescriptor)((Hashtable)serializable).get(method);
            QueryDescriptor queryDescriptor2 = new QueryDescriptor(queryDescriptor, method2);
            this.queries.put(method2, queryDescriptor2);
        }
        this.invalidate();
        return false;
    }

    private Method findEquivalentMethod(Collection collection, Method method) {
        Method method2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Method method3 = (Method)iterator.next();
            if (!this.methodsEqual(method3, method, false)) continue;
            method2 = method3;
            break;
        }
        return method2;
    }

    private boolean methodsEqual(Method method, Method method2, boolean bl) {
        String string;
        boolean bl2 = false;
        String string2 = method.getName();
        if (string2.equals(string = method2.getName())) {
            Class<?>[] classArray;
            Class<?>[] classArray2;
            String string3 = method.getDeclaringClass().getName();
            String string4 = method2.getDeclaringClass().getName();
            if ((!bl || string3.equals(string4)) && (classArray2 = method.getParameterTypes()).length == (classArray = method2.getParameterTypes()).length) {
                bl2 = true;
                for (int i = 0; i < classArray2.length; ++i) {
                    String string5;
                    String string6 = classArray2[i].getName();
                    if (string6.equals(string5 = classArray[i].getName())) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        return bl2;
    }

    public void setParentDescriptor(Descriptor descriptor) {
        this.parentDesc = descriptor;
    }

    public Descriptor getParentDescriptor() {
        return this.parentDesc;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        EjbBundleDescriptor ejbBundleDescriptor;
        if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)this.parentDesc;
            ejbBundleDescriptor = ejbCMPEntityDescriptor.getEjbBundleDescriptor();
        } else {
            JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)this.parentDesc;
            ejbBundleDescriptor = joinObjectDescriptor.getEjbBundleDescriptor();
        }
        return ejbBundleDescriptor;
    }

    public Set getRelationships() {
        Set set = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationshipDescriptor> hashSet = new HashSet<RelationshipDescriptor>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RelationshipDescriptor relationshipDescriptor = (RelationshipDescriptor)iterator.next();
            if (!relationshipDescriptor.hasParticipant(this.parentDesc)) continue;
            hashSet.add(relationshipDescriptor);
        }
        return hashSet;
    }

    public CMRFieldInfo[] getCMRFieldInfo() {
        if (this.cmrFieldInfo == null) {
            try {
                this.initCMRFieldStuff();
            }
            catch (Exception exception) {
                throw new EJBException(exception);
            }
        }
        return this.cmrFieldInfo;
    }

    public CMRFieldInfo getCMRFieldInfoByName(String string) {
        CMRFieldInfo[] cMRFieldInfoArray = this.getCMRFieldInfo();
        for (int i = 0; i < cMRFieldInfoArray.length; ++i) {
            if (!cMRFieldInfoArray[i].name.equals(string)) continue;
            return cMRFieldInfoArray[i];
        }
        throw new EJBException("CMRFieldInfo not found for field " + string);
    }

    public void invalidate() {
        this.cmrFieldInfo = null;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        this.pkeyStuffInitialized = false;
    }

    private void initCMRFieldStuff() throws Exception {
        Object object;
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            this.cmrFieldInfo = new CMRFieldInfo[0];
            return;
        }
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        boolean bl = false;
        if (this.getPersistentClass() != null && !Modifier.isAbstract(this.getPersistentClass().getModifiers())) {
            bl = true;
        }
        Set set = this.getRelationships();
        Iterator iterator = set.iterator();
        this.cmrFieldInfo = new CMRFieldInfo[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            RelationshipDescriptor relationshipDescriptor = (RelationshipDescriptor)iterator.next();
            RelationRoleDescriptor relationRoleDescriptor = relationshipDescriptor.getSource();
            object = relationRoleDescriptor.getPersistenceDescriptor() == this ? relationRoleDescriptor : relationshipDescriptor.getSink();
            CMRFieldInfo cMRFieldInfo = new CMRFieldInfo();
            this.cmrFieldInfo[n++] = cMRFieldInfo;
            PersistenceDescriptor persistenceDescriptor = ((RelationRoleDescriptor)object).getPartner().getPersistenceDescriptor();
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = ((RelationRoleDescriptor)object).getPartner().getOwner();
            if (!ejbCMPEntityDescriptor.isLocalInterfacesSupported() && ((RelationRoleDescriptor)object).getCMRField() != null) {
                throw new RuntimeException("No local interface for target bean of CMR field");
            }
            if (!((RelationRoleDescriptor)object).getPartner().getIsMany()) {
                string = ejbCMPEntityDescriptor.isLocalInterfacesSupported() ? ejbCMPEntityDescriptor.getLocalClassName() : ejbCMPEntityDescriptor.getPrimaryKeyClassName();
            } else {
                string = ((RelationRoleDescriptor)object).getCMRFieldType();
                if (string == null) {
                    string = "java.util.Collection";
                }
            }
            cMRFieldInfo.type = this.getClass(string);
            cMRFieldInfo.name = ((RelationRoleDescriptor)object).getCMRField();
            if (cMRFieldInfo.name == null) {
                cMRFieldInfo.name = "_reverse_" + ((RelationRoleDescriptor)object).getPartner().getCMRField();
            }
            cMRFieldInfo.role = object;
            ((RelationRoleDescriptor)object).setCMRFieldInfo(cMRFieldInfo);
            if (bl) {
                cMRFieldInfo.field = this.getStateClass().getField(cMRFieldInfo.name);
            }
            if (!relationshipDescriptor.isOneOne() || this.fkeyFields == null) continue;
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
            PersistentFieldInfo[] persistentFieldInfoArray2 = new PersistentFieldInfo[persistentFieldInfoArray.length];
            for (int i = 0; i < persistentFieldInfoArray.length; ++i) {
                String string2 = "_" + cMRFieldInfo.name + "_" + persistentFieldInfoArray[i].name;
                for (int j = 0; j < this.fkeyFields.length; ++j) {
                    if (!this.fkeyFields[j].name.equals(string2)) continue;
                    persistentFieldInfoArray2[i] = this.fkeyFields[j];
                }
            }
            cMRFieldInfo.fkeyFields = persistentFieldInfoArray2;
        }
        for (int i = this.cmrFieldInfo.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.cmrFieldInfo[j].name.compareTo(this.cmrFieldInfo[j + 1].name) <= 0) continue;
                object = this.cmrFieldInfo[j];
                this.cmrFieldInfo[j] = this.cmrFieldInfo[j + 1];
                this.cmrFieldInfo[j + 1] = object;
            }
        }
    }

    public void clearCMPFields() {
        this.cmpFields.clear();
        this.setCMPFields(this.cmpFields);
    }

    public void addCMPField(String string) {
        this.addCMPField(new FieldDescriptor(string));
    }

    public void addCMPField(FieldDescriptor fieldDescriptor) {
        this.cmpFields.add(fieldDescriptor);
        this.setCMPFields(this.cmpFields);
    }

    public void removeCMPField(String string) {
        this.removeCMPField(new FieldDescriptor(string));
    }

    public void removeCMPField(FieldDescriptor fieldDescriptor) {
        this.cmpFields.remove(fieldDescriptor);
        this.setCMPFields(this.cmpFields);
    }

    public void setCMPFields(Set set) {
        this.cmpFields = set;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        super.changed();
    }

    public boolean isCMPField(String string) {
        return this.getCMPFields().contains(new FieldDescriptor(string));
    }

    public Set getCMPFields() {
        return this.cmpFields;
    }

    public void setPkeyFields(Set set) {
        this.pkeyFields = set;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        this.pkeyStuffInitialized = false;
        super.changed();
    }

    public Set getPkeyFields() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFields;
    }

    public boolean isPkeyField(String string) {
        return this.isPkeyField(new FieldDescriptor(string));
    }

    public boolean isPkeyField(FieldDescriptor fieldDescriptor) {
        return this.getPkeyFields().contains(fieldDescriptor);
    }

    private void initPkeyInfo() {
        try {
            this.pkeyIsOneField = false;
            this.pkeyFieldSpecified = true;
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)this.parentDesc;
                this.primaryKeyClassName = ejbCMPEntityDescriptor.getPrimaryKeyClassName();
                FieldDescriptor fieldDescriptor = ejbCMPEntityDescriptor.getPrimaryKeyFieldDesc();
                if (this.pkeyFields == null || this.pkeyFields.size() == 0) {
                    this.pkeyFields = new HashSet();
                    if (fieldDescriptor != null) {
                        this.pkeyFields.add(fieldDescriptor);
                    } else if (!this.primaryKeyClassName.equals("java.lang.Object")) {
                        this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                        Field[] fieldArray = this.primaryKeyClass.getFields();
                        this.pkeyFieldsAllPrimitive = true;
                        for (int i = 0; i < fieldArray.length; ++i) {
                            int n = fieldArray[i].getModifiers();
                            if (Modifier.isStatic(n) || Modifier.isFinal(n)) continue;
                            if (!fieldArray[i].getType().isPrimitive()) {
                                this.pkeyFieldsAllPrimitive = false;
                            }
                            this.pkeyFields.add(new FieldDescriptor(fieldArray[i].getName()));
                        }
                    } else {
                        this.primaryKeyClassName = "java.lang.Long";
                        this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                        this.pkeyIsOneField = true;
                        this.pkeyFieldSpecified = false;
                    }
                }
                if (fieldDescriptor != null) {
                    this.pkeyIsOneField = true;
                }
            } else {
                JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)this.parentDesc;
                this.primaryKeyClassName = joinObjectDescriptor.getJoinObjectClass();
                try {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.pkeyStuffInitialized = true;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public boolean primaryKeyIsOneField() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyIsOneField;
    }

    public boolean primaryKeyIsSpecified() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldSpecified;
    }

    public boolean primaryKeyFieldsAllPrimitive() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldsAllPrimitive;
    }

    public Class getPrimaryKeyClass() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.primaryKeyClass;
    }

    public Class getPersistentClass() {
        if (this.persistentClass == null) {
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)this.parentDesc;
                this.persistentClass = this.getClass(ejbCMPEntityDescriptor.getEjbClassName());
            } else {
                JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)this.parentDesc;
                this.persistentClass = this.getClass(joinObjectDescriptor.getJoinObjectClass());
            }
        }
        return this.persistentClass;
    }

    public Class getStateClass() {
        if (this.stateClass == null) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor;
            this.stateClass = this.getPersistentClass();
            if (this.parentDesc instanceof EjbCMPEntityDescriptor && (ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)this.parentDesc).isEJB20()) {
                String string = ejbCMPEntityDescriptor.getStateImplClassName();
                this.stateClass = this.getClass(string);
            }
        }
        return this.stateClass;
    }

    private Class getClass(String string) {
        try {
            EjbBundleArchivist ejbBundleArchivist = (EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist();
            return ejbBundleArchivist.getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void setFkeyFields(PersistentFieldInfo[] persistentFieldInfoArray) {
        this.fkeyFields = persistentFieldInfoArray;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        super.changed();
    }

    public PersistentFieldInfo[] getFkeyFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.fkeyFields;
    }

    public PersistentFieldInfo[] getPersistentFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persFieldInfo;
    }

    public PersistentFieldInfo getPersistentFieldInfoByName(String string) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (int i = 0; i < this.persFieldInfo.length; ++i) {
            if (!this.persFieldInfo[i].name.equals(string)) continue;
            return this.persFieldInfo[i];
        }
        throw new EJBException("PersistentFieldInfo not found for field " + string);
    }

    public PersistentFieldInfo[] getNonPkeyPersFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persNoPkeyFieldInfo;
    }

    public PersistentFieldInfo[] getPkeyFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyFieldInfo;
    }

    public PersistentFieldInfo getPkeyFieldInfoByName(String string) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (int i = 0; i < this.pkeyFieldInfo.length; ++i) {
            if (!this.pkeyFieldInfo[i].name.equals(string)) continue;
            return this.pkeyFieldInfo[i];
        }
        throw new EJBException("PersistentFieldInfo not found for pkey field " + string);
    }

    public Field[] getPkeyClassFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyClassPkeyFields;
    }

    private void initializeFieldInfo() {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3;
        int n4;
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        if ((n4 = this.cmpFields.size()) == 0) {
            throw new EJBException("No cmp field defined for CMP EJB " + this.parentDesc.getName());
        }
        if (!this.pkeyFieldSpecified) {
            ++n4;
        }
        int n5 = 0;
        if (this.fkeyFields != null) {
            n5 = this.fkeyFields.length;
        }
        this.persFieldInfo = new PersistentFieldInfo[n4 + n5];
        int n6 = 0;
        Iterator iterator = this.cmpFields.iterator();
        while (iterator.hasNext()) {
            this.persFieldInfo[n6] = new PersistentFieldInfo();
            this.persFieldInfo[n6].name = ((FieldDescriptor)iterator.next()).getName();
            ++n6;
        }
        if (this.fkeyFields != null) {
            for (n3 = 0; n3 < this.fkeyFields.length; ++n3) {
                this.persFieldInfo[n6] = this.fkeyFields[n3];
                ++n6;
            }
        }
        if (!this.pkeyFieldSpecified) {
            PersistentFieldInfo persistentFieldInfo = new PersistentFieldInfo();
            persistentFieldInfo.name = "__PMPrimaryKey";
            this.persFieldInfo[n6] = persistentFieldInfo;
        }
        for (n3 = this.persFieldInfo.length - 1; n3 > 0; --n3) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.persFieldInfo[n2].name.compareTo(this.persFieldInfo[n2 + 1].name) <= 0) continue;
                object3 = this.persFieldInfo[n2];
                this.persFieldInfo[n2] = this.persFieldInfo[n2 + 1];
                this.persFieldInfo[n2 + 1] = object3;
            }
        }
        if (this.pkeyFieldSpecified) {
            int n7;
            int n8;
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator2 = this.pkeyFields.iterator();
            while (iterator2.hasNext()) {
                object3 = (FieldDescriptor)iterator2.next();
                n8 = 0;
                for (n7 = 0; n7 < this.persFieldInfo.length; ++n7) {
                    if (!((Descriptor)object3).getName().equals(this.persFieldInfo[n7].name)) continue;
                    n8 = 1;
                    break;
                }
                if (n8 != 0) continue;
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Descriptor)object3).getName());
            }
            if (stringBuffer.length() != 0) {
                throw new EJBException(localStrings.getLocalString("enterprise.deployment.pkhasnopersistentfields", "CMP bean [{0}], primary key class [{1}] has public non-persistent field(s) [{2}].", new Object[]{this.getParentDescriptor().getName(), this.getPrimaryKeyClass().getName(), stringBuffer.toString()}));
            }
            this.pkeyFieldInfo = new PersistentFieldInfo[this.pkeyFields.size()];
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - this.pkeyFieldInfo.length];
            n2 = 0;
            int n9 = 0;
            for (n8 = 0; n8 < this.persFieldInfo.length; ++n8) {
                n7 = 0;
                object2 = this.pkeyFields.iterator();
                while (object2.hasNext()) {
                    object = (PersistentFieldInfo[])object2.next();
                    if (!object.getName().equals(this.persFieldInfo[n8].name)) continue;
                    n7 = 1;
                    break;
                }
                if (n7 != 0) {
                    this.pkeyFieldInfo[n2++] = this.persFieldInfo[n8];
                    continue;
                }
                this.persNoPkeyFieldInfo[n9++] = this.persFieldInfo[n8];
            }
        } else {
            this.pkeyFieldInfo = new PersistentFieldInfo[1];
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - 1];
            n3 = 0;
            for (n2 = 0; n2 < this.persFieldInfo.length; ++n2) {
                if (this.persFieldInfo[n2].name.equals("__PMPrimaryKey")) {
                    this.pkeyFieldInfo[0] = this.persFieldInfo[n2];
                    continue;
                }
                this.persNoPkeyFieldInfo[n3++] = this.persFieldInfo[n2];
            }
        }
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            int n10;
            RelationshipDescriptor relationshipDescriptor = ((JoinObjectDescriptor)this.parentDesc).getRelationshipDesc();
            RelationRoleDescriptor relationRoleDescriptor = relationshipDescriptor.getSource();
            RelationRoleDescriptor relationRoleDescriptor2 = relationshipDescriptor.getSink();
            PersistenceDescriptor persistenceDescriptor = relationRoleDescriptor.getPersistenceDescriptor();
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
            for (int i = 0; i < persistentFieldInfoArray.length; ++i) {
                object = "_" + relationRoleDescriptor.getOwner().getName() + "_" + persistentFieldInfoArray[i].name;
                for (n10 = 0; n10 < this.persFieldInfo.length; ++n10) {
                    if (!this.persFieldInfo[n10].name.equals(object)) continue;
                    this.persFieldInfo[n10].type = persistentFieldInfoArray[i].type;
                    this.persFieldInfo[n10].relatedName = persistentFieldInfoArray[i].name;
                    this.persFieldInfo[n10].relatedObj = relationRoleDescriptor.getPersistenceDescriptor();
                }
            }
            object2 = relationRoleDescriptor2.getPersistenceDescriptor();
            object = ((PersistenceDescriptor)object2).getPkeyFieldInfo();
            for (n10 = 0; n10 < ((PersistentFieldInfo[])object).length; ++n10) {
                String string = "_" + relationRoleDescriptor2.getOwner().getName() + "_" + object[n10].name;
                for (int i = 0; i < this.persFieldInfo.length; ++i) {
                    if (!this.persFieldInfo[i].name.equals(string)) continue;
                    this.persFieldInfo[i].type = object[n10].type;
                    this.persFieldInfo[i].relatedName = object[n10].name;
                    this.persFieldInfo[i].relatedObj = relationRoleDescriptor2.getPersistenceDescriptor();
                }
            }
        } else {
            if (this.pkeyIsOneField) {
                this.pkeyFieldInfo[0].type = this.getPrimaryKeyClass();
            }
            for (int i = 0; i < this.persFieldInfo.length; ++i) {
                if (this.persFieldInfo[i].type != null) continue;
                this.persFieldInfo[i].type = this.getCMPFieldType(this.persFieldInfo[i].name);
            }
        }
        SQLTypeMapper sQLTypeMapper = new SQLTypeMapper();
        for (n = 0; n < this.persFieldInfo.length; ++n) {
            this.persFieldInfo[n].jdbcType = sQLTypeMapper.getJDBCTypeFor(this.persFieldInfo[n].type);
        }
        try {
            if (this.persistentClass != null && !Modifier.isAbstract(this.persistentClass.getModifiers())) {
                for (n = 0; n < this.persFieldInfo.length; ++n) {
                    this.persFieldInfo[n].field = this.getField(this.getStateClass(), this.persFieldInfo[n].name);
                }
            }
            if (!this.pkeyIsOneField && this.primaryKeyClass != null && !Modifier.isAbstract(this.primaryKeyClass.getModifiers())) {
                this.pkeyClassPkeyFields = new Field[this.pkeyFieldInfo.length];
                for (n = 0; n < this.pkeyFieldInfo.length; ++n) {
                    this.pkeyClassPkeyFields[n] = this.primaryKeyClass.getField(this.pkeyFieldInfo[n].name);
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new EJBException((Exception)noSuchFieldException);
        }
        this.fieldInfoInitialized = true;
    }

    private Field getField(final Class clazz, final String string) throws NoSuchFieldException {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return clazz.getDeclaredField(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return null;
                }
            }
        });
        if (field == null) {
            field = clazz.getField(string);
        }
        return field;
    }

    private Hashtable getMethodSqlMap() {
        return this.methodSqlMap;
    }

    public boolean hasCMPData() {
        Hashtable hashtable = this.getMethodSqlMap();
        Set set = this.getAllSqlStatementedMethods();
        if (hashtable.size() != set.size()) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashtable.get(string);
            if (string2 != null && !string2.equals("")) continue;
            return false;
        }
        return true;
    }

    public Set getAllSqlStatementedMethods() {
        if (this.allSqlStatementedMethods == null) {
            try {
                this.allSqlStatementedMethods = new HashSet();
                this.allSqlStatementedMethods.add(CREATE_ROW);
                this.allSqlStatementedMethods.add(DELETE_ROW);
                this.allSqlStatementedMethods.add(STORE_ROW);
                this.allSqlStatementedMethods.add(LOAD_ROW);
                this.allSqlStatementedMethods.add(CREATE_TABLE);
                this.allSqlStatementedMethods.add(DELETE_TABLE);
                this.allSqlStatementedMethods.add(FINDBYPRIMARYKEY);
                if (this.parentDesc instanceof JoinObjectDescriptor) {
                    this.allSqlStatementedMethods.add(FINDBYSOURCEKEY);
                    this.allSqlStatementedMethods.add(FINDBYSINKKEY);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbldngsqlstatementmthds", "Error building allSqlStatementedMethods {0}", new Object[]{exception}));
            }
        }
        return this.allSqlStatementedMethods;
    }

    public Set getSqlStatementedMethods() {
        return this.getMethodSqlMap().keySet();
    }

    public void setSqlStatementFor(String string, String string2) {
        if (string2 != null) {
            this.getMethodSqlMap().put(string, string2);
        } else {
            this.getMethodSqlMap().remove(string);
        }
        this.changed();
    }

    public String getSqlStatementFor(String string) {
        Object object = this.getMethodSqlMap().get(string);
        if (object == null) {
            object = "";
        }
        return (String)object;
    }

    public String getSqlStatementFor(Method method) {
        return this.getSqlStatementFor(method.getName());
    }

    public boolean getCreateTableOnDeployment() {
        return this.createTableOnDeployment;
    }

    public void setCreateTableOnDeployment(boolean bl) {
        this.createTableOnDeployment = bl;
        this.changed();
    }

    public boolean getDeleteTableOnUndeployment() {
        return this.deleteTableOnUndeployment;
    }

    public void setDeleteTableOnUndeployment(boolean bl) {
        this.deleteTableOnUndeployment = bl;
        this.changed();
    }

    public Class getTypeFor(String string) {
        return this.getCMPFieldType(string);
    }

    private Class getCMPFieldType(String string) {
        Class clazz = this.getPersistentClass();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            String string2 = PersistenceDescriptor.capitalize(string);
            String string3 = "get" + string2;
            try {
                Method method = clazz.getMethod(string3, null);
                return method.getReturnType();
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot find accessor " + string3 + " for CMP field " + string);
            }
        }
        try {
            Field field = this.getField(this.getStateClass(), string);
            return field.getType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Cant find CMP field " + string + " in class " + this.getStateClass().getName());
        }
    }

    public static String capitalize(String string) {
        if (Character.isUpperCase(string.charAt(0))) {
            throw new EJBException("CMP/CMR field " + string + " must start with a lower case character.");
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public void setQueryFor(Method method, QueryDescriptor queryDescriptor) {
        Method method2 = this.findEquivalentMethod(this.queries.keySet(), method);
        if (method2 != null) {
            this.queries.put(method2, queryDescriptor);
        } else {
            this.queries.put(method, queryDescriptor);
        }
    }

    public QueryDescriptor getQueryFor(Method method) {
        Method method2 = this.findEquivalentMethod(this.queries.keySet(), method);
        return method2 != null ? (QueryDescriptor)this.queries.get(method2) : null;
    }

    public Set getQueriedMethods() {
        return this.queries.keySet();
    }

    public Set getAllPossibleQueriedMethods() {
        if (this.allQueriedMethods == null) {
            this.initializeAllQueriedMethods();
        }
        return this.allQueriedMethods;
    }

    private void initializeAllQueriedMethods() {
        this.allQueriedMethods = new HashSet();
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            return;
        }
        Method[] methodArray = this.getPersistentClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("ejbSelect")) continue;
            this.allQueriedMethods.add(methodArray[i]);
        }
        if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
            String string;
            int n;
            Method[] methodArray2;
            Class clazz;
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)this.parentDesc;
            if (ejbCMPEntityDescriptor.isRemoteInterfacesSupported()) {
                clazz = this.getClass(ejbCMPEntityDescriptor.getHomeClassName());
                methodArray2 = clazz.getMethods();
                for (n = 0; n < methodArray2.length; ++n) {
                    string = methodArray2[n].getName();
                    if (!string.startsWith("find") || string.equals(FINDBYPRIMARYKEY)) continue;
                    this.allQueriedMethods.add(methodArray2[n]);
                }
            }
            if (ejbCMPEntityDescriptor.isLocalInterfacesSupported()) {
                clazz = this.getClass(ejbCMPEntityDescriptor.getLocalHomeClassName());
                methodArray2 = clazz.getMethods();
                for (n = 0; n < methodArray2.length; ++n) {
                    string = methodArray2[n].getName();
                    if (!string.startsWith("find") || string.equals(FINDBYPRIMARYKEY)) continue;
                    this.allQueriedMethods.add(methodArray2[n]);
                }
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\n Entity descriptor";
        string = string + "\n cmpFields " + this.cmpFields;
        string = string + "\n methodSqlMap " + this.methodSqlMap;
        return string;
    }
}

