/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;

public class NamedReferencePair {
    public static final int EJB = 1;
    public static final int EJB_REF = 2;
    public static final int RESOURCE_REF = 3;
    public static final int RESOURCE_ENV_REF = 4;
    private Descriptor referant;
    private NamedDescriptor referee;
    private int type;

    public static NamedReferencePair createEjbPair(EjbDescriptor ejbDescriptor, EjbDescriptor ejbDescriptor2) {
        return new NamedReferencePair(ejbDescriptor, ejbDescriptor2, 1);
    }

    public static NamedReferencePair createEjbRefPair(Descriptor descriptor, EjbReferenceDescriptor ejbReferenceDescriptor) {
        return new NamedReferencePair(descriptor, ejbReferenceDescriptor, 2);
    }

    public static NamedReferencePair createResourceRefPair(Descriptor descriptor, ResourceReferenceDescriptor resourceReferenceDescriptor) {
        return new NamedReferencePair(descriptor, resourceReferenceDescriptor, 3);
    }

    public static NamedReferencePair createResourceEnvRefPair(Descriptor descriptor, JmsDestinationReferenceDescriptor jmsDestinationReferenceDescriptor) {
        return new NamedReferencePair(descriptor, jmsDestinationReferenceDescriptor, 4);
    }

    protected NamedReferencePair(Descriptor descriptor, NamedDescriptor namedDescriptor, int n) {
        this.referant = descriptor;
        this.referee = namedDescriptor;
        this.type = n;
    }

    public Descriptor getReferant() {
        return this.referant;
    }

    public NamedDescriptor getReferee() {
        return this.referee;
    }

    public String getPairTypeName() {
        switch (this.type) {
            case 1: {
                return "EJB";
            }
            case 2: {
                return "EJB REF";
            }
            case 3: {
                return "RESOURCE REF";
            }
            case 4: {
                return "RESOURCE ENV REF";
            }
        }
        throw new IllegalStateException("unknown type = " + this.type);
    }

    public int getPairType() {
        return this.type;
    }

    public String toString() {
        return "NRP: " + this.referant.getName() + " -> " + ((Descriptor)((Object)this.referee)).getName();
    }
}

