/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.WebDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EnvironmentProperty
extends Descriptor
implements InitializationParameter,
ContextParameter,
WebDescriptor,
EnvironmentEntry {
    private String value;
    private String type;
    private Object valueObject;
    private static Class[] allowedTypes = new Class[]{String.class, Boolean.class, Integer.class, Double.class, Byte.class, Short.class, Long.class, Float.class, Character.class};
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnvironmentProperty.class);

    public EnvironmentProperty() {
    }

    public EnvironmentProperty(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public EnvironmentProperty(String string, String string2, String string3, String string4) {
        super(string, string3);
        this.value = string2;
        this.checkType(string4);
        this.type = string4;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    private void checkType(String string) {
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                if (this.isBoundsChecking()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{string}));
                }
                return;
            }
            boolean bl = false;
            for (int i = 0; i < allowedTypes.length; ++i) {
                if (!allowedTypes[i].equals(clazz)) continue;
                bl = true;
                break;
            }
            if (this.isBoundsChecking() && !bl) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedprprtytype", "{0} is not an allowed property value type", new Object[]{string}));
            }
        }
    }

    public Object getValueObject() {
        if (this.valueObject == null) {
            this.valueObject = "";
        }
        return EnvironmentProperty.getObjectFromString(this.getValue(), this.getValueType());
    }

    public Class getValueType() {
        if (this.type == null) {
            return String.class;
        }
        try {
            return Class.forName(this.type);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setType(String string) {
        this.checkType(string);
        this.type = string;
    }

    public String getType() {
        if (this.type == null) {
            if (this.isBoundsChecking()) {
                this.type = String.class.getName();
            }
        }
        return this.type;
    }

    public void setValue(String string) {
        this.value = string;
        super.changed();
    }

    public boolean equals(Object object) {
        return object instanceof EnvironmentProperty && this.getName().equals(((EnvironmentProperty)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Env-Prop: " + super.getName() + "@" + this.getType() + "@" + this.getValue() + "@" + super.getDescription();
    }

    private static Object getObjectFromString(String string, Class clazz) {
        if (string == null || "".equals(string) && !clazz.equals(String.class)) {
            return null;
        }
        try {
            if (String.class.equals(clazz)) {
                return string;
            }
            if (Boolean.class.equals(clazz)) {
                return new Boolean(string);
            }
            if (Integer.class.equals(clazz)) {
                return new Integer(string);
            }
            if (Double.class.equals(clazz)) {
                return new Double(string);
            }
            if (Float.class.equals(clazz)) {
                return new Float(string);
            }
            if (Short.class.equals(clazz)) {
                return new Short(string);
            }
            if (Byte.class.equals(clazz)) {
                return new Byte(string);
            }
            if (Long.class.equals(clazz)) {
                return new Long(string);
            }
            if (Character.class.equals(clazz)) {
                if (string.length() != 1) {
                    throw new IllegalArgumentException();
                }
                return new Character(string.charAt(0));
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncouldnotcreateinstancetype", "Could not create instance of {0} from {1}\n reason: {2}" + throwable, new Object[]{clazz, string, throwable}));
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionillegaltypeenvproperty", "Illegal type for environment properties: {0}", new Object[]{clazz}));
    }
}

