/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.SessionSynchronization;

public final class EjbSessionDescriptor
extends EjbDescriptor {
    private boolean isStateless = false;
    private int timeout = 0;
    public static String TYPE = "Session";
    public static String STATELESS = "Stateless";
    public static String STATEFUL = "Stateful";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbSessionDescriptor.class);

    public EjbSessionDescriptor() {
    }

    public EjbSessionDescriptor(EjbDescriptor ejbDescriptor) {
        super(ejbDescriptor);
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor ejbSessionDescriptor = (EjbSessionDescriptor)ejbDescriptor;
            this.isStateless = ejbSessionDescriptor.isStateless;
            this.timeout = ejbSessionDescriptor.timeout;
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getSessionTypeString() {
        if (this.isStateless()) {
            return STATELESS;
        }
        return STATEFUL;
    }

    public void setSessionTypeString(String string) {
        if (STATELESS.equals(string)) {
            this.setStateless(true);
            return;
        }
        if (STATEFUL.equals(string)) {
            this.setStateless(false);
            return;
        }
        if (this.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionsessiontypenotlegaltype", "{0} is not a legal session type for session ejbs. The type must be {1} or {2}", new Object[]{string, STATEFUL, STATELESS}));
        }
    }

    public void setType(String string) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofsessionbean", "Cannot set the type of a session bean"));
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTransactionType(String string) {
        boolean bl;
        boolean bl2 = bl = BEAN_TRANSACTION_TYPE.equals(string) || CONTAINER_TRANSACTION_TYPE.equals(string);
        if (!bl) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptointxtypenotlegaltype", "{0} is not a legal transaction type for session beans", new Object[]{string}));
            }
        }
        this.transactionType = string;
        super.setMethodContainerTransactions(new Hashtable());
        super.changed();
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public boolean isStateful() {
        return !this.isStateless();
    }

    public void setStateless(boolean bl) {
        this.isStateless = bl;
        super.changed();
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> vector = super.getPossibleTransactionAttributes();
        if (this.isStateful()) {
            try {
                Class clazz;
                EjbBundleDescriptor ejbBundleDescriptor = this.getEjbBundleDescriptor();
                EjbBundleArchivist ejbBundleArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
                ClassLoader classLoader = ejbBundleArchivist.getClassLoader();
                Class<?> clazz2 = classLoader.loadClass(this.getEjbClassName());
                Class clazz3 = clazz = SessionSynchronization.class;
                if (clazz.isAssignableFrom(clazz2)) {
                    vector = new Vector<ContainerTransaction>();
                    vector.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
                    vector.add(new ContainerTransaction(ContainerTransaction.REQUIRES_NEW, ""));
                    vector.add(new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public String toString() {
        String string = super.toString();
        string = string + "Session descriptor";
        string = string + "\n isStateless " + this.isStateless;
        return string;
    }
}

