/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Message;

public final class EjbMessageBeanDescriptor
extends EjbDescriptor {
    private static final boolean debug = false;
    private static final int UNKNOWN_DEST_TYPE = -1;
    private static final int QUEUE_DEST_TYPE = 1;
    private static final int TOPIC_DEST_TYPE = 2;
    private int jmsAcknowledgeMode = 1;
    public static final String TYPE = "Message-driven";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbMessageBeanDescriptor.class);
    private Method onMessageMethod = null;
    private String messageSelector = null;
    private int destinationType = 1;
    private boolean hasDurableSubscription = false;
    private String durableSubscriptionName = null;
    private String connectionFactoryName = null;

    public EjbMessageBeanDescriptor() {
        this.setUsesCallerIdentity(false);
    }

    public EjbMessageBeanDescriptor(EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        super(ejbMessageBeanDescriptor);
        this.messageSelector = ejbMessageBeanDescriptor.messageSelector;
        this.onMessageMethod = ejbMessageBeanDescriptor.onMessageMethod;
        this.jmsAcknowledgeMode = ejbMessageBeanDescriptor.jmsAcknowledgeMode;
        this.hasDurableSubscription = ejbMessageBeanDescriptor.hasDurableSubscription;
        this.durableSubscriptionName = ejbMessageBeanDescriptor.durableSubscriptionName;
        this.destinationType = ejbMessageBeanDescriptor.destinationType;
        this.setUsesCallerIdentity(false);
    }

    public String getType() {
        return TYPE;
    }

    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        String string = containerTransaction.getTransactionAttribute();
        if (!string.equals(ContainerTransaction.NOT_SUPPORTED) && !string.equals(ContainerTransaction.REQUIRED)) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.msgbeantxattrnotvalid", "Invalid transaction attribute for message-driven bean"));
        }
        super.setContainerTransactionFor(methodDescriptor, containerTransaction);
    }

    public void setType(String string) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofmsgdrivenbean", "Cannot set the type of a message-drive bean"));
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> vector = new Vector<ContainerTransaction>();
        vector.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
        vector.add(new ContainerTransaction(ContainerTransaction.NOT_SUPPORTED, ""));
        return vector;
    }

    public boolean hasQueueDest() {
        return this.destinationType == 1;
    }

    public boolean hasTopicDest() {
        return this.destinationType == 2;
    }

    public boolean hasDurableSubscription() {
        return this.hasDurableSubscription;
    }

    public void setHasDurableSubscription(boolean bl) {
        this.hasDurableSubscription = bl;
        if (!bl) {
            this.durableSubscriptionName = null;
        }
        super.changed();
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String string) {
        this.durableSubscriptionName = string;
        super.changed();
    }

    public void setHasQueueDest() {
        this.destinationType = 1;
        this.hasDurableSubscription = false;
        super.changed();
    }

    public void setHasTopicDest() {
        this.destinationType = 2;
        super.changed();
    }

    public boolean hasJmsMessageSelector() {
        return this.getJmsMessageSelector() != null;
    }

    public void setJmsMessageSelector(String string) {
        this.messageSelector = string == null || string.trim().equals("") ? null : string;
        super.changed();
    }

    public String getJmsMessageSelector() {
        return this.messageSelector;
    }

    public int getJmsAcknowledgeMode() {
        return this.jmsAcknowledgeMode;
    }

    public void setJmsAcknowledgeMode(int n) {
        this.jmsAcknowledgeMode = n;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String string) {
        this.connectionFactoryName = string;
    }

    public boolean hasConnectionFactory() {
        return this.connectionFactoryName != null;
    }

    public Vector getMethods(ClassLoader classLoader) {
        return new Vector();
    }

    protected Collection getTransactionMethods(ClassLoader classLoader) {
        Vector<Method> vector = new Vector<Method>();
        if (this.onMessageMethod == null) {
            try {
                Class<?> clazz = classLoader.loadClass(this.getEjbClassName());
                Class[] classArray = new Class[]{Message.class};
                this.onMessageMethod = clazz.getMethod("onMessage", classArray);
            }
            catch (Exception exception) {
                throw new NoSuchMethodError(localStrings.getLocalString("enterprise.deployment.noonmessagemethod", "onMessage is not defined for message-bean ") + this.getName());
            }
        }
        vector.addElement(this.onMessageMethod);
        return vector;
    }

    public void setTransactionType(String string) {
        boolean bl;
        boolean bl2 = bl = BEAN_TRANSACTION_TYPE.equals(string) || CONTAINER_TRANSACTION_TYPE.equals(string);
        if (!bl) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmsgbeantxtypenotlegaltype", "{0} is not a legal transaction type for a message-driven bean", new Object[]{string}));
            }
        }
        this.transactionType = string;
        super.setMethodContainerTransactions(new Hashtable());
        super.changed();
    }

    public String toString() {
        String string = super.toString();
        string = string + "Message-driven descriptor";
        string = string + "\n " + this.messageSelector;
        return string;
    }
}

