/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbCMPEntityDescriptor
extends EjbEntityDescriptor {
    public static String CMP_2_VERSION = "2.x";
    public static String CMP_1_VERSION = "1.x";
    private String cmpVersion = "";
    private PersistenceDescriptor pers;
    private String abstractSchemaName = null;
    private FieldDescriptor primaryKeyFieldDesc;
    private String stateImplClassName = null;
    private String ejbImplementationImplClassName = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbCMPEntityDescriptor.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public EjbCMPEntityDescriptor() {
        this.setPersistenceType(CONTAINER_PERSISTENCE);
    }

    public EjbCMPEntityDescriptor(EjbDescriptor ejbDescriptor) {
        super(ejbDescriptor);
        this.setPersistenceType(CONTAINER_PERSISTENCE);
        if (ejbDescriptor instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)ejbDescriptor;
            this.pers = ejbCMPEntityDescriptor.pers;
            this.cmpVersion = ejbCMPEntityDescriptor.cmpVersion;
            this.abstractSchemaName = ejbCMPEntityDescriptor.abstractSchemaName;
        }
    }

    public void setStateImplClassName(String string) {
        this.stateImplClassName = string;
    }

    public String getStateImplClassName() {
        return this.stateImplClassName;
    }

    public boolean classesChanged() {
        boolean bl = super.classesChanged();
        boolean bl2 = this.pers.classesChanged();
        if (!bl && bl2) {
            this.changed();
        }
        return bl || bl2;
    }

    public Vector getFields() {
        Vector vector = new Vector();
        if (!this.isEJB20()) {
            vector = super.getFields();
        }
        return vector;
    }

    public Vector getFieldDescriptors() {
        Vector vector = new Vector();
        if (this.isEJB20()) {
            try {
                ClassLoader classLoader = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
                vector = TypeUtil.getPossibleCmpCmrFields(classLoader, this.getEjbClassName());
            }
            catch (Throwable throwable) {
                String string = localStrings.getLocalString("enterprise.deployment.errorloadingejbclass", "error loading the ejb class {0} in getFields on EjbDescriptor\n {1}", new Object[]{this.getEjbClassName(), throwable.toString()});
                _logger.log(Level.FINE, string);
            }
        } else {
            vector = super.getFieldDescriptors();
        }
        return vector;
    }

    public String getCMPVersion() {
        if (this.cmpVersion == null || this.cmpVersion.equals("")) {
            this.cmpVersion = CMP_2_VERSION;
        }
        return this.cmpVersion;
    }

    public boolean isEJB20() {
        return this.cmpVersion.equals(CMP_2_VERSION);
    }

    public boolean isEJB11() {
        return this.cmpVersion.equals(CMP_1_VERSION);
    }

    public void setCMPVersion(String string) {
        if (!string.equals(CMP_2_VERSION) && !string.equals(CMP_1_VERSION)) {
            throw new IllegalArgumentException("Invalid CMP version");
        }
        this.cmpVersion = string;
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> vector = null;
        if (this.isEJB20()) {
            vector = new Vector<ContainerTransaction>();
            vector.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
            vector.add(new ContainerTransaction(ContainerTransaction.REQUIRES_NEW, ""));
            vector.add(new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        } else {
            vector = super.getPossibleTransactionAttributes();
        }
        return vector;
    }

    public void setPersistenceDescriptor(PersistenceDescriptor persistenceDescriptor) {
        this.pers = persistenceDescriptor;
        persistenceDescriptor.setParentDescriptor(this);
    }

    public PersistenceDescriptor getPersistenceDescriptor() {
        if (this.pers == null) {
            this.pers = new PersistenceDescriptor();
            this.setPersistenceDescriptor(this.pers);
        }
        return this.pers;
    }

    private void invalidatePersistenceInfo() {
        if (this.pers != null) {
            this.pers.invalidate();
        }
    }

    public void setPrimaryKeyFieldDesc(FieldDescriptor fieldDescriptor) {
        this.primaryKeyFieldDesc = fieldDescriptor;
        this.invalidatePersistenceInfo();
    }

    public FieldDescriptor getPrimaryKeyFieldDesc() {
        return this.primaryKeyFieldDesc;
    }

    public void setAbstractSchemaName(String string) {
        this.abstractSchemaName = string;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setEjbImplementationImplClassName(String string) {
        this.ejbImplementationImplClassName = string;
    }

    public String getEjbImplementationImplClassName() {
        return this.ejbImplementationImplClassName;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\n cmpVersion " + this.cmpVersion;
        string = string + this.pers.toString();
        return string;
    }
}

