/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMappings;
import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.CheckpointDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalEntityDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbBundleDescriptor
extends BundleDescriptor {
    public static final String EJB_2_x_VERSION = "EJB 2.x";
    public static final String EJB_1_x_VERSION = "EJB 1.x";
    private Set ejbs = new HashSet();
    private long uniqueId;
    private Set relationships = new HashSet();
    private Set remoteEntities = new HashSet();
    private String relationshipsDescription;
    private String ejbClientJarUri;
    private String ejbVersion = "EJB 2.x";
    private ResourceReferenceDescriptor cmpResourceReference;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbBundleDescriptor.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    protected SunEjbJar ejbJarDD = new SunEjbJar();
    protected SunCmpMappings iasCmpMappings = null;
    protected Set testDone = new HashSet();
    private Hashtable checkpointedMethodsTable = new Hashtable();

    public boolean isEJB20() {
        return this.ejbVersion.equals(EJB_2_x_VERSION);
    }

    public boolean isEJB11() {
        return this.ejbVersion.equals(EJB_1_x_VERSION);
    }

    public void setEJBVersion(String string) {
        if (!this.ejbVersion.equals(EJB_1_x_VERSION) && !this.ejbVersion.equals(EJB_2_x_VERSION)) {
            throw new IllegalArgumentException("Illegal ejb version : " + string);
        }
        this.ejbVersion = string;
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    public void setEjbClientJarUri(String string) {
        this.ejbClientJarUri = string;
        this.changed();
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        super.addBundleDescriptor(ejbBundleDescriptor);
        Iterator iterator = ejbBundleDescriptor.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            ejbDescriptor.setEjbBundleDescriptor(this);
            this.getEjbs().add(ejbDescriptor);
        }
        this.changed();
    }

    public void classesChanged() {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            ejbDescriptor.classesChanged();
        }
    }

    protected Archivist getDefaultArchivist() {
        return new EjbBundleArchivist(false, "", this, new HashSet());
    }

    public Collection getNamedDescriptors() {
        Vector<EjbDescriptor> vector = new Vector<EjbDescriptor>();
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            vector.add(ejbDescriptor);
            vector.addAll(super.getNamedDescriptorsFrom(ejbDescriptor));
        }
        return vector;
    }

    public Vector getNamedReferencePairs() {
        Vector<NamedReferencePair> vector = new Vector<NamedReferencePair>();
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            vector.add(NamedReferencePair.createEjbPair(ejbDescriptor, ejbDescriptor));
            vector.addAll(super.getNamedReferencePairsFrom(ejbDescriptor));
        }
        return vector;
    }

    public Set getResourceReferenceDescriptors() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            hashSet.addAll(ejbDescriptor.getResourceReferenceDescriptors());
        }
        return hashSet;
    }

    public boolean hasEjbReferences() {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            if (ejbDescriptor.getEjbReferenceDescriptors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set getEjbs() {
        return this.ejbs;
    }

    public boolean hasEjbByName(String string) {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor getEjbByName(String string) {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.getName().equals(string)) continue;
            return (EjbDescriptor)descriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: \"{0}\"", new Object[]{string}));
    }

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor);
        super.changed();
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
        super.changed();
    }

    void replaceEjb(EjbDescriptor ejbDescriptor, EjbDescriptor ejbDescriptor2) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
        ejbDescriptor2.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor2);
    }

    public boolean areResourceReferencesValid() {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            Iterator iterator2 = ejbDescriptor.getRoleReferences().iterator();
            while (iterator2.hasNext()) {
                RoleReference roleReference = (RoleReference)iterator2.next();
                Role role = roleReference.getRole();
                if (role.getName().equals("") || super.getRoles().contains(role)) continue;
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.badrolereference", "Warning: Bad role reference to {0}", new Object[]{role}));
                _logger.log(Level.FINE, "Roles:  " + this.getRoles());
                return false;
            }
        }
        return true;
    }

    public void removeRole(Role role) {
        if (super.getRoles().contains(role)) {
            Iterator iterator = this.getEjbs().iterator();
            while (iterator.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
                ejbDescriptor.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    public boolean hasPermissionedRoles() {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            if (ejbDescriptor.getPermissionedMethodsByPermission().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasContainerTransactions() {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            if (ejbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public void addRelationship(RelationshipDescriptor relationshipDescriptor) {
        this.relationships.add(relationshipDescriptor);
        super.changed();
    }

    public void removeRelationship(RelationshipDescriptor relationshipDescriptor) {
        this.relationships.remove(relationshipDescriptor);
        super.changed();
    }

    public String getRelationshipsDescription() {
        if (this.relationshipsDescription == null) {
            this.relationshipsDescription = "";
        }
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String string) {
        this.relationshipsDescription = string;
    }

    public Set getRelationships() {
        return this.relationships;
    }

    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    public boolean hasRelationship(RelationshipDescriptor relationshipDescriptor) {
        return this.relationships.contains(relationshipDescriptor);
    }

    public void addRemoteEntity(EjbExternalEntityDescriptor ejbExternalEntityDescriptor) {
        this.remoteEntities.add(ejbExternalEntityDescriptor);
        ejbExternalEntityDescriptor.setEjbBundleDescriptor(this);
    }

    public Set getRemoteEntities() {
        return this.remoteEntities;
    }

    public ResourceReferenceDescriptor getCMPResourceReference() {
        return this.cmpResourceReference;
    }

    public void setCMPResourceReference(ResourceReferenceDescriptor resourceReferenceDescriptor) {
        this.cmpResourceReference = resourceReferenceDescriptor;
        this.changed();
    }

    public Descriptor getDescriptorByName(String string) {
        try {
            EjbDescriptor ejbDescriptor = this.getEjbByName(string);
            return ejbDescriptor;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Iterator iterator = this.remoteEntities.iterator();
            while (iterator.hasNext()) {
                Descriptor descriptor = (Descriptor)iterator.next();
                if (!descriptor.getName().equals(string)) continue;
                return descriptor;
            }
            return null;
        }
    }

    public EjbExternalEntityDescriptor getRemoteEntityByName(String string) {
        Iterator iterator = this.remoteEntities.iterator();
        while (iterator.hasNext()) {
            EjbExternalEntityDescriptor ejbExternalEntityDescriptor = (EjbExternalEntityDescriptor)iterator.next();
            if (!ejbExternalEntityDescriptor.getName().equals(string)) continue;
            return ejbExternalEntityDescriptor;
        }
        return null;
    }

    public boolean hasRemoteEntityByName(String string) {
        return this.getRemoteEntityByName(string) != null;
    }

    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    private void doMethodDescriptorConversions() throws Exception {
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            ejbDescriptor.doMethodDescriptorConversions();
        }
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
        EjbDescriptor[] ejbDescriptorArray = this.ejbs.toArray(new EjbDescriptor[this.ejbs.size()]);
        Arrays.sort(ejbDescriptorArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((EjbDescriptor)object).getName().compareTo(((EjbDescriptor)object2).getName());
            }
        });
        for (int i = 0; i < ejbDescriptorArray.length; ++i) {
            ejbDescriptorArray[i].setUniqueId(l | (long)i);
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public static int getIdFromEjbId(long l) {
        long l2 = l >> 32;
        return (int)l2;
    }

    public String toString() {
        String string = "EjbBundleDescriptor";
        string = string + "\n archivist " + super.getArchivist();
        string = string + "\n roles " + this.getRoles();
        string = string + "\nclient JAR " + this.getEjbClientJarUri();
        Iterator iterator = this.getEjbs().iterator();
        while (iterator.hasNext()) {
            string = string + "\n------------\n";
            string = string + iterator.next();
            string = string + "\n------------";
        }
        return string;
    }

    public void setIasEjbObject(SunEjbJar sunEjbJar) {
        this.ejbJarDD = sunEjbJar;
    }

    public SunEjbJar getIasEjbObject() {
        return this.ejbJarDD;
    }

    public void setIasCmpMappingObject(SunCmpMappings sunCmpMappings) {
        this.iasCmpMappings = sunCmpMappings;
    }

    public SunCmpMappings getIasCmpMappings() {
        return this.iasCmpMappings;
    }

    public Set getTestsDone() {
        return this.testDone;
    }

    public void setTestsDone(String string) {
        this.testDone.add(string);
    }

    public SunEjbJar getSunDescriptor() {
        return this.ejbJarDD;
    }

    public void setSunDescriptor(SunEjbJar sunEjbJar) {
        this.ejbJarDD = sunEjbJar;
    }

    public void setCheckpointDescriptor(String string, CheckpointDescriptor checkpointDescriptor) {
        this.checkpointedMethodsTable.put(string, checkpointDescriptor);
    }

    public CheckpointDescriptor getCheckpointDescriptor(String string) {
        return (CheckpointDescriptor)this.checkpointedMethodsTable.get(string);
    }
}

