/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Descriptor
implements Serializable {
    public static String DESCRIPTOR_CHANGED = "Descriptor change";
    private static boolean boundsChecking = true;
    protected Vector listeners = new Vector();
    protected String name = "";
    private String description = "";
    private String largeIconUri = null;
    private String smallIconUri = null;
    public String docType = null;

    public Descriptor() {
        this.listeners = new Vector();
    }

    protected Descriptor(Descriptor descriptor) {
        this.name = descriptor.name;
        this.description = descriptor.description;
        this.largeIconUri = descriptor.largeIconUri;
        this.smallIconUri = descriptor.smallIconUri;
    }

    public Descriptor(String string, String string2) {
        this();
        this.name = string;
        this.description = string2;
    }

    public static void setBoundsChecking(boolean bl) {
        boundsChecking = bl;
    }

    public static boolean isBoundsChecking() {
        return boundsChecking;
    }

    public void setName(String string) {
        if (string == null || !string.equals(this.name)) {
            this.name = string;
            this.changed();
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public void setDescription(String string) {
        if (string != null && !string.equals(this.description)) {
            this.description = string;
            this.changed();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getLargeIconUri() {
        if (this.largeIconUri == null) {
            this.largeIconUri = "";
        }
        return this.largeIconUri;
    }

    public void setLargeIconUri(String string) {
        this.largeIconUri = string;
        this.changed();
    }

    public String getSmallIconUri() {
        if (this.smallIconUri == null) {
            this.smallIconUri = "";
        }
        return this.smallIconUri;
    }

    public void setSmallIconUri(String string) {
        this.smallIconUri = string;
        this.changed();
    }

    public void addNotificationListener(NotificationListener notificationListener) {
        this.listeners.addElement(notificationListener);
    }

    public void removeNotificationListener(NotificationListener notificationListener) {
        this.listeners.removeElement(notificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() {
        long l = System.currentTimeMillis();
        NotificationEvent notificationEvent = new NotificationEvent(this, DESCRIPTOR_CHANGED, this);
        Vector vector = null;
        Object object = this.listeners;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)object.nextElement();
            notificationListener.notification(notificationEvent);
        }
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 20L) {
            // empty if block
        }
    }

    private static String stripIntegerEndingFrom(String string) {
        return Descriptor.recursiveStripIntegerEndingFrom(string);
    }

    private static String recursiveStripIntegerEndingFrom(String string) {
        if (string.length() > 1) {
            String string2 = string.substring(0, string.length() - 1);
            String string3 = string.substring(string.length() - 1, string.length());
            try {
                Integer.parseInt(string3);
                return Descriptor.recursiveStripIntegerEndingFrom(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return string;
            }
        }
        return string;
    }

    private static String uniquifyString(String string, Vector vector, int n) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return Descriptor.uniquifyString(Descriptor.stripIntegerEndingFrom(string) + ++n, vector, n);
        }
        return string;
    }

    public static String createUniqueFilenameAmongst(String string, Vector vector) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return Descriptor.uniquifyString(string, vector, 0);
        }
        String string2 = string.substring(n);
        String string3 = string.substring(0, n);
        Vector<String> vector2 = new Vector<String>();
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            String string4 = object.nextElement().toString();
            if (!string4.endsWith(string2)) continue;
            vector2.add(string4.substring(0, string4.length() - string2.length()));
        }
        object = Descriptor.uniquifyString(string3, vector2, 0);
        return (String)object + string2;
    }

    public static String createUniqueNameAmongst(String string, Vector vector) {
        return Descriptor.uniquifyString(string, vector, 0);
    }

    public static String createUniqueNameAmongstNamedDescriptors(String string, Set set) {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            vector.addElement(descriptor.getName());
        }
        return Descriptor.createUniqueNameAmongst(string, vector);
    }

    public String toString() {
        String string = " name " + this.name;
        string = string + "\n description " + this.description;
        if (!"".equals(this.getSmallIconUri())) {
            string = string + "\n smallIconUri " + this.getSmallIconUri();
        }
        if (!"".equals(this.getLargeIconUri())) {
            string = string + "\n largeIconUri " + this.getLargeIconUri();
        }
        return string;
    }

    public String getDocType() {
        return this.docType;
    }

    public void fillDocType(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            char c = (char)bufferedReader.read();
            while (c != '\uffffffff') {
                if (c == '<') {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(c);
                    do {
                        c = (char)bufferedReader.read();
                        stringBuffer.append(c);
                    } while (c != '>');
                    String string = stringBuffer.toString();
                    if (string.indexOf("DOCTYPE") != -1) {
                        this.docType = string.trim();
                        return;
                    }
                }
                c = (char)bufferedReader.read();
            }
            stringBuffer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

