/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeploymentContext {
    private static File tmpSrcDir;
    private static File tmpBinaryDir;
    private Application application;
    private AbstractArchive archive = null;
    private File appTmpDir = null;
    private DeploymentSession session;
    static Logger _logger;

    public DeploymentContext(AbstractArchive abstractArchive, Application application) {
        this.application = application;
        this.archive = abstractArchive;
        File file = abstractArchive.getSourceDirectory();
        tmpSrcDir = new File(file, "gnrtrTMP");
        tmpBinaryDir = new File(file, "explodeTMP");
        tmpSrcDir.mkdirs();
        tmpBinaryDir.mkdirs();
    }

    public Application getApplication() {
        return this.application;
    }

    public AbstractArchive getArchive() {
        return this.archive;
    }

    public File getTempDirectory() {
        if (this.appTmpDir == null) {
            this.appTmpDir = new File(tmpSrcDir, this.application.getName());
            this.appTmpDir.mkdirs();
        }
        return this.appTmpDir;
    }

    public void setSession(DeploymentSession deploymentSession) {
        this.session = deploymentSession;
    }

    public DeploymentSession getSession() {
        return this.session;
    }

    public String getFileName(String string) {
        return this.getTempDirectory() + File.separator + string.replace('.', File.separatorChar) + ".java";
    }

    public String getClassName(String string) {
        String string2 = string;
        if (string2.startsWith(this.getTempDirectory().toString())) {
            string2 = string2.substring(this.getTempDirectory().toString().length());
        }
        if (string2.indexOf(".java") != -1) {
            string2 = string2.substring(0, string2.indexOf(".java"));
        } else if (string2.indexOf(".class") != -1) {
            string2 = string2.substring(0, string2.indexOf(".class"));
        }
        string2 = string2.replace(File.separatorChar, '.');
        if (string2.charAt(0) == '.') {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public OutputStream createOutputStream(String string) throws IOException {
        String string2 = this.getFileName(string);
        File file = new File(string2);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        return new FileOutputStream(string2);
    }

    public File getOutputDirectory() {
        return this.archive.getWriteableDirectory();
    }

    public File getSourceDirectory() {
        return this.archive.getSourceDirectory();
    }

    public String getClassPath() {
        return System.getProperty("java.class.path") + File.pathSeparator + this.getOutputDirectory().toString() + File.pathSeparator + this.getTempDirectory().toString();
    }

    public ClassLoader getClassLoader() {
        return this.application.getApplicationArchivist().getClassLoader();
    }

    public static File createApplicationTempDirectory(String string) {
        File file = new File(tmpBinaryDir, string);
        if (file.exists()) {
            _logger.log(Level.FINE, "Warning, binary temp directory already exists, cleaning...");
            DeploymentContext.deleteDirectory(file);
        }
        file.mkdirs();
        return file;
    }

    public static void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    DeploymentContext.deleteDirectory(file2);
                }
                file2.delete();
            }
        }
        file.delete();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

