/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.tools.common.dd.connector.SunConnector;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class ConnectorDescriptor
extends BundleDescriptor {
    private String connectionFactoryInterface;
    private String connectionFactoryImpl;
    private String connectionInterface;
    private String connectionImpl;
    private Set configProperties = new OrderedSet();
    private Set authMechanisms = new OrderedSet();
    private Set securityPermissions = new OrderedSet();
    private String managedConnectionFactoryImpl;
    private boolean reauthenticationSupport;
    private int transactionSupport = 1;
    private String displayName = "";
    private String connectorDescription;
    private String licenseDescription;
    private String eisType = "";
    private String largeIcon;
    private String smallIcon;
    private Boolean licenseRequired;
    private String specVersion = "";
    private String vendorName = "";
    private String version = "";
    private boolean isDirty = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private SunConnector sunConnector = null;

    public String getDeployName() {
        File file = new File(this.getArchivist().getArchiveUri());
        return file.getName();
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String string) {
        this.connectionFactoryInterface = string;
        this.setDirty();
        this.changed();
    }

    public String getConnectionFactoryImpl() {
        return this.connectionFactoryImpl;
    }

    public void setConnectionFactoryImpl(String string) {
        this.connectionFactoryImpl = string;
        this.setDirty();
        this.changed();
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String string) {
        this.connectionInterface = string;
        this.setDirty();
        this.changed();
    }

    public String getConnectionImpl() {
        return this.connectionImpl;
    }

    public void setConnectionImpl(String string) {
        this.connectionImpl = string;
        this.setDirty();
        this.changed();
    }

    public String getManagedConnectionFactoryImpl() {
        return this.managedConnectionFactoryImpl;
    }

    private static void printEntry(ZipEntry zipEntry) throws IOException {
        _logger.log(Level.FINE, zipEntry.getName());
    }

    public void setManagedConnectionFactoryImpl(String string) {
        this.managedConnectionFactoryImpl = string;
        this.setDirty();
        this.changed();
    }

    public boolean supportsReauthentication() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean bl) {
        this.reauthenticationSupport = bl;
        this.setDirty();
        this.changed();
    }

    public String getTransSupport() {
        if (this.transactionSupport == 0) {
            return ConnectorNode.DD_NO_TRANSACTION;
        }
        if (this.transactionSupport == 1) {
            return ConnectorNode.DD_LOCAL_TRANSACTION;
        }
        return ConnectorNode.DD_XA_TRANSACTION;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(int n) {
        this.transactionSupport = n;
        this.setDirty();
        this.changed();
    }

    public Set getConfigProperties() {
        if (this.configProperties == null) {
            this.configProperties = new OrderedSet();
        }
        return this.configProperties;
    }

    public Set getAuthMechanisms() {
        if (this.authMechanisms == null) {
            this.authMechanisms = new OrderedSet();
        }
        return this.authMechanisms;
    }

    public Set getSecurityPermissions() {
        if (this.securityPermissions == null) {
            this.securityPermissions = new OrderedSet();
        }
        return this.securityPermissions;
    }

    public void addConfigProperty(EnvironmentProperty environmentProperty) {
        this.configProperties.add(environmentProperty);
        this.setDirty();
        this.changed();
    }

    public void removeConfigProperty(EnvironmentProperty environmentProperty) {
        this.configProperties.remove(environmentProperty);
        this.setDirty();
        this.changed();
    }

    public boolean addAuthMechanism(AuthMechanism authMechanism) {
        boolean bl = false;
        Iterator iterator = this.authMechanisms.iterator();
        while (iterator.hasNext()) {
            AuthMechanism authMechanism2 = (AuthMechanism)iterator.next();
            if (authMechanism2.getAuthMechVal() != authMechanism.getAuthMechVal()) continue;
            return bl;
        }
        bl = this.authMechanisms.add(authMechanism);
        this.setDirty();
        this.changed();
        return bl;
    }

    public boolean removeAuthMechanism(AuthMechanism authMechanism) {
        boolean bl = false;
        Iterator iterator = this.authMechanisms.iterator();
        while (iterator.hasNext()) {
            AuthMechanism authMechanism2 = (AuthMechanism)iterator.next();
            if (!authMechanism2.equals(authMechanism)) continue;
            bl = this.authMechanisms.remove(authMechanism);
            this.setDirty();
            this.changed();
            return bl;
        }
        return bl;
    }

    public boolean addAuthMechanism(int n) {
        AuthMechanism authMechanism;
        boolean bl = false;
        Object object = this.authMechanisms.iterator();
        while (object.hasNext()) {
            authMechanism = (AuthMechanism)object.next();
            if (authMechanism.getAuthMechVal() != n) continue;
            return bl;
        }
        object = null;
        object = n == 0 ? "javax.resource.spi.security.PasswordCredential" : "javax.resource.spi.security.GenericCredential";
        authMechanism = new AuthMechanism("", n, (String)object);
        bl = this.authMechanisms.add(authMechanism);
        this.setDirty();
        this.changed();
        return bl;
    }

    public boolean removeAuthMechanism(int n) {
        boolean bl = false;
        Iterator iterator = this.authMechanisms.iterator();
        while (iterator.hasNext()) {
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            if (authMechanism.getAuthMechVal() != n) continue;
            bl = this.authMechanisms.remove(authMechanism);
            this.setDirty();
            this.changed();
            return bl;
        }
        return bl;
    }

    public void addSecurityPermission(SecurityPermission securityPermission) {
        this.securityPermissions.add(securityPermission);
        this.setDirty();
        this.changed();
    }

    public void removeSecurityPermission(SecurityPermission securityPermission) {
        this.securityPermissions.remove(securityPermission);
        this.setDirty();
        this.changed();
    }

    public void setLicenseDescription(String string) {
        this.licenseDescription = string;
        this.setDirty();
        this.changed();
    }

    public String getLicenseDescription() {
        return this.licenseDescription;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public void setConnectorDescription(String string) {
        this.connectorDescription = string;
        this.setDirty();
        this.changed();
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String string) {
        this.eisType = string;
        this.setDirty();
        this.changed();
    }

    public Boolean getLicenseRequired() {
        return this.licenseRequired;
    }

    public void setLicenseRequired(boolean bl) {
        this.licenseRequired = bl ? Boolean.TRUE : (!bl ? Boolean.FALSE : null);
        this.setDirty();
        this.changed();
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
        this.setDirty();
        this.changed();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
        this.setDirty();
        this.changed();
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String string) {
        this.specVersion = string;
        this.setDirty();
        this.changed();
    }

    protected Archivist getDefaultArchivist() {
        return new ConnectorArchivist(false, "", this);
    }

    public String toString() {
        String string = super.toString();
        string = string + "\n connectionFactoryInterface " + this.connectionFactoryInterface;
        string = string + "\n connectionFactoryImpl " + this.connectionFactoryImpl;
        string = string + "\n connectionInterface " + this.connectionInterface;
        string = string + "\n connectionImpl " + this.connectionImpl;
        string = string + "\n managedConnectionFactoryImpl " + this.managedConnectionFactoryImpl;
        string = string + "\n reauthenticationSupport " + this.reauthenticationSupport;
        string = string + "\n transactionSupport " + this.transactionSupport;
        string = string + "\n configProperties " + this.configProperties;
        string = string + "\n authMechanisms " + this.authMechanisms;
        string = string + "\n securityPermissions " + this.securityPermissions;
        string = string + "\n displayName " + this.displayName;
        string = string + "\n connector_description " + this.connectorDescription;
        string = string + "\n license_description " + this.licenseDescription;
        string = string + "\n eisType " + this.eisType;
        string = string + "\n smallIcon " + this.smallIcon;
        string = string + "\n largeIcon " + this.largeIcon;
        string = string + "\n licenseRequired " + this.licenseRequired;
        string = string + "\n specVersion " + this.specVersion;
        string = string + "\n vendorName " + this.vendorName;
        string = string + "\n version " + this.version;
        return string;
    }

    public void changed() {
        super.changed();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty() {
        this.isDirty = true;
    }

    void doneOpening() {
        this.isDirty = false;
        this.changed();
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed();
    }

    public void setName(String string) {
        if (!this.getName().equals(string)) {
            this.setDirty();
            super.setName(string);
        }
    }

    public void setDescription(String string) {
        this.setDirty();
        super.setDescription(string);
    }

    public void setSmallIconUri(String string) {
        this.setDirty();
        super.setSmallIconUri(string);
    }

    public void setLargeIconUri(String string) {
        this.setDirty();
        super.setLargeIconUri(string);
    }

    public SunConnector getSunDescriptor() {
        return this.sunConnector;
    }

    public void setSunDescriptor(SunConnector sunConnector) {
        this.sunConnector = sunConnector;
    }
}

