/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appverification.factory;

import com.sun.enterprise.appverification.factory.InstrumentLogger;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AppVerification {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    private static boolean instrument_on = false;
    private static boolean redeploy = false;
    private static InstrumentLogger instrumentLogger;
    private static LocalStringManagerImpl localStrings;

    public static void redeploy(boolean bl) {
        redeploy = bl;
    }

    public static boolean hasRedeployed() {
        return redeploy;
    }

    public static void setInstrument(boolean bl) {
        if (bl && AppVerification.getInstrumentLogger() == null) {
            instrument_on = false;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("appverification.instrument.on.failed", "J2EE instrumentation implementation class NOT defined."));
                _logger.log(Level.FINE, localStrings.getLocalString("appverification.instrument.off", "J2EE Application Verification is OFF..."));
            }
        } else {
            instrument_on = bl;
            if (instrument_on && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("appverification.instrument.on", "J2EE Application Verification {0} is ON...", new Object[]{instrumentLogger.getVersion()}));
            }
        }
    }

    public static boolean doInstrument() {
        return instrument_on;
    }

    public static InstrumentLogger getInstrumentLogger() {
        if (instrumentLogger == null) {
            String string = null;
            Class<?> clazz = null;
            try {
                string = System.getProperty("j2ee.instrument.logger", "com.sun.enterprise.appverification.tools.InstrumentLoggerImpl");
                clazz = Class.forName(string);
                if (clazz != null) {
                    instrumentLogger = (InstrumentLogger)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                _logger.log(Level.SEVERE, "appverification.class_notfound", new Object[]{string});
            }
            catch (InstantiationException instantiationException) {
                _logger.log(Level.SEVERE, "appverification.class_instantiate_error", new Object[]{string});
            }
            catch (IllegalAccessException illegalAccessException) {
                _logger.log(Level.SEVERE, "appverification.class_access_error", new Object[]{string});
            }
        }
        return instrumentLogger;
    }

    static {
        localStrings = new LocalStringManagerImpl(AppVerification.class);
    }
}

