/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.appclient.HttpAuthenticator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.web.server.HttpsURLStreamHandlerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.security.auth.login.FailedLoginException;

public class Main {
    private static final String CLIENT = "-client";
    private static final String NAME = "-name";
    private static final String TEXT_AUTH = "-textauth";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Main.class);
    private static boolean guiAuth;

    public static void main(String[] stringArray) {
        Utility.checkJVMVersion();
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        J2EESecurityManager j2EESecurityManager = new J2EESecurityManager();
        System.setSecurityManager(j2EESecurityManager);
        KeyTool.initProvider();
        guiAuth = Boolean.valueOf(System.getProperty("auth.gui", "true"));
        if (stringArray.length < 1) {
            Main.usage();
        } else {
            while (n < stringArray.length) {
                if ((string = stringArray[n++]).equals(CLIENT)) {
                    if (n < stringArray.length) {
                        string2 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(NAME)) {
                    if (n < stringArray.length) {
                        string3 = stringArray[n++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (string.equals(TEXT_AUTH)) {
                    guiAuth = false;
                    continue;
                }
                vector.add(string);
            }
        }
        if (string2 == null) {
            Main.usage();
        }
        boolean bl = false;
        AppContainer appContainer = null;
        Cleanup cleanup = new Cleanup();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(cleanup);
        try {
            Object object;
            URL[] uRLArray;
            Object object2;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL.setURLStreamHandlerFactory(new HttpsURLStreamHandlerFactory());
                    return null;
                }
            });
            File file = new File(string2);
            if (ApplicationArchivist.isApplication(file)) {
                if (string3 == null) {
                    Main.usage();
                }
                object2 = ApplicationArchivist.open(file);
                uRLArray = ((Application)object2).getApplicationClientDescriptors().iterator();
                while (uRLArray.hasNext()) {
                    object = (ApplicationClientDescriptor)uRLArray.next();
                    if (!((Descriptor)object).getName().equals(string3)) continue;
                    appContainer = new AppContainer((ApplicationClientDescriptor)object, guiAuth);
                    file = Main.getClientJar((BundleDescriptor)object);
                }
            } else {
                object2 = ApplicationClientArchivist.open(file);
                appContainer = new AppContainer((ApplicationClientDescriptor)object2, guiAuth);
            }
            if (appContainer == null) {
                System.err.println(localStrings.getLocalString("main.no_appclient_descriptors_defined", "No application client descriptors defined for: {0}", new Object[]{string3}));
                System.exit(1);
            }
            Authenticator.setDefault(new HttpAuthenticator(appContainer));
            object2 = appContainer.preInvoke();
            cleanup.setAppContainer(appContainer);
            uRLArray = new URL[]{file.toURL()};
            object = new URLClassLoader(uRLArray);
            Thread.currentThread().setContextClassLoader((ClassLoader)object);
            Class<?> clazz = ((ClassLoader)object).loadClass((String)object2);
            String[] stringArray2 = new String[vector.size()];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = (String)vector.elementAt(i);
            }
            Utility.invokeApplicationMain(clazz, stringArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            System.err.println(localStrings.getLocalString("main.exception", "Application threw an exception:{0}", new Object[]{throwable}));
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (throwable instanceof FailedLoginException) {
                boolean bl2 = Boolean.valueOf(System.getProperty("auth.gui", "true"));
                String string4 = localStrings.getLocalString("main.exception.loginError", "Incorrect login and/or password");
                System.out.println(string4);
                if (bl2) {
                    GUIErrorDialog gUIErrorDialog = new GUIErrorDialog(string4);
                    gUIErrorDialog.show();
                } else {
                    System.out.println(string4);
                }
            }
            System.err.println(localStrings.getLocalString("main.exception", "Application threw an exception:{0}", new Object[]{throwable}));
            System.exit(1);
        }
    }

    private static File getClientJar(BundleDescriptor bundleDescriptor) throws IOException {
        String string = bundleDescriptor.getApplication().getName() + ".tmpjar";
        File file = new File(FileUtil.getTempDirectory(), string);
        file.deleteOnExit();
        bundleDescriptor.getApplication().getApplicationArchivist().extractBundleToFile(bundleDescriptor, file);
        return file;
    }

    private static void usage() {
        System.out.println(localStrings.getLocalString("main.usage", "runclient -client <appjar> [-name <name>] [app-args]"));
        System.exit(1);
    }

    private static class Cleanup
    extends Thread {
        private AppContainer appContainer = null;
        private boolean cleanedUp = false;

        public void setAppContainer(AppContainer appContainer) {
            this.appContainer = appContainer;
        }

        public void run() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUp() {
            if (!this.cleanedUp) {
                try {
                    if (this.appContainer != null) {
                        this.appContainer.postInvoke();
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.cleanedUp = true;
                }
            }
        }
    }
}

